package cn.easyutil.easyapi.entity.db.auth;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;

/**
 * 角色
 */
@Tne("EASYAPI_ROLE")
public class DBRoleEntity extends BaseDbEntity {

    @Tfd("ROLE_NAME")
    @ApidocComment("角色名称")
    private String roleName;

    @Tfd("DESCRIPTION")
    @ApidocComment("角色说明")
    private String description;

    @Tfd("DEFAULT_ROLE")
    @ApidocComment("是否默认角色：0-否 1-是")
    private Integer defaultRole;

    @Tfd("SUPER_ADMIN_STATUS")
    @ApidocComment("是否超级管理员:0-不是  1-是")
    private Integer superAdminStatus;

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getSuperAdminStatus() {
        return superAdminStatus;
    }

    public void setSuperAdminStatus(Integer superAdminStatus) {
        this.superAdminStatus = superAdminStatus;
    }

    public Integer getDefaultRole() {
        return defaultRole;
    }

    public void setDefaultRole(Integer defaultRole) {
        this.defaultRole = defaultRole;
    }
}
