package cn.easyutil.easyapi.entity.common;

import java.lang.annotation.*;

/** 标记文档说明 */
@Target({ElementType.METHOD,ElementType.FIELD,ElementType.TYPE,ElementType.PARAMETER})
@Retention(RetentionPolicy.RUNTIME)
@Documented 
public @interface ApidocComment {
	//字段描述
	String value()default"";
	//字段值样例
	String mockValue()default"";
	//特殊说明,通常用于接口
	String notes()default"";
	//是否必填
	boolean required()default true;
	//是否隐藏
	boolean hidden()default false;
	//是否忽略
	boolean ignore()default false;
	//校验值，可使用el表达式
	String[] conditions() default {};
	//请求参数说明
	String requestNotes()default"";
	//返回参数说明
	String responseNotes()default"";
}
