package cn.easyutil.easyapi.content;

import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiConfiguration;
import cn.easyutil.easyapi.datasource.EasyapiBindSqlExecution;
import cn.easyutil.easyapi.entity.db.doc.DBModuleOutPackageEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.filter.*;
import cn.easyutil.easyapi.logic.el.DefaultSpelValueParser;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 接口文档生成时需要使用到的变量
 */
public class ProjectContext {

    /**
     * 项目根目录
     */
    public static String projectBasePath = "";

    public static String dbPath = "./apidoc-db/";

    public static String dbFileName = "easyapi";

    /**
     * 没有key的参数默认key
     */
    public static final String nullKey = "_null";

    public static Long currentProjectId = null;

    public static Long currentModuleId = null;

    public static String currentProjectName = null;

    public static String currentModuleName = null;

    public static AllConfiguration allConfiguration;

    public static EasyapiBindSqlExecution execution;



    public static String javaMockRemark(){
        StringBuffer sb = new StringBuffer("java mock字段表达式");
        sb.append(newLine());
        sb.append("${char}:默认4个随机数字+字母" + newLine());
        sb.append("${char(name)}:随机一个中文昵称" + newLine());
        sb.append("${char(text)}:随机一个中文文本内容" + newLine());
        sb.append("${char(ho)}:随机一个公司名称" + newLine());
        sb.append("${char(address)}:随机一个中文地址" + newLine());
        sb.append("${char(mobile)}:随机一个手机号码" + newLine());
        sb.append("${char(md5)}:随机一个md5串" + newLine());
        sb.append("${char(aes)}:随机一个aes串" + newLine());
        sb.append("${int}:随机取0或1" + newLine());
        sb.append("${int(10)}:随机取0-10之间的数字,范围可自定义" + newLine());
        sb.append("${int(1,10)}:随机取1-10之间的数字,范围可自定义" + newLine());
        sb.append("${double}:随机取0到1之间的小数，保留2位" + newLine());
        sb.append("${double(10)}:随机取0到10之间的小数，保留2位,范围可自定义" + newLine());
        sb.append("${double(1,10)}:随机取1到10之间的小数，保留2位,范围可自定义" + newLine());
        sb.append("${time}:取当前时间戳，13位" + newLine());
        sb.append("${time()}:当前时间转换字符串，默认yyyy-MM-dd HH:mm:ss");
        sb.append("${time(yyyy-MM-dd HH:mm:ss)}:当前时间转换字符串，表达式可自定义" + newLine());
        sb.append("${url}:随机一个图片网络地址" + newLine());
        sb.append("${url(pic)}:随机一个图片网络地址" + newLine());
        sb.append("${url(vod)}:随机一个视频网络地址" + newLine());
        return sb.toString();
    }

    private static String newLine() {
        return "</br>";
    }

    public static List<DBModuleOutPackageEntity> initOutPackageFile() {
        // 创建返回外包装
        List<DBModuleOutPackageEntity> list = new ArrayList<>();
        DBModuleOutPackageEntity mp1 = new DBModuleOutPackageEntity();
        mp1.setKey("code");
        mp1.setVal("200");
        mp1.setDefaultStatus(0);
        mp1.setType(0);
        list.add(mp1);
        DBModuleOutPackageEntity mp2 = new DBModuleOutPackageEntity();
        mp2.setKey("data");
        mp2.setDefaultStatus(1);
        list.add(mp2);
        DBModuleOutPackageEntity mp3 = new DBModuleOutPackageEntity();
        mp3.setKey("errCode");
        mp3.setDefaultStatus(0);
        list.add(mp3);
        DBModuleOutPackageEntity mp4 = new DBModuleOutPackageEntity();
        mp4.setKey("errMsg");
        mp4.setDefaultStatus(0);
        list.add(mp4);
        DBModuleOutPackageEntity mp5 = new DBModuleOutPackageEntity();
        mp5.setKey("page");
        mp5.setDefaultStatus(0);
        Map<String, Integer> page = new HashMap<String, Integer>();
        page.put("currentPage", 1);
        page.put("showCount", 2);
        page.put("totalPage", 1);
        page.put("totalResult", 2);
        mp5.setVal(JsonUtil.beanToJson(page));
        list.add(mp5);
        return list;
    }
}
