package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.interview.controller.*;
import cn.easyutil.easyapi.javadoc.html.StaticDocCreate;
import cn.easyutil.easyapi.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

/**
 * spring项目启动必须配置的类
 */
@Component
public class SpringRunEnvClassComponent implements ApplicationContextAware {

    @Autowired
    private static ApplicationContext appContext;

    @Bean(name = "easyapiStaticDocCreate")
    public StaticDocCreate staticDocCreate(){return new StaticDocCreate();}

    //-----------以下装配controller----------------------------
    @Bean(name = "easyapiComplexApidocController")
    public ComplexApidocController easyapiComplexApidocController(){
        return new ComplexApidocController();
    }
    @Bean(name = "easyapiModuleController")
    public ModuleController easyapiModuleController(){
        return new ModuleController();
    }
    @Bean(name = "easyapiProjectController")
    public ProjectController easyapiProjectController(){
        return new ProjectController();
    }
    @Bean(name = "easyapiRoleAuthController")
    public RoleAuthController easyapiRoleAuthController(){
        return new RoleAuthController();
    }
    @Bean(name = "easyapiSimpleApidocController")
    public SimpleApidocController easyapiSimpleApidocController(){
        return new SimpleApidocController();
    }
    @Bean(name = "easyapiUnitController")
    public UnitController easyapiUnitController(){
        return new UnitController();
    }
    @Bean(name = "easyapiUserController")
    public UserController easyapiUserController(){
        return new UserController();
    }
    @Bean(name = "easyapiUnifiedAccessController")
    public UnifiedAccessController easyapiUnifiedAccessController(){
        return new UnifiedAccessController();
    }


    //-----------以下装配service--------------------
    @Bean(name = "easyapiControllerService")
    public ControllerService easyapiControllerService(){
        return new ControllerService();
    }
    @Bean(name = "easyapiDBService")
    public DBService easyapiDBService(){
        return new DBService();
    }
    @Bean(name = "easyapiEnvService")
    public EnvService easyapiEnvService(){
        return new EnvService();
    }
    @Bean(name = "easyapiScriptService")
    public ScriptService easyapiScriptService(){return new ScriptService();}
    @Bean(name = "easyapiArticleService")
    public ArticleService easyapiArticleService(){return new ArticleService();}
    @Bean(name = "easyapiHeaderService")
    public HeaderService headerService(){
        return new HeaderService();
    }
    @Bean(name = "easyapiHostService")
    public HostService easyapiHostService(){
        return new HostService();
    }
    @Bean(name = "easyapiInterfaceParamService")
    public InterfaceParamService easyapiInterfaceParamService(){
        return new InterfaceParamService();
    }
    @Bean(name = "easyapiInterfaceService")
    public InterfaceService easyapiInterfaceService(){
        return new InterfaceService();
    }
    @Bean(name = "easyapiModuleService")
    public ModuleService easyapiModuleService(){
        return new ModuleService();
    }
    @Bean(name = "easyapiOutPackageService")
    public OutPackageService easyapiOutPackageService(){
        return new OutPackageService();
    }
    @Bean(name = "easyapiParamService")
    public ParamService easyapiParamService(){
        return new ParamService();
    }
    @Bean(name = "easyapiProjectService")
    public ProjectService easyapiProjectService(){
        return new ProjectService();
    }
    @Bean(name = "easyapiRoleAuthService")
    public RoleAuthService easyapiRoleAuthService(){
        return new RoleAuthService();
    }
    @Bean(name = "easyapiUserTemporaryAuthService")
    public UserTemporaryAuthService easyapiUserTemporaryAuthService(){
        return new UserTemporaryAuthService();
    }
    @Bean(name = "easyapiSimpleUnitService")
    public SimpleUnitService simpleUnitService(){
        return new SimpleUnitService();
    }
    @Bean(name = "easyapiRoleProjectService")
    public RoleProjectService easyapiRoleProjectService(){
        return new RoleProjectService();
    }
    @Bean(name = "easyapiRoleService")
    public RoleService easyapiRoleService(){
        return new RoleService();
    }
    @Bean(name = "easyapiTestGroupService")
    public TestGroupService easyapiTestGroupService(){
        return new TestGroupService();
    }
    @Bean(name = "easyapiTestInfoService")
    public TestInfoService easyapiTestInfoService(){
        return new TestInfoService();
    }
    @Bean(name = "easyapiTestService")
    public TestService easyapiTestService(){
        return new TestService();
    }
    @Bean(name = "easyapiUserService")
    public UserService easyapiUserService(){
        return new UserService();
    }



    @Override
    public void setApplicationContext(ApplicationContext applicationContext) {
        appContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return appContext;
    }
}
