package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.filter.*;
import cn.easyutil.easyapi.filter.model.*;
import cn.easyutil.easyapi.logic.el.DefaultSpelMethodParser;
import cn.easyutil.easyapi.logic.el.ElExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix = "easyapi.filter")
public class EasyapiFilterConfiguration {

    /** 读取实体bean拦截器*/
    private Class<? extends ReadJavaBeanApiFilter> readBeanApiFilter = DefaultReadJavaBeanApi.class;

    /** 读取控制器拦截器*/
    private Class<? extends ReadControllerApiFilter> readControllerApiFilter = DefaultReadControllerApi.class;

    /** 读取接口拦截器*/
    private Class<? extends ReadInterfaceApiFilter> readInterfaceApiFilter = DefaultReadInterfaceApi.class;

    /** 读取请求参数拦截器*/
    private Class<? extends ReadRequestParamApiFilter> readRequestParamApiFilter = DefaultReadRequestParamApi.class;

    /** 读取返回参数拦截器*/
    private Class<? extends ReadResponseParamApiFilter> readResponseParamApiFilter = DefaultReadResponseParamApi.class;

    /** mock解析*/
    private Class<? extends ReadMockTemplateFilter> readMockTemplateFilter = DefaultReadMockTemplate.class;


    public Class<? extends ReadJavaBeanApiFilter> getReadBeanApiFilter() {
        return readBeanApiFilter;
    }

    public void setReadBeanApiFilter(Class<? extends ReadJavaBeanApiFilter> readBeanApiFilter) {
        this.readBeanApiFilter = readBeanApiFilter;
    }

    public Class<? extends ReadControllerApiFilter> getReadControllerApiFilter() {
        return readControllerApiFilter;
    }

    public void setReadControllerApiFilter(Class<? extends ReadControllerApiFilter> readControllerApiFilter) {
        this.readControllerApiFilter = readControllerApiFilter;
    }

    public Class<? extends ReadInterfaceApiFilter> getReadInterfaceApiFilter() {
        return readInterfaceApiFilter;
    }

    public void setReadInterfaceApiFilter(Class<? extends ReadInterfaceApiFilter> readInterfaceApiFilter) {
        this.readInterfaceApiFilter = readInterfaceApiFilter;
    }

    public Class<? extends ReadRequestParamApiFilter> getReadRequestParamApiFilter() {
        return readRequestParamApiFilter;
    }

    public void setReadRequestParamApiFilter(Class<? extends ReadRequestParamApiFilter> readRequestParamApiFilter) {
        this.readRequestParamApiFilter = readRequestParamApiFilter;
    }

    public Class<? extends ReadResponseParamApiFilter> getReadResponseParamApiFilter() {
        return readResponseParamApiFilter;
    }

    public void setReadResponseParamApiFilter(Class<? extends ReadResponseParamApiFilter> readResponseParamApiFilter) {
        this.readResponseParamApiFilter = readResponseParamApiFilter;
    }

    public Class<? extends ReadMockTemplateFilter> getReadMockTemplateFilter() {
        return readMockTemplateFilter;
    }

    public void setReadMockTemplateFilter(Class<? extends ReadMockTemplateFilter> readMockTemplateFilter) {
        this.readMockTemplateFilter = readMockTemplateFilter;
    }
}
