/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ReadJavaBeanApiFilter;
import cn.easyutil.easyapi.filter.ReadMockTemplateFilter;
import cn.easyutil.easyapi.javadoc.reader.FieldComment;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceComment;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceReader;
import cn.easyutil.easyapi.logic.creator.CreatorCommonMethod;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class JavaBeanCreator {
    public static final String nullKey = "_null";
    private ReadJavaBeanApiFilter filter;
    private ReadMockTemplateFilter mockFilter;
    private String projectBasePath;
    private ApiExtra extra;

    public static JavaBeanCreator builder(ReadJavaBeanApiFilter filter, String projectBasePath, ReadMockTemplateFilter mockFilter, ApiExtra extra) {
        JavaBeanCreator creator = new JavaBeanCreator(filter, projectBasePath, mockFilter, extra);
        return creator;
    }

    public JavaBeanCreator(ReadJavaBeanApiFilter filter, String projectBasePath, ReadMockTemplateFilter mockFilter, ApiExtra extra) {
        this.filter = filter;
        this.projectBasePath = projectBasePath;
        this.mockFilter = mockFilter;
        this.extra = extra;
    }

    private String buildCreatersKey(Class aClass, GenericTypeBind bind) {
        String bindKey = "";
        if (bind.keys().size() > 0) {
            for (String key : bind.keys()) {
                bindKey = bindKey + bind.get(key);
            }
        }
        return aClass.getCanonicalName() + bindKey;
    }

    public List<DocParamEntity> readBean(Type type, GenericTypeBind binds, Map<String, List<DocParamEntity>> exists) {
        if (binds == null) {
            binds = new GenericTypeBind();
        }
        Class aClass = GenericTypeUtil.getOwnerClass(type);
        GenericTypeBind currentBinds = GenericTypeUtil.getGenericTypes(type);
        binds.binds(currentBinds);
        if (aClass == Object.class || aClass == Class.class) {
            return Collections.emptyList();
        }
        String creatersKey = this.buildCreatersKey(aClass, currentBinds);
        if (exists.containsKey(creatersKey)) {
            return JsonUtil.jsonToList(JsonUtil.beanToJson(exists.get(creatersKey)), DocParamEntity.class);
        }
        exists.put(creatersKey, Collections.emptyList());
        ArrayList<DocParamEntity> bean = new ArrayList();
        JavaType javaType = JavaType.getJavaTypeByType(type);
        switch (javaType) {
            case Object: {
                bean = this.getBean(aClass, binds, exists);
                break;
            }
            case ArrayObject: {
                bean = this.readArrayObject(type, binds, exists);
                break;
            }
            case Array: {
                bean = this.readArray(type, binds);
            }
        }
        exists.put(creatersKey, bean);
        return bean;
    }

    public List<DocParamEntity> readArray(Type type, GenericTypeBind binds) {
        if (binds == null) {
            binds = new GenericTypeBind();
        }
        Type arrayType = GenericTypeUtil.getOwnerClass(type);
        if (GenericTypeUtil.isGeneric(type)) {
            GenericTypeBind genericTypeBind = GenericTypeUtil.getGenericTypes(type);
            Type bindType = binds.matchVariable(genericTypeBind.get(0).getTypeName());
            arrayType = bindType != null ? bindType : genericTypeBind.get(0);
        }
        DocParamEntity childrean = new DocParamEntity();
        childrean.setRequired(0);
        childrean.setShow(0);
        childrean.setJavaType(JavaType.getJavaTypeByType(arrayType).getType());
        childrean.setClassName(type.getTypeName());
        childrean.setName(nullKey);
        Object mockValue = this.mockFilter.mock(childrean.getMockTemplate(), JavaType.getType(childrean.getJavaType()));
        childrean.setMockValue(ObjectUtil.isBaseObject(mockValue) ? mockValue.toString() : JsonUtil.beanToJson(mockValue));
        return Collections.singletonList(childrean);
    }

    public List<DocParamEntity> readArrayObject(Type type, GenericTypeBind binds, Map<String, List<DocParamEntity>> exists) {
        if (binds == null) {
            binds = new GenericTypeBind();
        }
        Class<Map> arrayType = GenericTypeUtil.getOwnerClass(type);
        if (GenericTypeUtil.isGeneric(type) && Collection.class.isAssignableFrom(GenericTypeUtil.getOwnerClass((Type)((Object)arrayType)))) {
            arrayType = binds.get(0);
        }
        if (arrayType instanceof Class && Collection.class.isAssignableFrom(GenericTypeUtil.getOwnerClass((Type)((Object)arrayType)))) {
            arrayType = Map.class;
        }
        return this.readBean((Type)((Object)arrayType), binds, exists);
    }

    private List<DocParamEntity> getBean(Class beanClass, GenericTypeBind binds, Map<String, List<DocParamEntity>> exists) {
        this.extra.setModelField(null);
        this.extra.setFieldComment(null);
        ArrayList<DocParamEntity> result = new ArrayList<DocParamEntity>();
        HashSet<String> fieldNames = new HashSet<String>();
        for (Class clazz = beanClass; clazz != null && !clazz.equals(Object.class) && clazz != Class.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            this.extra.setModelClass(clazz);
            JavaSourceReader classFileReader = JavaSourceReader.builder(CreatorCommonMethod.getClassFile(clazz, this.projectBasePath));
            List<FieldComment> fieldComments = classFileReader.getComment().getFields();
            Map<String, FieldComment> fieldComment = fieldComments.stream().collect(Collectors.toMap(JavaSourceComment::getName, item -> item));
            for (Field field : fields = clazz.getDeclaredFields()) {
                Object bindType;
                this.extra.setModelField(field);
                this.extra.setFieldComment(Optional.ofNullable(fieldComment.get(field.getName())).orElse(new FieldComment()));
                if (this.filter.ignore(clazz, binds, field, this.extra)) continue;
                int size = fieldNames.size();
                fieldNames.add(field.getName());
                if (size == fieldNames.size()) continue;
                Class<Map> type = field.getGenericType();
                Class<Map> ownerClass = GenericTypeUtil.getOwnerClass((Type)((Object)type));
                GenericTypeBind currentBinds = GenericTypeUtil.getGenericTypes((Type)((Object)type));
                type = this.filter.type(ownerClass, binds, (Type)((Object)type), this.extra);
                ownerClass = GenericTypeUtil.getOwnerClass((Type)((Object)type));
                currentBinds = GenericTypeUtil.getGenericTypes((Type)((Object)type));
                if (GenericTypeUtil.isGeneric((Type)((Object)type)) && !GenericTypeUtil.isArray((Type)((Object)type)) && (bindType = binds.matchVariable(type.getTypeName())) != null) {
                    type = bindType;
                    ownerClass = GenericTypeUtil.getOwnerClass((Type)((Object)type));
                }
                bindType = currentBinds.keys().iterator();
                while (bindType.hasNext()) {
                    String key = (String)bindType.next();
                    Type matchType = binds.matchVariable(currentBinds.get(key).getTypeName());
                    if (matchType == null) continue;
                    currentBinds.bind(key, matchType);
                }
                String description = this.filter.description(ownerClass, binds, field, this.extra);
                if (StringUtil.isEmpty(description)) {
                    description = field.getName();
                }
                if (!(GenericTypeUtil.isArray((Type)((Object)type)) || ownerClass != Object.class && ownerClass != Class.class)) {
                    ownerClass = Map.class;
                    type = Map.class;
                }
                JavaType javaType = this.filter.javaType(ownerClass, binds, (Type)((Object)type), this.extra);
                DocParamEntity entity = new DocParamEntity();
                entity.setName(field.getName());
                entity.setClassName(ownerClass.getCanonicalName());
                entity.setDescription(description);
                entity.setJavaType(javaType.getType());
                entity.setMockTemplate(this.filter.mockTemplate(ownerClass, binds, field, this.extra));
                entity.setShow(this.filter.show(ownerClass, binds, field, this.extra) ? 1 : 0);
                entity.setRequired(this.filter.required(ownerClass, binds, field, this.extra) ? 1 : 0);
                entity.setConditionTemplate(this.filter.conditons(ownerClass, binds, field, this.extra).stream().collect(Collectors.joining(",")));
                switch (JavaType.getType(entity.getJavaType())) {
                    case Object: 
                    case ArrayObject: 
                    case Array: {
                        entity.setChildren(this.readBean((Type)((Object)type), currentBinds, exists));
                        break;
                    }
                    default: {
                        Object mockValue = this.mockFilter.mock(entity.getMockTemplate(), javaType);
                        entity.setMockValue(ObjectUtil.isBaseObject(mockValue) ? mockValue.toString() : JsonUtil.beanToJson(mockValue));
                    }
                }
                result.add(entity);
            }
        }
        return result;
    }
}

