/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.javadoc.reader;

import cn.easyutil.easyapi.javadoc.reader.AnnotationComment;
import cn.easyutil.easyapi.javadoc.reader.AnnotationPair;
import cn.easyutil.easyapi.javadoc.reader.ClassComment;
import cn.easyutil.easyapi.javadoc.reader.FieldComment;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.javadoc.reader.SourceParameterComment;
import cn.easyutil.easyapi.util.StringUtil;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class JavaSourceReader {
    private ClassComment classComment = new ClassComment();

    public static JavaSourceReader builder(File file) {
        try {
            if (!file.exists()) {
                return new JavaSourceReader();
            }
            return JavaSourceReader.builder(new FileInputStream(file));
        }
        catch (Exception e) {
            return new JavaSourceReader();
        }
    }

    public static JavaSourceReader builder(InputStream in) {
        JavaSourceReader reader = new JavaSourceReader();
        JavaParser parser = new JavaParser();
        ParseResult parse = parser.parse(in);
        if (!parse.getCommentsCollection().isPresent()) {
            return reader;
        }
        reader.parse((CompilationUnit)parse.getResult().get());
        return reader;
    }

    public void parse(CompilationUnit unit) {
        this.classComment.setSource(((TokenRange)unit.getTokenRange().get()).toString());
        for (TypeDeclaration typeDec : unit.getTypes()) {
            NodeList members;
            if (typeDec instanceof ClassOrInterfaceDeclaration) {
                this.parseClass((ClassOrInterfaceDeclaration)typeDec);
            }
            if ((members = typeDec.getMembers()) == null) continue;
            for (BodyDeclaration member : members) {
                this.parseMember(member);
            }
        }
    }

    private void parseClass(ClassOrInterfaceDeclaration declaration) {
        this.classComment.setName(declaration.getNameAsString());
        this.classComment.setComment(declaration.getComment().isPresent() ? ((Comment)declaration.getComment().get()).getContent() : "");
        this.classComment.setModifyers(declaration.getModifiers() == null || declaration.getModifiers().size() == 0 ? "" : ((Modifier)declaration.getModifiers().get(0)).toString());
        this.classComment.setExtendsClassName(declaration.getExtendedTypes() == null || declaration.getExtendedTypes().size() == 0 ? "Object" : ((ClassOrInterfaceType)declaration.getExtendedTypes().get(0)).getName().asString());
        NodeList implementedTypes = declaration.getImplementedTypes();
        if (implementedTypes != null && implementedTypes.size() > 0) {
            for (ClassOrInterfaceType implementedType : implementedTypes) {
                this.classComment.addImplClassNames(implementedType.getName().asString());
            }
        }
        this.classComment.addAllAnnotations(this.readAnnotations((BodyDeclaration)declaration));
    }

    private void parseMember(BodyDeclaration member) {
        if (member instanceof MethodDeclaration) {
            this.classComment.addMethod(this.readMethodComment((MethodDeclaration)member));
        }
        if (member instanceof FieldDeclaration) {
            this.classComment.addField(this.readFieldComment((FieldDeclaration)member));
        }
    }

    private FieldComment readFieldComment(FieldDeclaration declaration) {
        NodeList variables;
        FieldComment comment = new FieldComment();
        comment.setSource(this.getSourceCode(declaration.getTokenRange()));
        comment.setComment(declaration.getComment().isPresent() ? ((Comment)declaration.getComment().get()).getContent() : "");
        NodeList modifiers = declaration.getModifiers();
        if (modifiers != null && modifiers.size() > 0) {
            comment.setModifyers(((Modifier)modifiers.get(0)).toString());
        }
        if ((variables = declaration.getVariables()) != null && variables.size() > 0) {
            comment.setName(((VariableDeclarator)variables.get(0)).getName().asString());
        }
        comment.addAllAnnotations(this.readAnnotations((BodyDeclaration)declaration));
        return comment;
    }

    private List<AnnotationComment> readAnnotations(NodeList<AnnotationExpr> annotations) {
        ArrayList<AnnotationComment> comments = new ArrayList<AnnotationComment>();
        for (AnnotationExpr annotation : annotations) {
            AnnotationPair pair;
            AnnotationComment comment = new AnnotationComment();
            comment.setAnnotationName(annotation.getNameAsString());
            comment.setAnnotationComment(annotation.getComment().isPresent() ? ((Comment)annotation.getComment().get()).getContent() : "");
            comment.setAnnotationSource(annotation.getTokenRange().isPresent() ? ((TokenRange)annotation.getTokenRange().get()).toString() : "");
            ArrayList<AnnotationPair> pairs = new ArrayList<AnnotationPair>();
            if (annotation instanceof MarkerAnnotationExpr) {
                pair = new AnnotationPair();
                pair.setName("value");
                pair.setValue("");
                pairs.add(pair);
            }
            if (annotation instanceof SingleMemberAnnotationExpr) {
                pair = new AnnotationPair();
                pair.setName("value");
                Optional tokenRange = ((SingleMemberAnnotationExpr)annotation).getMemberValue().getTokenRange();
                pair.setValue(this.getSourceCode(tokenRange));
                pairs.add(pair);
            }
            if (annotation instanceof NormalAnnotationExpr) {
                NodeList pairNodeList = ((NormalAnnotationExpr)annotation).getPairs();
                for (MemberValuePair valuePair : pairNodeList) {
                    AnnotationPair pair2 = new AnnotationPair();
                    pair2.setName(valuePair.getNameAsString());
                    pair2.setValue(valuePair.getValue().toString());
                    pairs.add(pair2);
                }
            }
            comment.setPairs(pairs);
            comments.add(comment);
        }
        return comments;
    }

    private List<AnnotationComment> readAnnotations(BodyDeclaration declaration) {
        NodeList annotations = declaration.getAnnotations();
        if (annotations == null || annotations.size() == 0) {
            return null;
        }
        return this.readAnnotations((NodeList<AnnotationExpr>)annotations);
    }

    private MethodComment readMethodComment(MethodDeclaration declaration) {
        NodeList modifiers;
        MethodComment comment = new MethodComment();
        comment.setSource(this.getSourceCode(declaration.getTokenRange()));
        String methodComment = declaration.getComment().isPresent() ? ((Comment)declaration.getComment().get()).getContent() : "";
        comment.setComment(methodComment);
        comment.setReturnType(declaration.getType().asString());
        NodeList parameters = declaration.getParameters();
        if (!StringUtil.isEmpty(methodComment) && methodComment.contains("@return")) {
            comment.setReturnComment(methodComment.substring(methodComment.indexOf("@return") + 7).trim());
        }
        if (parameters != null && parameters.size() > 0) {
            Map<String, String> fieldCommentByMethod = this.getFieldCommentByMethod2(methodComment);
            for (Parameter parameter : parameters) {
                SourceParameterComment spc = new SourceParameterComment();
                spc.setName(parameter.getName().asString());
                spc.setComment(parameter.getComment().isPresent() ? ((Comment)parameter.getComment().get()).getContent() : "");
                if (StringUtil.isEmpty(spc.getComment())) {
                    spc.setComment(fieldCommentByMethod.get(spc.getName()));
                }
                spc.setModifyers(parameter.getModifiers() == null || parameter.getModifiers().isEmpty() ? "" : ((Modifier)parameter.getModifiers().get(0)).toString());
                spc.addAllAnnotations(this.readAnnotations((NodeList<AnnotationExpr>)parameter.getAnnotations()));
                comment.addParameter(spc);
            }
        }
        if ((modifiers = declaration.getModifiers()) != null && modifiers.size() > 0) {
            comment.setModifyers(((Modifier)modifiers.get(0)).toString());
        }
        comment.setName(declaration.getName().asString());
        comment.addAllAnnotations(this.readAnnotations((BodyDeclaration)declaration));
        return comment;
    }

    private Map<String, String> getFieldCommentByMethod2(String methodComment) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtil.isEmpty(methodComment)) {
            return result;
        }
        String splitComment = methodComment;
        while (splitComment.contains("@param")) {
            String val = splitComment.substring(splitComment.indexOf("@param") + 6).trim();
            String key = null;
            if (val.contains("@")) {
                key = val.substring(0, val.indexOf("@"));
                splitComment = val.substring(key.length());
            } else {
                splitComment = "";
                key = val;
            }
            if (!key.contains(" ")) continue;
            String fieldName = null;
            ArrayList<String> fieldComment = new ArrayList<String>();
            key = key.replaceAll("\\r\\n", "").replaceAll("\\n", "").replaceAll("\\*", "").trim();
            String[] s1 = key.split(" ");
            StringBuffer sb = new StringBuffer();
            for (String s2 : s1) {
                if (StringUtil.isEmpty(s2)) continue;
                if (StringUtil.isEmpty(fieldName)) {
                    fieldName = s2;
                    continue;
                }
                fieldComment.add(s2);
            }
            if (fieldComment.size() <= 0) continue;
            result.put(fieldName, fieldComment.stream().collect(Collectors.joining(" ")));
        }
        return result;
    }

    private String getSourceCode(Optional<TokenRange> range) {
        if (range == null) {
            return "";
        }
        if (range.isPresent()) {
            return range.get().toString();
        }
        return "";
    }

    public ClassComment getComment() {
        return this.classComment;
    }
}

