/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.datasource.bean.EasyApiBindSqlResult;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHeaderEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleScriptEntity;
import cn.easyutil.easyapi.entity.db.doc.DBMouduleEnvEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestGroupEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestInfoEntity;
import cn.easyutil.easyapi.entity.db.unit.DBSimpleUnitEntity;
import cn.easyutil.easyapi.interview.controller.SimpleApidocController;
import cn.easyutil.easyapi.interview.dto.DoSimpleUnitDto;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.dto.SelectGroupsDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.vo.DoSimpleUnitVo;
import cn.easyutil.easyapi.logic.js.JavaScriptExec;
import cn.easyutil.easyapi.logic.js.ParseVariablesFactory;
import cn.easyutil.easyapi.logic.unit.ComplexTestProcess;
import cn.easyutil.easyapi.service.SimpleUnitService;
import cn.easyutil.easyapi.service.TestGroupService;
import cn.easyutil.easyapi.service.TestInfoService;
import cn.easyutil.easyapi.service.TestService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import cn.easyutil.easyapi.util.http.HttpRes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnMissingBean(name={"easyapiUnitController"})
@RequestMapping(value={"/easyapi/doc/unit"})
public class UnitController {
    @Resource(name="easyapiTestGroupService")
    private TestGroupService groupService;
    @Resource(name="easyapiTestService")
    private TestService testService;
    @Resource(name="easyapiTestInfoService")
    private TestInfoService testInfoService;
    @Resource(name="easyapiSimpleUnitService")
    private SimpleUnitService simpleUnitService;
    @Resource(name="easyapiSimpleApidocController")
    private SimpleApidocController simpleApidocController;

    @ApidocComment(value="\u6761\u4ef6\u67e5\u8be2\u63a5\u53e3\u6d4b\u8bd5\u5206\u7ec4\u5217\u8868")
    @PostMapping(value={"/selectGroups"})
    @AccessAuth(code=1000)
    public EasyApiBindSqlResult<DBComplexTestGroupEntity> selectGroups(@RequestBody SelectGroupsDto dto) {
        DBComplexTestGroupEntity query = new DBComplexTestGroupEntity();
        BeanUtils.copyProperties((Object)dto, (Object)query);
        query.setName(null);
        EasyApiBindSqlResult page = this.groupService.page(EasyapiBindSQLExecuter.build(query).like(!StringUtil.isEmpty(dto.getName()), DBComplexTestGroupEntity::getName, dto.getName(), new Boolean[0]), dto.getCurrentPage(), dto.getShowCount());
        return page;
    }

    @ApidocComment(value="\u6dfb\u52a0\u63a5\u53e3\u6d4b\u8bd5\u5206\u7ec4")
    @PostMapping(value={"/addGroups"})
    @AccessAuth(code=1000)
    public void addGroups(@RequestBody DBComplexTestGroupEntity entity) {
        AssertUtil.isEmpty(entity.getName(), "\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.groupService.insert(entity);
    }

    @ApidocComment(value="\u4fee\u6539\u63a5\u53e3\u6d4b\u8bd5\u5206\u7ec4")
    @PostMapping(value={"/updateGroups"})
    @AccessAuth(code=1000)
    public void updateGroups(@RequestBody DBComplexTestGroupEntity entity) {
        AssertUtil.isNull((Object)entity.getId(), "\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        this.groupService.update(entity);
    }

    @ApidocComment(value="\u5220\u9664\u63a5\u53e3\u6d4b\u8bd5\u5206\u7ec4")
    @PostMapping(value={"/delGroups"})
    @AccessAuth(code=1000)
    public void delGroups(@RequestBody IdDto dto) {
        this.groupService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u6761\u4ef6\u67e5\u8be2\u63a5\u53e3\u6d4b\u8bd5\u5386\u53f2")
    @PostMapping(value={"/selectTests"})
    @AccessAuth(code=1000)
    public EasyApiBindSqlResult<DBComplexTestEntity> selectTests(@RequestBody SelectGroupsDto dto) {
        DBComplexTestEntity query = new DBComplexTestEntity();
        BeanUtils.copyProperties((Object)dto, (Object)query);
        EasyApiBindSqlResult page = this.testService.page(EasyapiBindSQLExecuter.build(query).like(!StringUtil.isEmpty(dto.getName()), DBComplexTestGroupEntity::getName, dto.getName(), new Boolean[0]), dto.getCurrentPage(), dto.getShowCount());
        return page;
    }

    @ApidocComment(value="\u5220\u9664\u63a5\u53e3\u6d4b\u8bd5\u5386\u53f2")
    @PostMapping(value={"/delTests"})
    @AccessAuth(code=1000)
    public void delTests(@RequestBody IdDto dto) {
        this.testService.deleteById(dto.getId());
        DBComplexTestInfoEntity entity = new DBComplexTestInfoEntity();
        entity.setTestId(dto.getId());
        this.testInfoService.delete(entity);
    }

    @ApidocComment(value="\u83b7\u53d6\u4e0a\u6b21\u63a5\u53e3\u6267\u884c\u76f8\u5173\u53c2\u6570")
    @AccessAuth(code=1000)
    public DBSimpleUnitEntity getLastUnit(@RequestBody IdDto dto) {
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setInterfaceId(dto.getId());
        unit.setUserId(CurrentSession.getCurrentUser().getId());
        unit.setProjectId(CurrentSession.getCurrentProjectId());
        return this.simpleUnitService.get(unit);
    }

    @ApidocComment(value="\u6267\u884c\u7f51\u7edc\u8bf7\u6c42")
    @AccessAuth(code=1000)
    public DoSimpleUnitVo doSimpleUnit(@RequestBody DoSimpleUnitDto entity) {
        ArrayList<DBModuleScriptEntity> reqScript = new ArrayList<DBModuleScriptEntity>();
        ArrayList<DBModuleScriptEntity> afterScript = new ArrayList<DBModuleScriptEntity>();
        if (entity.getScripts() != null && !entity.getScripts().isEmpty()) {
            List<DBModuleScriptEntity> scripts = entity.getScripts();
            Iterator iterator = scripts.iterator();
            while (iterator.hasNext()) {
                DBModuleScriptEntity script = (DBModuleScriptEntity)iterator.next();
                String valType = script.getValType();
                if (StringUtil.isEmpty(valType)) continue;
                if (valType.equals("req")) {
                    reqScript.add(script);
                    continue;
                }
                afterScript.add(script);
            }
        }
        for (DBModuleScriptEntity script : reqScript) {
            String params = JavaScriptExec.parseParams(entity.getJsonParams(), script.getScript(), script.getParseType(), script.getParseKey(), ParseVariablesFactory.get(script.getValName()));
            entity.setJsonParams(params);
        }
        long startTime = System.currentTimeMillis();
        HttpRes httpRes = ComplexTestProcess.doUrl(entity, true);
        long endTime = System.currentTimeMillis();
        httpRes.getResponseMsg();
        DoSimpleUnitVo result = new DoSimpleUnitVo();
        result.setResponseCode(httpRes.getResponseCode());
        result.setResponseMsg(httpRes.getResponseMsg());
        result.setResponseHeaders(httpRes.getResponseHeaders());
        result.setAnswerTime(endTime - startTime);
        if (httpRes.getResponseCode() != 200) {
            return result;
        }
        Long userId = CurrentSession.getCurrentUser().getId();
        Long interfaceId = entity.getInterfaceId();
        String jsonParams = entity.getSaveParamsJson();
        String jsonHeaders = entity.getSaveHeadersJson();
        String responseMsg = httpRes.getResponseMsg();
        DBSimpleUnitEntity unit = new DBSimpleUnitEntity();
        unit.setProjectId(CurrentSession.getCurrentProjectId());
        unit.setInterfaceId(interfaceId);
        unit.setUserId(userId);
        DBSimpleUnitEntity query = this.simpleUnitService.get(unit);
        if (query != null) {
            this.simpleUnitService.deleteById(query.getId());
        }
        unit.setJsonHeaders(jsonHeaders);
        unit.setJsonParameters(jsonParams);
        unit.setJsonResponse(responseMsg);
        unit.setJsonPackages(entity.getSavePackageJson());
        unit.setJsonTables(entity.getSaveTableJson());
        unit.setJsonScripts(entity.getScripts() == null ? "[]" : JsonUtil.beanToJson(entity.getScripts()));
        unit.setJsonResHeaders(JsonUtil.beanToJson(httpRes.getResponseHeaders()));
        unit.setAnswerTime(endTime - startTime);
        if (afterScript.isEmpty() || StringUtil.isEmpty(responseMsg)) {
            this.simpleUnitService.insert(unit);
            return result;
        }
        for (DBModuleScriptEntity dto : afterScript) {
            if (StringUtil.isEmpty(dto.getValType()) || StringUtil.isEmpty(dto.getScript())) continue;
            String valType = dto.getValType().toLowerCase().trim();
            if (valType.equals("res")) {
                String params = JavaScriptExec.parseParams(result.getResponseMsg(), dto.getScript(), dto.getParseType(), dto.getParseKey(), ParseVariablesFactory.get(dto.getValName()));
                result.setResponseMsg(params);
                responseMsg = params;
                continue;
            }
            String script = dto.getScript().trim();
            String val = responseMsg;
            if (!script.equals("$data")) {
                val = JavaScriptExec.doSimpleExecute(JsonUtil.jsonToMap(responseMsg), script);
            }
            if (StringUtil.isEmpty(val)) continue;
            if (valType.equals("header")) {
                DBModuleHeaderEntity header = new DBModuleHeaderEntity();
                header.setKey(dto.getValName());
                header.setVal(val);
                header.setModuleId(CurrentSession.getCurrentModuleId());
                header.setProjectId(CurrentSession.getCurrentProjectId());
                header.setUserId(CurrentSession.getCurrentUser().getId());
                this.simpleApidocController.addHeader(header);
                continue;
            }
            if (!valType.equals("env")) continue;
            DBMouduleEnvEntity env = new DBMouduleEnvEntity();
            env.setName(Optional.ofNullable(dto.getDescription()).orElse(dto.getValName()));
            env.setKey(dto.getValName());
            env.setVal(val);
            env.setModuleId(CurrentSession.getCurrentModuleId());
            env.setProjectId(CurrentSession.getCurrentProjectId());
            env.setUserId(CurrentSession.getCurrentUser().getId());
            this.simpleApidocController.addEnv(env);
        }
        unit.setJsonResponse(result.getResponseMsg());
        this.simpleUnitService.insert(unit);
        return result;
    }
}

