/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.filter.model;

import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.filter.ReadMockTemplateFilter;
import cn.easyutil.easyapi.logic.el.DefaultSpelMethodParser;
import cn.easyutil.easyapi.logic.el.DefaultSpelValueParser;
import cn.easyutil.easyapi.logic.el.ElExpression;
import cn.easyutil.easyapi.util.StringUtil;
import java.util.Collections;
import java.util.Random;

public class DefaultReadMockTemplate
implements ReadMockTemplateFilter {
    private ElExpression elExpression;
    private static final Object emptyObject = new Object();

    public DefaultReadMockTemplate(ElExpression elExpression) {
        this.elExpression = elExpression;
    }

    public DefaultReadMockTemplate() {
        this.elExpression = ElExpression.with(new DefaultSpelMethodParser(), new DefaultSpelValueParser());
    }

    @Override
    public Object mock(String template, JavaType javaType) {
        Object obj = this.elExpression.getVal(template);
        switch (javaType) {
            case Float: 
            case Double: {
                if (obj instanceof Double) break;
                obj = Math.random();
                break;
            }
            case Integer: 
            case Long: 
            case Byte: 
            case Short: {
                if (obj instanceof Number) break;
                obj = new Random().nextInt(100);
                break;
            }
            case Boolean: {
                if (obj instanceof Boolean) break;
                obj = new Random().nextInt(1) != 0;
                break;
            }
            case String: 
            case Character: {
                if (obj instanceof String && !StringUtil.isEmpty(obj)) break;
                obj = StringUtil.getRandomString(4);
                break;
            }
            case Array: {
                return Collections.emptyList();
            }
            default: {
                return emptyObject;
            }
        }
        return obj;
    }

    public ElExpression getElExpression() {
        return this.elExpression;
    }

    public void setElExpression(ElExpression elExpression) {
        this.elExpression = elExpression;
    }
}

