/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.filter.model;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.common.BodyType;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ReadInterfaceApiFilter;
import cn.easyutil.easyapi.util.AnnotationUtil;
import cn.easyutil.easyapi.util.SpringUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;

public class DefaultReadInterfaceApi
extends ReadInterfaceApiFilter {
    @Override
    public List<Method> readAllInterfaces(Class controller, ApiExtra extra) {
        Method[] methods;
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : methods = controller.getDeclaredMethods()) {
            Annotation[] ans;
            for (Annotation an : ans = method.getDeclaredAnnotations()) {
                if (an instanceof RequestMapping) {
                    result.add(method);
                    continue;
                }
                if (an instanceof GetMapping) {
                    result.add(method);
                    continue;
                }
                if (an instanceof PostMapping) {
                    result.add(method);
                    continue;
                }
                if (an instanceof PutMapping) {
                    result.add(method);
                    continue;
                }
                if (!(an instanceof DeleteMapping)) continue;
                result.add(method);
            }
        }
        return result;
    }

    @Override
    public boolean ignore(Method method, ApiExtra extra) {
        ApidocComment apidocComment = method.getDeclaredAnnotation(ApidocComment.class);
        if (apidocComment != null) {
            boolean hidden = apidocComment.hidden();
            if (hidden) {
                return true;
            }
            return apidocComment.ignore();
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiOperation", method.getAnnotations());
        if (annotation != null) {
            return (Boolean)AnnotationUtil.getAnnotationValue(annotation, "hidden");
        }
        return false;
    }

    @Override
    public BodyType bodyType(Method method, ApiExtra extra) {
        Parameter[] parameters = method.getParameters();
        if (parameters == null || parameters.length == 0) {
            return BodyType.FORM;
        }
        for (Parameter parameter : parameters) {
            RequestBody annotation = parameter.getAnnotation(RequestBody.class);
            if (annotation != null) {
                return BodyType.JSON;
            }
            if (!parameter.getType().getCanonicalName().equals(MultipartFile.class.getCanonicalName()) && !parameter.getType().getCanonicalName().equals(MultipartFile[].class.getCanonicalName())) continue;
            return BodyType.UPLOAD;
        }
        return BodyType.FORM;
    }

    @Override
    public String requestUrl(Method method, ApiExtra extra) {
        String mapping;
        String base = "";
        if (!StringUtil.isEmpty(base)) {
            base = this.parseUrl(base);
        }
        if (!StringUtil.isEmpty(mapping = Optional.ofNullable(SpringUtil.getRequestPath(method)).orElse(""))) {
            mapping = this.parseUrl(mapping);
        }
        return base + mapping;
    }

    @Override
    public RequestMethod requestMethod(Method method, ApiExtra extra) {
        return SpringUtil.getRequestMethod(method);
    }

    @Override
    public String showName(Method method, ApiExtra extra) {
        ApidocComment api;
        ApidocComment methodApi = method.getDeclaredAnnotation(ApidocComment.class);
        if (methodApi != null && !StringUtil.isEmpty((api = methodApi).value())) {
            return api.value();
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiOperation", method.getAnnotations());
        if (annotation != null) {
            return (String)AnnotationUtil.getAnnotationValue(annotation, "value");
        }
        return "";
    }

    @Override
    public String description(Method method, ApiExtra extra) {
        ApidocComment apidocComment = method.getDeclaredAnnotation(ApidocComment.class);
        if (!StringUtil.isEmpty(apidocComment) && !StringUtil.isEmpty(apidocComment.requestNotes())) {
            return apidocComment.requestNotes();
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiParam", method.getAnnotations());
        if (annotation == null) {
            return "";
        }
        Object value = AnnotationUtil.getAnnotationValue(annotation, "value");
        if (!StringUtil.isEmpty(value)) {
            return (String)value;
        }
        Annotation apiOperation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiOperation", method.getAnnotations());
        if (apiOperation == null) {
            return "";
        }
        Object notes = AnnotationUtil.getAnnotationValue(apiOperation, "notes");
        if (!StringUtil.isEmpty(notes)) {
            return (String)notes;
        }
        Object tags = AnnotationUtil.getAnnotationValue(apiOperation, "tags");
        if (tags == null) {
            return "";
        }
        String[] tgs = (String[])tags;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tgs.length; ++i) {
            sb.append(i + 1 + ":" + tgs[i] + ".");
        }
        return sb.toString();
    }

    @Override
    public String unique(Method method, ApiExtra extra) {
        return StringUtil.toMD5(method.toGenericString());
    }

    private String parseUrl(String requestUrl) {
        if (!requestUrl.startsWith("/")) {
            requestUrl = "/" + requestUrl;
        }
        if (requestUrl.endsWith("/")) {
            requestUrl = requestUrl.substring(0, requestUrl.length() - 1);
        }
        return requestUrl;
    }
}

