/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.unit;

import cn.easyutil.easyapi.configuration.EasyapiUnitConfiguration;
import cn.easyutil.easyapi.entity.common.BodyType;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestInfoEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.interview.entity.HttpEntity;
import cn.easyutil.easyapi.interview.entity.WebHttpFileReq;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.logic.unit.DecodeEnum;
import cn.easyutil.easyapi.logic.unit.GroupDecode;
import cn.easyutil.easyapi.logic.unit.OperEnum;
import cn.easyutil.easyapi.logic.unit.UnitTestProcesser;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.IOUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import cn.easyutil.easyapi.util.http.HttpFileReq;
import cn.easyutil.easyapi.util.http.HttpOperation;
import cn.easyutil.easyapi.util.http.HttpRes;
import cn.easyutil.easyapi.util.http.HttpUtilFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.ServletOutputStream;

public class ComplexTestProcess {
    private static final String sessionKeepKey = "sessionKeepKey";
    private static ExecutorService executorService;

    public static DBComplexTestInfoEntity buildInfo(HttpRes httpRes, List<GroupDecode> decodes, String successKey, String successOper, String successVal) {
        DBComplexTestInfoEntity entity = new DBComplexTestInfoEntity();
        entity.setSuccessKey(successKey);
        entity.setSuccessOper(successOper);
        entity.setSuccessVal(successVal);
        entity.setSuccessStatus(0);
        boolean judgeHttpStatus = false;
        if (StringUtil.isEmpty(successKey) || StringUtil.isEmpty(successOper) || StringUtil.isEmpty(successVal)) {
            judgeHttpStatus = true;
        }
        if (httpRes == null) {
            return entity;
        }
        entity.setHttpStatus(httpRes.getResponseCode());
        entity.setResponseHeaders(httpRes.getResponseHeaders() == null ? "" : JsonUtil.beanToJson(httpRes.getResponseHeaders()));
        String data = httpRes.getResponseMsg();
        entity.setResponseResult(data);
        if (judgeHttpStatus) {
            entity.setSuccessStatus(ComplexTestProcess.booleanToInt(httpRes.getResponseCode() == 200));
            return entity;
        }
        if (StringUtil.isEmpty(data)) {
            return entity;
        }
        Map<String, Object> map = JsonUtil.jsonToMap(data);
        Object successValue = map.get(successKey);
        if (StringUtil.isEmpty(successValue)) {
            return entity;
        }
        successValue = ComplexTestProcess.responseDecode(successValue.toString(), decodes);
        entity.setRealVal(successValue.toString());
        int compare = successValue.toString().compareTo(successVal);
        switch (OperEnum.of(successOper)) {
            case lte: {
                entity.setSuccessStatus(ComplexTestProcess.booleanToInt(compare >= 0));
                return entity;
            }
            case gte: {
                entity.setSuccessStatus(ComplexTestProcess.booleanToInt(compare <= 0));
                return entity;
            }
            case ne: {
                entity.setSuccessStatus(ComplexTestProcess.booleanToInt(compare != 0));
                return entity;
            }
            case eq: {
                entity.setSuccessStatus(ComplexTestProcess.booleanToInt(compare == 0));
                return entity;
            }
        }
        return entity;
    }

    public static List<UnitTestProcesser> startTest(List<HttpEntity> entities, EasyapiUnitConfiguration configuration, boolean sessionkeep) {
        if (executorService == null) {
            executorService = Executors.newWorkStealingPool(configuration.getMaxThreadCount() > 0 ? configuration.getMaxThreadCount() : 10);
        }
        if (entities == null || entities.isEmpty()) {
            return new ArrayList<UnitTestProcesser>();
        }
        CountDownLatch latch = new CountDownLatch(entities.size());
        List<UnitTestProcesser> result = Collections.synchronizedList(new ArrayList());
        for (HttpEntity entity : entities) {
            executorService.submit(() -> {
                UnitTestProcesser processer = new UnitTestProcesser();
                processer.setDecodes(entity.getDecodes());
                processer.setEnty(entity);
                try {
                    processer.setHttpRes(ComplexTestProcess.doUrl(processer.getEnty(), sessionkeep));
                    processer.setSuccess(true);
                }
                catch (Exception e) {
                    processer.setSuccess(false);
                }
                result.add(processer);
                latch.countDown();
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HttpRes doUrl(HttpEntity entity, boolean sessionKeep) {
        AssertUtil.isNull((Object)entity, "\u53c2\u6570\u7f3a\u5931");
        AssertUtil.isNull((Object)(!StringUtil.isUrlPath(entity.getUrl()) ? 1 : 0), "\u8bf7\u6c42\u5730\u5740\u683c\u5f0f\u9519\u8bef");
        AssertUtil.isNull((Object)StringUtil.isEmpty(entity.getMethod()), "\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNull((Object)StringUtil.isEmpty(entity.getBodyType()), "\u8bf7\u6c42\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        HttpOperation operation = HttpUtilFactory.fastCreate(entity.getUrl(), entity.getMethod());
        BodyType bodyType = BodyType.parse(entity.getBodyType());
        AssertUtil.isTrue(bodyType == BodyType.UNKNOW, "\u8bf7\u6c42\u4f53\u7c7b\u578b\u4e0d\u5b58\u5728");
        if (!StringUtil.isEmpty(entity.getJsonHeaders())) {
            operation.headers(JsonUtil.jsonToMap(entity.getJsonHeaders()));
        }
        if (sessionKeep && CurrentSession.getRequest().getSession().getAttribute(sessionKeepKey) != null) {
            operation.setTokenVal(CurrentSession.getRequest().getSession().getAttribute(sessionKeepKey).toString());
        }
        operation.contentType(bodyType.getContentType());
        operation.parameter(entity.getJsonParams());
        switch (bodyType) {
            case FORM: 
            case UPLOAD: {
                operation.parameter(HttpOperation.jsonToForm(entity.getJsonParams()));
                break;
            }
        }
        if (entity.getFiles() != null) {
            List<WebHttpFileReq> files = entity.getFiles();
            ArrayList<HttpFileReq> fileReqs = new ArrayList<HttpFileReq>();
            for (WebHttpFileReq file : files) {
                HttpFileReq req = new HttpFileReq();
                req.setFileName(file.getFileName());
                req.setParamName(file.getParamName());
                req.setContent(StringUtil.base64ToByte(file.getBase64Content()));
                fileReqs.add(req);
            }
            operation.getHttpReq().setFileParams(fileReqs);
        }
        HttpRes httpRes = operation.doUrl();
        if (bodyType != BodyType.DOWNLOAD) {
            httpRes.getResponseMsg();
            if (!sessionKeep) return httpRes;
            if (StringUtil.isEmpty(operation.getTokenVal())) return httpRes;
            CurrentSession.getRequest().getSession().setAttribute(sessionKeepKey, (Object)operation.getTokenVal());
            return httpRes;
        }
        try {
            ServletOutputStream out = CurrentSession.getResponse().getOutputStream();
            Object object = null;
            try {
                out.write(IOUtil.inputToByte(httpRes.getResponseInputStream()));
                out.flush();
                HttpRes httpRes2 = httpRes;
                return httpRes2;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (object != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ApidocException(e);
        }
    }

    public static String responseDecode(String data, List<GroupDecode> decodes) {
        if (StringUtil.isEmpty(data)) {
            return data;
        }
        if (decodes == null) {
            return data;
        }
        for (GroupDecode decode : decodes) {
            if (decode.getDecode() == null) continue;
            switch (DecodeEnum.of(decode.getDecode())) {
                case base64: {
                    data = StringUtil.base64Decode(data);
                    break;
                }
                case aes: {
                    if (decode.getKey() == null) break;
                    data = StringUtil.AESDecode(data, decode.getKey());
                    break;
                }
                case des: {
                    if (decode.getKey() == null) break;
                    data = StringUtil.DESDecode(data, decode.getKey());
                }
            }
        }
        return data;
    }

    public static Integer booleanToInt(boolean boo) {
        return boo ? 1 : 0;
    }
}

