/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.run;

import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiSyncRemoteConfiguration;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.interview.controller.ComplexApidocController;
import cn.easyutil.easyapi.interview.dto.ReciveSourceDto;
import cn.easyutil.easyapi.interview.dto.SyncRemoteAllDto;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.http.HttpRes;
import org.springframework.context.ApplicationContext;

public class DocCreatePost {
    private AllConfiguration all;
    private ApplicationContext appContext;

    public static DocCreatePost build(AllConfiguration all, ApplicationContext appContext) {
        DocCreatePost post = new DocCreatePost();
        post.all = all;
        post.appContext = appContext;
        return post;
    }

    public void post() {
        if (this.all.getSyncRemoteConfiguration().isEnable()) {
            this.aotoSync();
        }
    }

    private void aotoSync() {
        ComplexApidocController controller = (ComplexApidocController)this.appContext.getBean(ComplexApidocController.class);
        SyncRemoteAllDto dto = new SyncRemoteAllDto();
        dto.setOverwriteType(this.all.getSyncRemoteConfiguration().getOverwriteType().type);
        dto.setTargetHost(this.all.getSyncRemoteConfiguration().getHost());
        dto.setTargetUsername(this.all.getSyncRemoteConfiguration().getAccount());
        dto.setTargetPassword(this.all.getSyncRemoteConfiguration().getPassword());
        dto.setTargetProjectName(this.all.getSyncRemoteConfiguration().getProjectName());
        dto.setTargetModuleName(this.all.getSyncRemoteConfiguration().getModuleName());
        dto.setLocalProjectName(ProjectContext.currentProjectName);
        dto.setLocalModuleName(ProjectContext.currentModuleName);
        if (this.all.getSyncRemoteConfiguration().getSyncType() == EasyapiSyncRemoteConfiguration.SyncType.push) {
            controller.syncRemoteAll(dto);
        } else {
            HttpRes httpRes = controller.doEasyapiUrl(dto.getTargetHost() + "/easyapi/doc/complex/syncPull", JsonUtil.beanToJson(dto));
            String message = controller.getDoEasyapiUrlResult(httpRes);
            ReciveSourceDto reciveSourceDto = JsonUtil.jsonToBean(message, ReciveSourceDto.class);
            controller.saveSyncSource(dto.getLocalProjectName(), dto.getLocalModuleName(), reciveSourceDto.getSources(), dto.getOverwriteType());
        }
    }
}

