/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.run;

import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiDataConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiFilterBeanConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiFilterConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiSyncRemoteConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiUnitConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiUserConfiguration;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.datasource.EasyapiBindSqlExecution;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.model.DefaultReadControllerApi;
import cn.easyutil.easyapi.filter.model.DefaultReadInterfaceApi;
import cn.easyutil.easyapi.filter.model.DefaultReadJavaBeanApi;
import cn.easyutil.easyapi.filter.model.DefaultReadMockTemplate;
import cn.easyutil.easyapi.filter.model.DefaultReadRequestParamApi;
import cn.easyutil.easyapi.filter.model.DefaultReadResponseParamApi;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceReader;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.javadoc.reader.SourceParameterComment;
import cn.easyutil.easyapi.logic.creator.ControllerCreator;
import cn.easyutil.easyapi.logic.creator.InterfaceCreator;
import cn.easyutil.easyapi.logic.creator.JavaBeanCreator;
import cn.easyutil.easyapi.logic.creator.MethodParamsCreator;
import cn.easyutil.easyapi.logic.run.DocClassBean;
import cn.easyutil.easyapi.logic.run.DocInterfaceBean;
import cn.easyutil.easyapi.test.TestController;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;

public class DocCreate {
    private AllConfiguration all;
    private ApplicationContext appContext;
    private EasyapiBindSqlExecution execution;

    public DocCreate(AllConfiguration all, ApplicationContext appContext, EasyapiBindSqlExecution execution) {
        this.all = all;
        this.appContext = appContext;
        this.execution = execution;
    }

    public void createApi() {
        Set<Class> set = ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadControllerApiFilter().readControllers(this.appContext);
        if (set == null || set.isEmpty()) {
            return;
        }
        if (ProjectContext.allConfiguration.getConfiguration().isRenewDoc()) {
            DBModuleInterfaceEntity upgrade = new DBModuleInterfaceEntity();
            upgrade.setUpgradeStatus(1);
            this.execution.update(EasyapiBindSQLExecuter.build(upgrade).eq(BaseDbEntity::getProjectId, (Object)ProjectContext.currentProjectId, new Boolean[0]));
        }
        for (Class aClass : set) {
            List<DocInterfaceBean> interfaces;
            DocClassBean api = this.createControllerApi(aClass);
            DBModuleControllerEntity controllerBean = api.getController();
            if (controllerBean == null) continue;
            DBModuleControllerEntity queryController = (DBModuleControllerEntity)this.execution.selectOne(EasyapiBindSQLExecuter.build(new DBModuleControllerEntity()).eq(BaseDbEntity::getProjectId, (Object)controllerBean.getProjectId(), new Boolean[0]).eq(DBModuleControllerEntity::getModuleId, (Object)controllerBean.getModuleId(), new Boolean[0]).eq(DBModuleControllerEntity::getClassName, (Object)controllerBean.getClassName(), new Boolean[0]));
            if (queryController == null) {
                controllerBean.setCreateTime(System.currentTimeMillis());
                controllerBean.setUpdateTime(System.currentTimeMillis());
                this.execution.insert(controllerBean);
                queryController = controllerBean;
            }
            if ((interfaces = api.getInterfaces()) == null || interfaces.isEmpty()) continue;
            DBModuleInterfaceEntity queryInterface = new DBModuleInterfaceEntity();
            queryInterface.setProjectId(ProjectContext.currentProjectId);
            queryInterface.setModuleId(ProjectContext.currentModuleId);
            queryInterface.setControllerId(queryController.getId());
            List<DBModuleInterfaceEntity> apiInterfaceBeans = this.execution.select(queryInterface);
            if (apiInterfaceBeans == null) {
                apiInterfaceBeans = new ArrayList<DBModuleInterfaceEntity>();
            }
            Map allExistInterface = apiInterfaceBeans.stream().collect(Collectors.toMap(DBModuleInterfaceEntity::getUnique, Function.identity()));
            for (DocInterfaceBean itf : interfaces) {
                DBModuleInterfaceEntity interfaceBean = itf.getInterfaceBean();
                DBInterfaceParamEntity requestParam = itf.getRequestParam();
                DBModuleInterfaceEntity dbFindInterface = (DBModuleInterfaceEntity)allExistInterface.get(interfaceBean.getUnique());
                if (dbFindInterface != null && dbFindInterface.getUpgradeStatus() == 0) continue;
                interfaceBean.setControllerId(queryController.getId());
                interfaceBean.setModuleId(queryController.getModuleId());
                interfaceBean.setProjectId(queryController.getProjectId());
                if (dbFindInterface != null) {
                    interfaceBean.setId(dbFindInterface.getId());
                    interfaceBean.setUpgradeStatus(0);
                    this.execution.update(interfaceBean);
                } else {
                    this.execution.insert(interfaceBean);
                }
                allExistInterface.put(interfaceBean.getUnique(), interfaceBean);
                DBInterfaceParamEntity del = new DBInterfaceParamEntity();
                del.setInterfaceId(interfaceBean.getId());
                del.setProjectId(interfaceBean.getProjectId());
                this.execution.delete(del);
                requestParam.setInterfaceId(interfaceBean.getId());
                requestParam.setProjectId(interfaceBean.getProjectId());
                this.execution.insert(requestParam);
            }
        }
    }

    public DocClassBean createControllerApi(Class aClass) {
        String canonicalName = aClass.getCanonicalName();
        String controllerPath = ProjectContext.projectBasePath + File.separator + aClass.getCanonicalName().replace(".", File.separator) + ".java";
        JavaSourceReader controllerSourceReader = JavaSourceReader.builder(new File(controllerPath));
        ApiExtra extra = new ApiExtra();
        extra.setControllerClass(aClass);
        extra.setControllerComment(controllerSourceReader.getComment());
        if (!StringUtil.isEmpty(this.all.getConfiguration().getScanPackage()) && !canonicalName.startsWith(this.all.getConfiguration().getScanPackage())) {
            return DocClassBean.EMPTY;
        }
        if (ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadControllerApiFilter().ignore(aClass, extra)) {
            return DocClassBean.EMPTY;
        }
        DocClassBean result = new DocClassBean();
        DBModuleControllerEntity controllerBean = ControllerCreator.builder(aClass).setFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadControllerApiFilter()).setExtra(extra).buildController();
        controllerBean.setProjectId(ProjectContext.currentProjectId);
        controllerBean.setModuleId(ProjectContext.currentModuleId);
        result.setController(controllerBean);
        List<Method> methods = ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadInterfaceApiFilter().readAllInterfaces(aClass, extra);
        List<MethodComment> methodComment = controllerSourceReader.getComment().getMethods();
        HashMap readMethodParamComment = new HashMap();
        for (MethodComment comment : methodComment) {
            List<SourceParameterComment> parameters = comment.getParameters();
            HashMap<String, String> map = new HashMap<String, String>();
            for (SourceParameterComment parameter : parameters) {
                map.put(parameter.getName(), parameter.getComment());
            }
            readMethodParamComment.put(comment.getName(), map);
        }
        for (Method method : methods) {
            if (ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadInterfaceApiFilter().ignore(method, extra)) continue;
            MethodComment methodSourceComment = controllerSourceReader.getComment().getMethod(method.getName());
            extra.setMethod(method);
            extra.setMethodComment(methodSourceComment);
            DBModuleInterfaceEntity interfaceBean = InterfaceCreator.builder(method).setFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadInterfaceApiFilter()).setApiExtra(extra).buildInterface();
            interfaceBean.setProjectId(controllerBean.getProjectId());
            interfaceBean.setModuleId(controllerBean.getModuleId());
            interfaceBean.setControllerClass(controllerBean.getClassName());
            interfaceBean.setControllerId(controllerBean.getId());
            String requestUrl = Optional.ofNullable(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadInterfaceApiFilter().requestUrl(method, extra)).orElse("");
            String baseUrl = Optional.ofNullable(controllerBean.getApiPath()).orElse("");
            interfaceBean.setRequestUrl(baseUrl + requestUrl);
            interfaceBean.setSearchTags(DBModuleInterfaceEntity.buildSearchTag(interfaceBean));
            DocInterfaceBean docInterfaceBean = new DocInterfaceBean();
            docInterfaceBean.setInterfaceBean(interfaceBean);
            MethodParamsCreator methodParamsCreator = MethodParamsCreator.build(aClass, method).withBeanCreator(JavaBeanCreator.builder(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadBeanApiFilter(), ProjectContext.projectBasePath, ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadMockTemplateFilter(), extra)).withMockFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadMockTemplateFilter()).withReqFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadRequestParamApiFilter()).withResFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadResponseParamApiFilter()).withBeanFilter(ProjectContext.allConfiguration.getFilterBeanConfiguration().getReadBeanApiFilter()).withExtra(extra).create();
            String requestParams = JsonUtil.beanToJson(methodParamsCreator.getRequestParameters());
            DBInterfaceParamEntity reqPram = new DBInterfaceParamEntity();
            reqPram.setProjectId(ProjectContext.currentProjectId);
            reqPram.setProjectId(ProjectContext.currentProjectId);
            reqPram.setInterfaceId(interfaceBean.getId());
            reqPram.setCreateTime(System.currentTimeMillis());
            reqPram.setUpdateTime(System.currentTimeMillis());
            reqPram.setRequestParamJson(requestParams);
            reqPram.setResponseParamJson(JsonUtil.beanToJson(methodParamsCreator.getReturnParameter()));
            reqPram.setResponseMock(methodParamsCreator.getResponseMock());
            reqPram.setRequestMock(methodParamsCreator.getRequestMock());
            docInterfaceBean.setRequestParam(reqPram);
            result.getInterfaces().add(docInterfaceBean);
        }
        return result;
    }

    public static void main(String[] args) {
        AllConfiguration all = new AllConfiguration();
        all.setConfiguration(new EasyapiConfiguration());
        all.setDataConfiguration(new EasyapiDataConfiguration());
        all.setFilterClassConfiguration(new EasyapiFilterConfiguration());
        all.setFilterBeanConfiguration(new EasyapiFilterBeanConfiguration());
        all.setSyncRemoteConfiguration(new EasyapiSyncRemoteConfiguration());
        all.setUnitConfiguration(new EasyapiUnitConfiguration());
        all.setUserConfiguration(new EasyapiUserConfiguration());
        EasyapiFilterBeanConfiguration beanFilter = all.getFilterBeanConfiguration();
        beanFilter.setReadBeanApiFilter(new DefaultReadJavaBeanApi());
        beanFilter.setReadControllerApiFilter(new DefaultReadControllerApi());
        beanFilter.setReadInterfaceApiFilter(new DefaultReadInterfaceApi());
        beanFilter.setReadMockTemplateFilter(new DefaultReadMockTemplate());
        beanFilter.setReadRequestParamApiFilter(new DefaultReadRequestParamApi());
        beanFilter.setReadResponseParamApiFilter(new DefaultReadResponseParamApi());
        ProjectContext.allConfiguration = all;
        ProjectContext.projectBasePath = "D:\\self\\easyapi\\easyapi\\src\\main\\java";
        DocCreate create = new DocCreate(all, null, null);
        DocClassBean doc = create.createControllerApi(TestController.class);
        Pattern pvalue = Pattern.compile("\"className\":\"(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{0,}\"");
        String context = JsonUtil.beanToJson(doc.getInterfaces().get(0).getRequestParam());
        Matcher matcher = pvalue.matcher(context);
        while (matcher.find()) {
            String group = matcher.group();
            while (context.contains(group)) {
                context = context.replaceFirst(group, "\"className\":\"" + UUID.randomUUID().toString().replace("-", "") + "\"");
            }
        }
        System.out.println(doc.getInterfaces());
    }
}

