/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.filter.ApiExtra;
import cn.easyutil.easyapi.filter.ReadJavaBeanApiFilter;
import cn.easyutil.easyapi.filter.ReadMockTemplateFilter;
import cn.easyutil.easyapi.filter.ReadRequestParamApiFilter;
import cn.easyutil.easyapi.filter.ReadResponseParamApiFilter;
import cn.easyutil.easyapi.filter.model.DefaultReadJavaBeanApi;
import cn.easyutil.easyapi.filter.model.DefaultReadMockTemplate;
import cn.easyutil.easyapi.filter.model.DefaultReadRequestParamApi;
import cn.easyutil.easyapi.filter.model.DefaultReadResponseParamApi;
import cn.easyutil.easyapi.logic.condition.MockProcess2;
import cn.easyutil.easyapi.logic.creator.JavaBeanCreator;
import cn.easyutil.easyapi.logic.el.DefaultSpelMethodParser;
import cn.easyutil.easyapi.logic.el.ElExpression;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.DefaultParameterNameDiscoverer;

public class MethodParamsCreator {
    private Class clazz;
    private Method method;
    private ApiExtra extra;
    private ReadRequestParamApiFilter reqFilter = new DefaultReadRequestParamApi();
    private ReadResponseParamApiFilter resFilter = new DefaultReadResponseParamApi();
    private ReadJavaBeanApiFilter javaBeanApiFilter = new DefaultReadJavaBeanApi();
    private ReadMockTemplateFilter mockFilter = new DefaultReadMockTemplate(ElExpression.with(DefaultSpelMethodParser.get()));
    private List<DocParamEntity> requestParameters = new ArrayList<DocParamEntity>();
    private List<DocParamEntity> returnParameter = new ArrayList<DocParamEntity>();
    private String responseMock = "";
    private String requestMock = "";
    private JavaBeanCreator javaBeanCreator;

    public static MethodParamsCreator build(Class clazz, Method method) {
        MethodParamsCreator creator = new MethodParamsCreator();
        creator.method = method;
        creator.clazz = clazz;
        return creator;
    }

    public MethodParamsCreator withClass(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    public MethodParamsCreator withMockFilter(ReadMockTemplateFilter mockFilter) {
        this.mockFilter = mockFilter;
        return this;
    }

    public MethodParamsCreator withReqFilter(ReadRequestParamApiFilter reqFilter) {
        this.reqFilter = reqFilter;
        return this;
    }

    public MethodParamsCreator withResFilter(ReadResponseParamApiFilter resFilter) {
        this.resFilter = resFilter;
        return this;
    }

    public MethodParamsCreator withBeanFilter(ReadJavaBeanApiFilter beanFilter) {
        this.javaBeanApiFilter = beanFilter;
        return this;
    }

    public MethodParamsCreator withBeanCreator(JavaBeanCreator creator) {
        this.javaBeanCreator = creator;
        return this;
    }

    public MethodParamsCreator withMethod(Method method) {
        this.method = method;
        return this;
    }

    public MethodParamsCreator withExtra(ApiExtra extra) {
        this.extra = extra;
        return this;
    }

    public MethodParamsCreator create() {
        try {
            this.createParameters();
            this.createReturnType();
            MockProcess2 mocker = MockProcess2.with(this.mockFilter);
            Object req = mocker.mockByApiParams(this.requestParameters);
            Object res = mocker.mockByApiParams(this.returnParameter);
            this.requestMock = ObjectUtil.isBaseObject(req) ? req.toString() : JsonUtil.beanToJson(req);
            this.responseMock = ObjectUtil.isBaseObject(res) ? res.toString() : JsonUtil.beanToJson(res);
            return this;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ApidocException("\u63a5\u53e3\u53c2\u6570\u6784\u5efa\u5931\u8d25:" + this.clazz.getCanonicalName() + "." + this.method.getName());
        }
    }

    private void createParameters() {
        this.extra.setParameter(null);
        Parameter[] parameters = this.method.getParameters();
        DefaultParameterNameDiscoverer discover = new DefaultParameterNameDiscoverer();
        String[] parameterNames = discover.getParameterNames(this.method);
        if (parameters == null || parameters.length == 0) {
            return;
        }
        for (int i = 0; i < parameters.length; ++i) {
            String description;
            Parameter parameter = parameters[i];
            Type type = this.reqFilter.parameterType(parameter, this.extra);
            Class ownerClass = GenericTypeUtil.getOwnerClass(type);
            this.extra.setParameter(parameter);
            if (this.reqFilter.ignore(parameter, type, ownerClass, this.extra)) continue;
            String parameterName = this.reqFilter.parameterName(parameter, this.extra);
            if (parameterName == null) {
                parameterName = parameterNames[i];
            }
            if ((description = this.reqFilter.description(parameter, parameterName, this.extra)) == null) {
                description = this.extra.getMethodComment().getParameter(parameterNames[i]).getComment();
            }
            JavaType javaType = JavaType.getJavaTypeByType(type);
            DocParamEntity entity = new DocParamEntity();
            entity.setDescription(description);
            entity.setMockTemplate(this.reqFilter.mockTemplate(parameter, this.extra));
            entity.setName(parameterName);
            entity.setRequired(this.reqFilter.required(parameter, this.extra) ? 1 : 0);
            entity.setShow(this.reqFilter.show(parameter, this.extra) ? 1 : 0);
            entity.setJavaType(javaType.getType());
            List<DocParamEntity> param = this.createParam(type, entity);
            this.requestParameters.addAll(param);
        }
    }

    private void createReturnType() {
        this.extra.setReturnType(null);
        Type returnType = this.method.getGenericReturnType();
        if (returnType == Void.TYPE) {
            return;
        }
        this.extra.setReturnType(returnType);
        Class ownerClass = GenericTypeUtil.getOwnerClass(returnType);
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(returnType);
        returnType = this.resFilter.returnType(returnType, ownerClass, bind, this.extra);
        ownerClass = GenericTypeUtil.getOwnerClass(returnType);
        bind = GenericTypeUtil.getGenericTypes(returnType);
        if (this.resFilter.ignore(returnType, ownerClass, bind, this.extra)) {
            return;
        }
        JavaType javaType = JavaType.getJavaTypeByType(returnType);
        DocParamEntity entity = new DocParamEntity();
        entity.setDescription(this.resFilter.description(this.method, this.extra));
        entity.setMockTemplate(this.resFilter.mockTemplate(this.method, this.extra));
        entity.setRequired(this.resFilter.required(returnType, ownerClass, bind, this.extra) ? 1 : 0);
        entity.setShow(this.resFilter.show(returnType, ownerClass, bind, this.extra) ? 1 : 0);
        entity.setName("_null");
        entity.setJavaType(javaType.getType());
        this.returnParameter = this.createParam(returnType, entity);
    }

    private List<DocParamEntity> createParam(Type type, DocParamEntity entity) {
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(type);
        JavaType javaType = JavaType.getType(entity.getJavaType());
        HashMap<String, List<DocParamEntity>> exists = new HashMap<String, List<DocParamEntity>>();
        if (javaType == JavaType.Object) {
            return this.javaBeanCreator.readBean(type, bind, exists);
        }
        entity.setClassName(GenericTypeUtil.getOwnerClass(type).getCanonicalName());
        entity.setJavaType(javaType.getType());
        switch (javaType) {
            case Array: {
                entity.setChildren(this.javaBeanCreator.readArray(type, bind));
                break;
            }
            case ArrayObject: {
                entity.setChildren(this.javaBeanCreator.readArrayObject(type, bind, exists));
            }
        }
        Object mockValue = this.mockFilter.mock(entity.getMockTemplate(), javaType);
        entity.setMockValue(JsonUtil.beanToJson(mockValue));
        return Collections.singletonList(entity);
    }

    public List<DocParamEntity> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(List<DocParamEntity> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public List<DocParamEntity> getReturnParameter() {
        return this.returnParameter;
    }

    public void setReturnParameter(List<DocParamEntity> returnParameter) {
        this.returnParameter = returnParameter;
    }

    public String getResponseMock() {
        return this.responseMock;
    }

    public String getRequestMock() {
        return this.requestMock;
    }
}

