/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.datasource.annotations.Tfd;
import cn.easyutil.easyapi.datasource.annotations.Tne;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.util.StringUtil;
import java.sql.Blob;
import org.springframework.web.bind.annotation.RequestMethod;

@Tne(value="EASYAPI_MODULE_INTERFACE")
public class DBModuleInterfaceEntity
extends BaseDbEntity {
    @Tfd(value="MODULE_ID")
    @ApidocComment(value="\u6a21\u5757id")
    private Long moduleId;
    @Tfd(value="CONTROLLER_ID")
    @ApidocComment(value="\u63a7\u5236\u5668id")
    private Long controllerId;
    @Tfd(value="CONTROLLER_CLASS")
    @ApidocComment(value="\u63a7\u5236\u5668\u540d\u79f0")
    private String controllerClass;
    @Tfd(value="METHOD_NAME")
    @ApidocComment(value="\u63a5\u53e3\u65b9\u6cd5\u540d")
    private String methodName;
    @Tfd(value="UNIQUE")
    @ApidocComment(value="\u63a5\u53e3\u552f\u4e00\u6807\u8bc6")
    private String unique;
    @Tfd(value="UPGRADE_STATUS")
    @ApidocComment(value="\u63a5\u53e3\u7248\u672c  0-\u6700\u65b0\u7248\u672c 1-\u5f85\u66f4\u65b0")
    private Integer upgradeStatus;
    @Tfd(value="SHOW_NAME")
    @ApidocComment(value="\u63a5\u53e3\u6807\u9898")
    private String showName;
    @Tfd(value="PINYIN")
    @ApidocComment(value="\u63a5\u53e3\u6807\u9898\u62fc\u97f3")
    private String pinyin;
    @Tfd(value="DESCRIPTION")
    @ApidocComment(value="\u63a5\u53e3\u8bf4\u660e")
    private String description;
    @Tfd(value="REQUEST_URL")
    @ApidocComment(value="\u8bf7\u6c42\u5730\u5740")
    private String requestUrl;
    @Tfd(value="REQUEST_METHOD")
    @ApidocComment(value="\u8bf7\u6c42\u65b9\u5f0f 0-\u5168\u90e8  1-get  2-post ")
    private Integer requestMethod;
    @Tfd(value="REQUEST_TYPE")
    @ApidocComment(value="\u8bf7\u6c42\u4f53\u7c7b\u578b 0-form  1-json\u4f53  2-\u6587\u4ef6\u4e0a\u4f20 3-XML 4-RAW")
    private Integer bodyType;
    @Tfd(value="SORT")
    @ApidocComment(value="\u6392\u5e8f\u503c")
    private Integer sort = 0;
    @Tfd(value="SOURCE", type=Blob.class)
    @ApidocComment(value="\u6e90\u4ee3\u7801")
    private String source;
    @Tfd(value="SEARCH_TAGS")
    @ApidocComment(value="\u641c\u7d22\u5b57\u6bb5")
    private String searchTags;

    public static String buildSearchTag(DBModuleInterfaceEntity entity) {
        if (entity == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty(entity.getMethodName())) {
            sb.append(entity.getMethodName());
        }
        if (!StringUtil.isEmpty(entity.getShowName())) {
            sb.append(entity.getShowName());
        }
        if (!StringUtil.isEmpty(entity.getRequestUrl())) {
            sb.append(entity.getRequestUrl());
        }
        if (!StringUtil.isEmpty(entity.getPinyin())) {
            sb.append(entity.getPinyin());
        }
        if (!StringUtil.isEmpty(entity.getDescription())) {
            sb.append(entity.getDescription());
        }
        if (sb.length() > 150) {
            return sb.substring(0, 150);
        }
        return sb.toString();
    }

    public String getRequestMethodString() {
        if (this.requestMethod == null) {
            return "GET";
        }
        switch (this.requestMethod) {
            case 1: {
                return "GET";
            }
            case 2: {
                return "POST";
            }
            case 3: {
                return "PUT";
            }
            case 4: {
                return "DELETE";
            }
            case 5: {
                return "HEAD";
            }
            case 6: {
                return "PATCH";
            }
            case 7: {
                return "TRACE";
            }
            case 8: {
                return "OPTIONS";
            }
        }
        return "GET";
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        switch (requestMethod) {
            case GET: {
                this.requestMethod = 1;
                break;
            }
            case DELETE: {
                this.requestMethod = 4;
                break;
            }
            case PUT: {
                this.requestMethod = 3;
                break;
            }
            case POST: {
                this.requestMethod = 2;
                break;
            }
            case HEAD: {
                this.requestMethod = 5;
                break;
            }
            case PATCH: {
                this.requestMethod = 6;
                break;
            }
            case TRACE: {
                this.requestMethod = 7;
                break;
            }
            case OPTIONS: {
                this.requestMethod = 8;
            }
        }
    }

    public Long getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(Long moduleId) {
        this.moduleId = moduleId;
    }

    public Long getControllerId() {
        return this.controllerId;
    }

    public void setControllerId(Long controllerId) {
        this.controllerId = controllerId;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getShowName() {
        return this.showName;
    }

    public void setShowName(String showName) {
        this.showName = showName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public Integer getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(Integer requestMethod) {
        this.requestMethod = requestMethod;
    }

    public Integer getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(Integer bodyType) {
        this.bodyType = bodyType;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getPinyin() {
        return this.pinyin;
    }

    public void setPinyin(String pinyin) {
        this.pinyin = pinyin;
    }

    public String getSearchTags() {
        return this.searchTags;
    }

    public void setSearchTags(String searchTags) {
        this.searchTags = searchTags;
    }

    public String getControllerClass() {
        return this.controllerClass;
    }

    public void setControllerClass(String controllerClass) {
        this.controllerClass = controllerClass;
    }

    public String getUnique() {
        return this.unique;
    }

    public void setUnique(String unique) {
        this.unique = unique;
    }

    public Integer getUpgradeStatus() {
        return this.upgradeStatus;
    }

    public void setUpgradeStatus(Integer upgradeStatus) {
        this.upgradeStatus = upgradeStatus;
    }
}

