/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.util.http;

import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;
import cn.easyutil.easyapi.util.http.HttpMethod;
import cn.easyutil.easyapi.util.http.HttpReq;
import cn.easyutil.easyapi.util.http.HttpRes;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.http.entity.ContentType;

public abstract class HttpOperation {
    private HttpReq httpReq;
    private String currentTokenKey = "Set-Cookie";
    private String currentTokenVal;
    private String charset = "utf-8";

    public HttpOperation(HttpReq httpReq) {
        this.httpReq = httpReq;
    }

    public HttpOperation(String url) {
        this(url, HttpMethod.GET);
    }

    public HttpOperation() {
        this.httpReq = new HttpReq();
    }

    public HttpOperation(String url, HttpMethod httpMethod) {
        this.httpReq = new HttpReq();
        this.httpReq.setUrl(url);
        this.httpReq.setMethod(httpMethod);
    }

    public void setTokenKey(String tokenKey) {
        this.currentTokenKey = tokenKey;
    }

    public void setTokenVal(String val) {
        this.currentTokenVal = val;
    }

    public String getTokenKey() {
        return this.currentTokenKey;
    }

    public String getTokenVal() {
        return this.currentTokenVal;
    }

    public HttpReq getHttpReq() {
        return this.httpReq;
    }

    public void setCharset(String charset) {
        if (StringUtil.isEmpty(charset)) {
            return;
        }
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public HttpOperation method(HttpMethod method) {
        this.getHttpReq().setMethod(method);
        return this;
    }

    public HttpOperation contentType(ContentType contentType) {
        this.getHttpReq().addHeader("Content-Type", contentType.getMimeType());
        return this;
    }

    public HttpOperation header(String key, String value) {
        this.getHttpReq().addHeader(key, value);
        return this;
    }

    public HttpOperation headers(Map headers) {
        this.getHttpReq().setHeader(headers);
        return this;
    }

    public HttpOperation parameter(String key, Object value) {
        this.getHttpReq().addParam(key, value);
        return this;
    }

    public HttpOperation parameter(String text) {
        this.getHttpReq().addParam(text);
        return this;
    }

    public HttpOperation parameters(Map map) {
        this.getHttpReq().setParam(map);
        return this;
    }

    public HttpRes doUrl() {
        this.doPre();
        HttpRes httpRes = this.doUrl(false, this.httpReq, null, null);
        this.doPost(httpRes);
        return httpRes;
    }

    public HttpRes doSSLUrl(InputStream certInput, String password) {
        this.doPre();
        HttpRes httpRes = this.doUrl(true, this.httpReq, certInput, password == null ? null : password.toCharArray());
        this.doPost(httpRes);
        return httpRes;
    }

    protected abstract HttpRes doUrl(boolean var1, HttpReq var2, InputStream var3, char[] var4);

    private void doPre() {
        if (!StringUtil.isEmpty(this.currentTokenKey) && !StringUtil.isEmpty(this.currentTokenVal)) {
            if (this.currentTokenKey.equals("Set-Cookie")) {
                this.httpReq.addHeader("Cookie", this.currentTokenVal);
                return;
            }
            this.httpReq.addHeader(this.currentTokenVal, this.currentTokenVal);
        }
    }

    private void doPost(HttpRes httpRes) {
        Map<String, String> responseHeaders = httpRes.getResponseHeaders();
        if (responseHeaders == null) {
            return;
        }
        Optional<String> first = responseHeaders.keySet().stream().filter(key -> key.equals(this.currentTokenKey)).findFirst();
        if (first.isPresent()) {
            this.currentTokenVal = responseHeaders.get(first.get());
        }
        this.httpReq.setParam(new HashMap());
    }

    public static Map<String, String> formToMap(String formData) {
        if (StringUtil.isEmpty(formData)) {
            return null;
        }
        String[] split = formData.split("&");
        HashMap<String, String> result = new HashMap<String, String>();
        for (String s : split) {
            String[] sp;
            if (!s.contains("=") || (sp = s.split("=")).length != 2) continue;
            result.put(sp[0], sp[1]);
        }
        return result;
    }

    public static String jsonToForm(String json) {
        if (StringUtil.isEmpty(json)) {
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        StringBuffer listParam = new StringBuffer();
        JSONObject obj = JSONObject.parseObject((String)json);
        Set entrySet = obj.entrySet();
        for (Map.Entry entry : entrySet) {
            List list;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (ObjectUtil.isBaseObject(value)) {
                param.put(key, value);
                continue;
            }
            if (Map.class.isAssignableFrom(value.getClass())) {
                Map map = (Map)value;
                if (map.isEmpty()) continue;
                HttpOperation.nestedMap(key, map, listParam, param);
                continue;
            }
            if (!Collection.class.isAssignableFrom(value.getClass()) || (list = (List)value).isEmpty()) continue;
            HttpOperation.nestedList(key, list, listParam, param);
        }
        String paramStr = "";
        if (param != null) {
            for (String key : param.keySet()) {
                paramStr = paramStr + key + "=";
                paramStr = paramStr + param.get(key) + "&";
            }
        }
        return paramStr + listParam.toString();
    }

    private static void nestedMap(String key, Map<String, Object> map, StringBuffer listParam, Map<String, Object> param) {
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            List list2;
            String key2 = entry.getKey();
            Object value = entry.getValue();
            if (ObjectUtil.isBaseObject(value)) {
                param.put(key + "." + key2, value);
                continue;
            }
            if (Map.class.isAssignableFrom(value.getClass())) {
                Map map2 = (Map)value;
                if (map.isEmpty()) continue;
                HttpOperation.nestedMap(key + "." + key2, map2, listParam, param);
                continue;
            }
            if (!Collection.class.isAssignableFrom(value.getClass()) || (list2 = (List)value).isEmpty()) continue;
            HttpOperation.nestedList(key + "." + key2, list2, listParam, param);
        }
    }

    private static void nestedList(String key, List<Object> list, StringBuffer listParam, Map<String, Object> param) {
        for (Object obj : list) {
            if (ObjectUtil.isBaseObject(obj)) {
                listParam.append("&" + key + "=" + obj);
                continue;
            }
            if (Map.class.isAssignableFrom(obj.getClass())) {
                Map map2 = (Map)obj;
                if (map2.isEmpty()) continue;
                HttpOperation.nestedMap(key, map2, listParam, param);
                continue;
            }
            if (!Collection.class.isAssignableFrom(obj.getClass())) continue;
            List list2 = (List)obj;
            if (list.isEmpty()) continue;
            HttpOperation.nestedList(key, list2, listParam, param);
        }
    }
}

