/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.util;

import cn.easyutil.easyapi.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectUtil {
    public static String toBase64(Object obj) {
        return StringUtil.base64Encode(ObjectUtil.toByte(obj));
    }

    private static byte[] toByte(Object obj) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream objOut = new ObjectOutputStream(byteOut);
            objOut.writeObject(obj);
            return byteOut.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setAttribute(Object obj, String attrName, Object value) {
        try {
            Class<?> clazz = obj.getClass();
            while (!clazz.equals(Object.class)) {
                try {
                    Field f = clazz.getDeclaredField(attrName);
                    if (f == null) continue;
                    try {
                        String setMothedName = "SET" + attrName.toUpperCase();
                        Method[] ms = clazz.getDeclaredMethods();
                        for (int i = 0; i < ms.length; ++i) {
                            if (!ms[i].getName().toUpperCase().equals(setMothedName)) continue;
                            ms[i].setAccessible(true);
                            ms[i].invoke(obj, value);
                            ms[i].setAccessible(false);
                            return;
                        }
                        throw new RuntimeException();
                    }
                    catch (Exception e) {
                        f.setAccessible(true);
                        if (value == null || f.getType().isAssignableFrom(value.getClass())) {
                            f.set(obj, value);
                        } else {
                            f.set(obj, ObjectUtil.parseToObject(value, f.getType()));
                        }
                        f.setAccessible(false);
                        return;
                    }
                }
                catch (NoSuchFieldException e) {
                    clazz = clazz.getSuperclass();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getAttributeValue(Object obj, String attrName) {
        try {
            Class<?> clazz = obj.getClass();
            while (!clazz.equals(Object.class)) {
                try {
                    Field f = clazz.getDeclaredField(attrName);
                    try {
                        Class<?> type = f.getType();
                        String getMothedName = type == Boolean.TYPE ? "IS" + attrName.toUpperCase() : "GET" + attrName.toUpperCase();
                        Method[] ms = clazz.getDeclaredMethods();
                        for (int i = 0; i < ms.length; ++i) {
                            if (!ms[i].getName().toUpperCase().equals(getMothedName)) continue;
                            ms[i].setAccessible(true);
                            Object result = ms[i].invoke(obj, new Object[0]);
                            ms[i].setAccessible(false);
                            return (T)result;
                        }
                        throw new RuntimeException();
                    }
                    catch (Exception e) {
                        f.setAccessible(true);
                        Object value = f.get(obj);
                        f.setAccessible(false);
                        return (T)value;
                    }
                }
                catch (NoSuchFieldException e) {
                    clazz = clazz.getSuperclass();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> getAttributes(Object bean) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Class<?> clazz = bean.getClass();
            while (!clazz.equals(Object.class)) {
                Field[] fs;
                for (Field f : fs = clazz.getDeclaredFields()) {
                    if (map.containsKey(f.getName())) continue;
                    f.setAccessible(true);
                    Object value = f.get(bean);
                    f.setAccessible(false);
                    map.put(f.getName(), value);
                }
                clazz = clazz.getSuperclass();
            }
            map.remove("serialVersionUID");
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> getNotNullAttributes(Object bean) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> map = ObjectUtil.getAttributes(bean);
        for (String key : map.keySet()) {
            if (map.get(key) == null || map.get(key).equals("")) continue;
            result.put(key, map.get(key));
        }
        return result;
    }

    public static Field getField(Class<?> aclass, String name) {
        try {
            Class<?> clazz = aclass;
            while (!clazz.equals(Object.class)) {
                Field[] fs;
                for (Field f : fs = clazz.getDeclaredFields()) {
                    if (!name.equals(f.getName())) continue;
                    return f;
                }
                clazz = clazz.getSuperclass();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Class> getFieldClass(Class clazz) {
        try {
            HashMap<String, Class> attrMap = new HashMap<String, Class>();
            while (!clazz.equals(Object.class)) {
                Field[] fs;
                for (Field f : fs = clazz.getDeclaredFields()) {
                    attrMap.put(f.getName(), f.getType());
                }
                clazz = clazz.getSuperclass();
            }
            attrMap.remove("serialVersionUID");
            return attrMap;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> tClass) {
        try {
            return tClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class forName(String canonicalName) {
        if (StringUtil.isEmpty(canonicalName)) {
            return null;
        }
        if (canonicalName.equals("int")) {
            canonicalName = "java.lang.Integer";
        } else if (canonicalName.equals("double")) {
            canonicalName = "java.lang.Double";
        } else if (canonicalName.equals("char")) {
            canonicalName = "java.lang.Char";
        } else if (canonicalName.equals("long")) {
            canonicalName = "java.lang.Long";
        }
        try {
            return Class.forName(canonicalName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T> Class<T> getGeneric(Class clazz) {
        try {
            Class type = clazz;
            if (type instanceof ParameterizedType) {
                Type[] params = ((ParameterizedType)((Object)type)).getActualTypeArguments();
                return (Class)params[0];
            }
            Type genType = clazz.getGenericSuperclass();
            if (!(genType instanceof ParameterizedType)) {
                return Object.class;
            }
            Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
            return (Class)params[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Annotation> getClassAnnotation(Class<?> aclass) {
        ArrayList<Annotation> aList = new ArrayList<Annotation>();
        try {
            Class<?> clazz = aclass;
            while (!clazz.equals(Object.class)) {
                Annotation[] classAnnotations;
                for (Annotation f : classAnnotations = clazz.getDeclaredAnnotations()) {
                    if (aList.contains(f)) continue;
                    aList.add(f);
                }
                clazz = clazz.getSuperclass();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return aList;
    }

    public static <T> Map<String, T> getClassAnnotation(Class clazz, Class<T> annotation) {
        HashMap<String, Annotation> map = new HashMap<String, Annotation>();
        Class cl = clazz;
        while (!cl.equals(Object.class)) {
            Annotation[] ans;
            for (Annotation an : ans = cl.getDeclaredAnnotations()) {
                if (!an.annotationType().equals(annotation)) continue;
                Annotation t = an;
                map.put(cl.getName(), t);
            }
            cl = cl.getSuperclass();
        }
        return map;
    }

    public static <T> Map<String, T> getFieldAnnotation(Class clazz, Class<T> annotation) {
        return ObjectUtil.getFieldAnnotation(clazz, null, annotation);
    }

    public static <T> Map<String, T> getFieldAnnotation(Class clazz, String fieldName, Class<T> annotation) {
        HashMap<String, Annotation> map = new HashMap<String, Annotation>();
        Class cl = clazz;
        while (!cl.equals(Object.class)) {
            Field[] fields;
            for (Field f : fields = cl.getDeclaredFields()) {
                Annotation[] ans;
                for (Annotation an : ans = f.getDeclaredAnnotations()) {
                    if (!an.annotationType().equals(annotation)) continue;
                    Annotation t = an;
                    if (map.get(f.getName()) == null) {
                        map.put(f.getName(), t);
                    }
                    if (StringUtil.isEmpty(fieldName) || !f.getName().equals(fieldName)) continue;
                    return map;
                }
            }
            cl = cl.getSuperclass();
        }
        return map;
    }

    public static byte[] parseObjForByte(Object obj) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = null;
        try {
            objOut = new ObjectOutputStream(byteOut);
            objOut.writeObject(obj);
            byte[] byArray = byteOut.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (objOut != null) {
                    objOut.close();
                }
                if (byteOut != null) {
                    byteOut.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static <T> T parseToObject(Object value, Class<T> type) {
        Object result = null;
        if (value == null || type == String.class) {
            result = value == null ? null : value.toString();
        } else if (type == Character.class || type == Character.TYPE) {
            char[] chars = value.toString().toCharArray();
            result = chars.length > 0 ? (chars.length > 1 ? (Object)chars : Character.valueOf(chars[0])) : Character.valueOf('\u0000');
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            result = value.toString().equalsIgnoreCase("true") ? Boolean.valueOf(true) : (value.toString().equalsIgnoreCase("false") ? Boolean.valueOf(false) : value);
        } else if (type == Long.class || type == Long.TYPE) {
            result = Long.parseLong(value.toString());
        } else if (type == Integer.class || type == Integer.TYPE) {
            result = Integer.parseInt(value.toString());
        } else if (type == Double.class || type == Double.TYPE) {
            result = Double.parseDouble(value.toString());
        } else if (type == Float.class || type == Float.TYPE) {
            result = Float.valueOf(Float.parseFloat(value.toString()));
        } else if (type == Byte.class || type == Byte.TYPE) {
            result = Byte.parseByte(value.toString());
        } else if (type == Short.class || type == Short.TYPE) {
            result = Short.parseShort(value.toString());
        }
        return (T)result;
    }

    public static boolean isBaseClass(Class value) {
        if (value == null) {
            return true;
        }
        if (value.equals(Long.class) || value.equals(Long.TYPE)) {
            return true;
        }
        if (value.equals(Integer.class) || value.equals(Integer.TYPE)) {
            return true;
        }
        if (value.equals(Double.class) || value.equals(Double.TYPE)) {
            return true;
        }
        if (value.equals(Float.class) || value.equals(Float.TYPE)) {
            return true;
        }
        if (value.equals(Byte.class) || value.equals(Byte.TYPE)) {
            return true;
        }
        if (value.equals(Boolean.class) || value.equals(Boolean.TYPE)) {
            return true;
        }
        if (value.equals(Short.class) || value.equals(Short.TYPE)) {
            return true;
        }
        if (value.equals(Character.class) || value.equals(Character.TYPE)) {
            return true;
        }
        return value.equals(String.class);
    }

    public static boolean isBaseObject(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Long) {
            return true;
        }
        if (value instanceof Integer) {
            return true;
        }
        if (value instanceof Double) {
            return true;
        }
        if (value instanceof Float) {
            return true;
        }
        if (value instanceof Byte) {
            return true;
        }
        if (value instanceof Boolean) {
            return true;
        }
        if (value instanceof Short) {
            return true;
        }
        if (value instanceof Character) {
            return true;
        }
        return value instanceof String;
    }

    public static <T> void cleanInitValue(T bean) {
        if (bean == null) {
            return;
        }
        try {
            Class<?> clazz = bean.getClass();
            Object obj = clazz.newInstance();
            while (!clazz.equals(Object.class)) {
                Field[] fs;
                for (Field f : fs = clazz.getDeclaredFields()) {
                    if (Modifier.isFinal(f.getModifiers())) continue;
                    f.setAccessible(true);
                    Object initValue = f.get(obj);
                    Object oldValue = f.get(bean);
                    if (initValue != null && initValue.equals(oldValue)) {
                        f.set(bean, null);
                    }
                    f.setAccessible(false);
                }
                clazz = clazz.getSuperclass();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

