/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.util;

import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpUtilBAK {
    public static final String requestMethod_POST = "POST";
    public static final String requestMethod_GET = "GET";
    public static final String requestMethod_PUT = "PUT";
    public static final String requestMethod_DELETE = "DELETE";
    public static final String requestMethod_PATCH = "PATCH";
    private String requestUrl;
    private String outCharSet = "UTF-8";
    private String requestParam;
    private String requestMethod;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private String responseSessionId;

    public HttpUtilBAK() {
        this.outCharSet = "utf-8";
        this.requestMethod = requestMethod_GET;
    }

    public HttpUtilBAK(String requestUrl) {
        this.requestUrl = requestUrl;
        this.outCharSet = "utf-8";
        this.requestMethod = requestMethod_GET;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public HttpUtilBAK setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
        return this;
    }

    public String getOutCharSet() {
        return this.outCharSet;
    }

    public HttpUtilBAK setOutCharSet(String outCharSet) {
        this.outCharSet = outCharSet;
        return this;
    }

    public String getRequestParam() {
        return this.requestParam;
    }

    public HttpUtilBAK setRequestParam(String param) {
        this.requestParam = param;
        return this;
    }

    public <T> HttpUtilBAK setFormRequestParam(T t) {
        Map<String, Object> map = JsonUtil.beanToMap(t);
        return this.setRequestParam(map);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void clearParams() {
        this.requestParam = null;
    }

    public <T> HttpUtilBAK setJsonRequestParam(T t) {
        this.setHeaders("Content-Type", "application/json");
        return this.setRequestParam(JsonUtil.beanToJson(t));
    }

    public String getResponseSessionId() {
        return this.responseSessionId;
    }

    public void addSession(String sessionId) {
        if (StringUtil.isEmpty(sessionId)) {
            return;
        }
        if (sessionId.toUpperCase().startsWith("JSESSIONID=")) {
            this.headers.put("Cookie", sessionId);
        } else {
            this.headers.put("Cookie", "JSESSIONID=" + sessionId);
        }
    }

    public HttpUtilBAK setRequestParam(String key, String val) {
        this.requestParam = this.requestParam == null ? key + "=" + val : this.requestParam + "&" + key + "=" + val;
        return this;
    }

    public HttpUtilBAK setRequestParam(Map paramMap) {
        String paramStr = "";
        if (paramMap != null) {
            for (Object key : paramMap.keySet()) {
                paramStr = paramStr + key + "=";
                paramStr = paramStr + paramMap.get(key) + "&";
            }
            if (!StringUtil.isEmpty(paramStr)) {
                paramStr = paramStr.substring(0, paramStr.length() - 1);
            }
        }
        this.requestParam = this.requestParam == null ? paramStr : this.requestParam + "&" + paramStr;
        return this;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public HttpUtilBAK setRequestMethod(String method) {
        this.requestMethod = method;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public HttpUtilBAK setHeaders(Map<String, String> headers) {
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        this.headers = headers;
        return this;
    }

    public HttpUtilBAK setHeaders(String key, String val) {
        this.headers.put(key, val);
        return this;
    }

    private String getNotNullUrl() {
        String url = this.getRequestUrl();
        if (url == null || url.length() == 0) {
            throw new RuntimeException("url  is  null");
        }
        return url;
    }

    public static String jsonToForm(String json) {
        if (StringUtil.isEmpty(json)) {
            return null;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        StringBuffer listParam = new StringBuffer();
        JSONObject obj = JSONObject.parseObject((String)json);
        Set entrySet = obj.entrySet();
        for (Map.Entry entry : entrySet) {
            List list;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (ObjectUtil.isBaseObject(value)) {
                param.put(key, value);
                continue;
            }
            if (Map.class.isAssignableFrom(value.getClass())) {
                Map map = (Map)value;
                if (map.isEmpty()) continue;
                HttpUtilBAK.nestedMap(key, map, listParam, param);
                continue;
            }
            if (!Collection.class.isAssignableFrom(value.getClass()) || (list = (List)value).isEmpty()) continue;
            HttpUtilBAK.nestedList(key, list, listParam, param);
        }
        HttpUtilBAK util = new HttpUtilBAK();
        util.setRequestParam(param);
        return util.getRequestParam() + listParam.toString();
    }

    private static void nestedMap(String key, Map<String, Object> map, StringBuffer listParam, Map<String, Object> param) {
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            List list2;
            String key2 = entry.getKey();
            Object value = entry.getValue();
            if (ObjectUtil.isBaseObject(value)) {
                param.put(key + "." + key2, value);
                continue;
            }
            if (Map.class.isAssignableFrom(value.getClass())) {
                Map map2 = (Map)value;
                if (map.isEmpty()) continue;
                HttpUtilBAK.nestedMap(key + "." + key2, map2, listParam, param);
                continue;
            }
            if (!Collection.class.isAssignableFrom(value.getClass()) || (list2 = (List)value).isEmpty()) continue;
            HttpUtilBAK.nestedList(key + "." + key2, list2, listParam, param);
        }
    }

    private static void nestedList(String key, List<Object> list, StringBuffer listParam, Map<String, Object> param) {
        for (Object obj : list) {
            if (ObjectUtil.isBaseObject(obj)) {
                listParam.append("&" + key + "=" + obj);
                continue;
            }
            if (Map.class.isAssignableFrom(obj.getClass())) {
                Map map2 = (Map)obj;
                if (map2.isEmpty()) continue;
                HttpUtilBAK.nestedMap(key, map2, listParam, param);
                continue;
            }
            if (!Collection.class.isAssignableFrom(obj.getClass())) continue;
            List list2 = (List)obj;
            if (list.isEmpty()) continue;
            HttpUtilBAK.nestedList(key, list2, listParam, param);
        }
    }

    public static String doUrl(String webUrl, String method, Map<String, String> headers, Map<String, String> paramMap) {
        String paramStr = "";
        if (paramMap != null) {
            for (String key : paramMap.keySet()) {
                paramStr = paramStr + key + "=";
                paramStr = paramStr + paramMap.get(key) + "&";
            }
            paramStr = paramStr.substring(0, paramStr.length() - 1);
        }
        return HttpUtilBAK.doUrl(webUrl, method, headers, paramStr);
    }

    public static String doUrl(String webUrl, String method, Map<String, String> headers, String message) {
        try {
            InputStream in;
            URL url = new URL(webUrl);
            URLConnection connect = url.openConnection();
            connect.setUseCaches(false);
            connect.setDoOutput(true);
            if (headers != null) {
                for (String key : headers.keySet()) {
                    connect.setRequestProperty(key, headers.get(key));
                }
            }
            if (method != null) {
                ((HttpURLConnection)connect).setRequestMethod(method);
                if (message != null && !message.equals("")) {
                    connect.getOutputStream().write(message.getBytes());
                    connect.getOutputStream().close();
                }
            }
            HttpURLConnection httpUrlConnection = (HttpURLConnection)connect;
            httpUrlConnection.connect();
            if (httpUrlConnection.getResponseCode() != 200) {
                in = httpUrlConnection.getErrorStream();
                byte[] bts = new byte[1024];
                int length = 0;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while ((length = in.read(bts)) > 0) {
                    bout.write(bts, 0, length);
                    bout.flush();
                }
                throw new RuntimeException(httpUrlConnection.getResponseCode() + ":" + new String(bout.toByteArray()));
            }
            in = httpUrlConnection.getInputStream();
            byte[] bts = new byte[1024];
            int length = 0;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while ((length = in.read(bts)) > 0) {
                bout.write(bts, 0, length);
                bout.flush();
            }
            return new String(bout.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream doInputStreamUrl(String webUrl, String method) {
        try {
            URL url = new URL(webUrl);
            URLConnection connect = url.openConnection();
            connect.setUseCaches(false);
            if (method != null) {
                ((HttpURLConnection)connect).setRequestMethod(method);
            }
            return connect.getInputStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String doUrl(String webUrl, String method) {
        return HttpUtilBAK.doUrl(webUrl, method, null, "");
    }

    public InputStream doInputStreamUrl() {
        try {
            URL url = new URL(this.getNotNullUrl());
            URLConnection connect = url.openConnection();
            connect.setUseCaches(false);
            connect.setDoOutput(true);
            this.addSession(this.responseSessionId);
            if (this.headers != null) {
                for (String key : this.headers.keySet()) {
                    connect.setRequestProperty(key, this.headers.get(key));
                }
            }
            if (this.requestMethod != null) {
                ((HttpURLConnection)connect).setRequestMethod(this.requestMethod);
            }
            if (this.requestParam != null && !this.requestParam.equals("")) {
                connect.getOutputStream().write(this.requestParam.getBytes());
                connect.getOutputStream().close();
            }
            HttpURLConnection httpUrlConnection = (HttpURLConnection)connect;
            httpUrlConnection.connect();
            if (httpUrlConnection.getResponseCode() != 200) {
                InputStream in = httpUrlConnection.getErrorStream();
                byte[] bts = new byte[1024];
                int length = 0;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while ((length = in.read(bts)) > 0) {
                    bout.write(bts, 0, length);
                    bout.flush();
                }
                throw new RuntimeException(httpUrlConnection.getResponseCode() + ":" + new String(bout.toByteArray(), this.outCharSet));
            }
            Map<String, List<String>> headers = connect.getHeaderFields();
            Set<Map.Entry<String, List<String>>> entry = headers.entrySet();
            for (Map.Entry<String, List<String>> en : entry) {
                String key = en.getKey();
                List<String> value = en.getValue();
                if (StringUtil.isEmpty(key) || StringUtil.isEmpty(value)) continue;
                this.responseHeaders.put(key, value.toString());
                if (!key.equals("Set-Cookie")) continue;
                this.responseSessionId = value.get(0);
            }
            return connect.getInputStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String doUrl() {
        try {
            InputStream in = this.doInputStreamUrl();
            byte[] bts = new byte[1024];
            int length = 0;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while ((length = in.read(bts)) > 0) {
                bout.write(bts, 0, length);
                bout.flush();
            }
            return new String(bout.toByteArray(), this.outCharSet);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String doFileUrl(String paramName, File file) {
        try {
            return this.doFileUrl(paramName, new FileInputStream(file), file.getName(), null);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String doFileUrl(String paramName, InputStream input, String fileName, Map params) {
        String newLine = "\r\n";
        String preFix = "--";
        String BOUNDARY = "----WebKitFormBoundaryCXRtmcVNK0H70msG";
        try {
            InputStream errorIn;
            URL url = new URL(this.getNotNullUrl());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod(requestMethod_POST);
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.setRequestProperty("Charsert", "UTF-8");
            if (this.headers != null && !this.headers.isEmpty()) {
                Set<Map.Entry<String, String>> set = this.headers.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=----WebKitFormBoundaryCXRtmcVNK0H70msG");
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            if (params != null && !params.isEmpty()) {
                Set set = params.keySet();
                for (Object object : set) {
                    String key = object.toString();
                    String val = params.get(object).toString();
                    out.writeBytes("------WebKitFormBoundaryCXRtmcVNK0H70msG\r\n");
                    out.writeBytes("Content-Disposition: form-data; name=\"" + key + "\"" + "\r\n");
                    out.writeBytes("\r\n");
                    out.writeBytes(URLEncoder.encode(val, "utf-8"));
                    out.writeBytes("\r\n");
                }
            }
            byte[] end_data = "\r\n------WebKitFormBoundaryCXRtmcVNK0H70msG--\r\n".getBytes();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("--");
            stringBuilder.append("----WebKitFormBoundaryCXRtmcVNK0H70msG");
            stringBuilder.append("\r\n");
            stringBuilder.append("Content-Disposition: form-data;name=\"" + URLEncoder.encode(paramName, "utf-8") + "\";filename=\"" + fileName + "\"\r\n");
            stringBuilder.append("Content-Type:application/octet-stream\r\n\r\n");
            byte[] data = stringBuilder.toString().getBytes();
            out.write(data);
            DataInputStream in = new DataInputStream(input);
            int bytes = 0;
            byte[] bufferOut = new byte[1024];
            while ((bytes = in.read(bufferOut)) != -1) {
                out.write(bufferOut, 0, bytes);
            }
            out.write("\r\n".getBytes());
            in.close();
            out.write(end_data);
            out.flush();
            out.close();
            if (conn.getResponseCode() != 200 && (errorIn = conn.getErrorStream()) != null) {
                byte[] bts = new byte[1024];
                int length = 0;
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                while ((length = errorIn.read(bts)) > 0) {
                    bout.write(bts, 0, length);
                    bout.flush();
                }
                throw new RuntimeException(conn.getResponseCode() + ":" + new String(bout.toByteArray(), this.outCharSet));
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), this.outCharSet));
            String line = null;
            StringBuffer result = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            Map<String, List<String>> headers = conn.getHeaderFields();
            Set<Map.Entry<String, List<String>>> entry = headers.entrySet();
            for (Map.Entry<String, List<String>> en : entry) {
                String key = en.getKey();
                List<String> value = en.getValue();
                if (StringUtil.isEmpty(key) || StringUtil.isEmpty(value)) continue;
                this.responseHeaders.put(key, value.toString());
                if (!key.equals("Set-Cookie")) continue;
                this.responseSessionId = value.get(0);
                this.responseSessionId = this.responseSessionId.substring(0, this.responseSessionId.indexOf(";"));
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        HttpUtilBAK util = new HttpUtilBAK("http://localhost:7103/yifei-apidoc/getInterfaces?controllerName=-back-com.yifei.video.controller.MenuController");
        util.setRequestMethod(requestMethod_GET);
        System.out.println(util.doUrl());
    }
}

