/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.util;

import cn.easyutil.easyapi.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class FileUtil {
    public static File createNewFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            return file;
        }
        String parentPath = path.substring(0, path.lastIndexOf(File.separator));
        new File(parentPath).mkdirs();
        try {
            File f = new File(path);
            f.createNewFile();
            return f;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void createNewFolder(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static void write(File file, String content) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"), 524288);){
            bufferedWriter.write(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void del(File file) {
        FileUtil.del(file, true);
    }

    public static void del(File file, boolean delChildren) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && delChildren) {
            File[] files;
            for (File f : files = file.listFiles()) {
                FileUtil.del(f, delChildren);
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(File file) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            StringBuffer sb = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    public static Set<Class> getClass4Annotation(String packagePath, Class<?> ... apiClass) {
        HashSet<Class> classSet = new HashSet<Class>();
        boolean recursive = true;
        try {
            String path = StringUtil.isEmpty(packagePath) ? "" : packagePath;
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(path);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if (!"file".equals(protocol)) continue;
                String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                File dir = new File(filePath);
                ArrayList<File> fileList = new ArrayList<File>();
                FileUtil.fetchFileList(dir, fileList);
                for (File f : fileList) {
                    String fileName = f.getAbsolutePath();
                    if (!fileName.endsWith(".class")) continue;
                    String noSuffixFileName = fileName.substring(8 + fileName.lastIndexOf("classes"), fileName.indexOf(".class"));
                    String regex = "\\\\";
                    if (!"\\".equals(File.separator)) {
                        regex = File.separator;
                    }
                    String filePackage = noSuffixFileName.replaceAll(regex, ".");
                    try {
                        Class<?> clazz = Class.forName(filePackage);
                        for (Class<?> c : apiClass) {
                            if (null == clazz.getAnnotation(c)) continue;
                            classSet.add(clazz);
                        }
                    }
                    catch (ExceptionInInitializerError e) {
                        System.out.println("\u626b\u63cf\u63a7\u5236\u5668\u9519\u8bef:" + filePackage);
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return classSet;
    }

    public static void fetchFileList(File dir, List<File> fileList) {
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            for (File f : Objects.requireNonNull(dir.listFiles())) {
                FileUtil.fetchFileList(f, fileList);
            }
        } else {
            fileList.add(dir);
        }
    }
}

