/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.service;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.datasource.EasyapiBindSqlExecution;
import cn.easyutil.easyapi.datasource.bean.EasyApiBindSqlResult;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.util.ObjectUtil;
import java.util.Collection;
import java.util.List;

public class DBService<T extends BaseDbEntity> {
    public void insert(T t) {
        ((BaseDbEntity)t).setId(null);
        ((BaseDbEntity)t).setCreateTime(System.currentTimeMillis());
        ((BaseDbEntity)t).setUpdateTime(System.currentTimeMillis());
        this.getExecution().insert(t);
    }

    public void insertAny(Collection<T> collection) {
        this.getExecution().insert(collection);
    }

    public T getById(Long id) {
        try {
            BaseDbEntity t = (BaseDbEntity)ObjectUtil.getGeneric(this.getClass()).newInstance();
            t.setId(id);
            return (T)this.get(t);
        }
        catch (Exception e) {
            throw new ApidocException(e);
        }
    }

    public T get(T t) {
        return this.get(EasyapiBindSQLExecuter.build(t));
    }

    public T get(EasyapiBindSQLExecuter executer) {
        return (T)((BaseDbEntity)this.getExecution().selectOne(executer.eq(BaseDbEntity::getDeleted, (Object)0, new Boolean[0])));
    }

    public List<T> list(T t) {
        return this.list(EasyapiBindSQLExecuter.build(t));
    }

    public List<T> list(EasyapiBindSQLExecuter executer) {
        return this.getExecution().select(executer.eq(BaseDbEntity::getDeleted, (Object)0, new Boolean[0]).orderBy(BaseDbEntity::getCreateTime, false));
    }

    public void update(T t) {
        ((BaseDbEntity)t).setUpdateTime(System.currentTimeMillis());
        this.getExecution().update(t);
    }

    public void update(EasyapiBindSQLExecuter executer) {
        this.getExecution().update(executer);
    }

    public void deleteById(Long id) {
        try {
            BaseDbEntity t = (BaseDbEntity)ObjectUtil.getGeneric(this.getClass()).newInstance();
            t.setId(id);
            this.delete(t);
        }
        catch (Exception e) {
            throw new ApidocException(e);
        }
    }

    public void delete(T t) {
        this.getExecution().delete(t);
    }

    public void delete(EasyapiBindSQLExecuter executer) {
        this.getExecution().delete(executer);
    }

    public EasyApiBindSqlResult page(T t, Integer current, Integer showCount) {
        return this.page(EasyapiBindSQLExecuter.build(t), current, showCount);
    }

    public EasyApiBindSqlResult page(EasyapiBindSQLExecuter executer, Integer current, Integer showCount) {
        if (current == null) {
            current = 1;
        }
        if (showCount == null) {
            showCount = 5;
        }
        if (current < 0) {
            EasyApiBindSqlResult<T> result = new EasyApiBindSqlResult<T>();
            result.setResultList(this.list(executer));
            return result;
        }
        return this.getExecution().listPage(executer.eq(BaseDbEntity::getDeleted, (Object)0, new Boolean[0]).orderBy(BaseDbEntity::getCreateTime, false), current, showCount);
    }

    protected EasyapiBindSqlExecution getExecution() {
        return ProjectContext.execution;
    }
}

