/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.doc.ParamBean;
import cn.easyutil.easyapi.filter.ApiBaseInfo;
import cn.easyutil.easyapi.filter.MethodParameter;
import cn.easyutil.easyapi.filter.ReadResponseParamApiFilter;
import cn.easyutil.easyapi.filter.model.DefaultReadResponseParamApi;
import cn.easyutil.easyapi.logic.creator.NewParamsBeanCreator;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class ResponseParamCreator {
    private Method method;
    private ReadResponseParamApiFilter filter = new DefaultReadResponseParamApi();
    private Map<String, ParamBean> params = new HashMap<String, ParamBean>();
    private NewParamsBeanCreator paramsBeanCreator;

    private ResponseParamCreator() {
    }

    public static ResponseParamCreator builder(Method method, NewParamsBeanCreator paramsBeanCreator) {
        ResponseParamCreator creator = new ResponseParamCreator();
        creator.method = method;
        creator.paramsBeanCreator = paramsBeanCreator;
        return creator;
    }

    public ResponseParamCreator setFilter(ReadResponseParamApiFilter filter) {
        if (filter == null) {
            return this;
        }
        this.filter = filter;
        return this;
    }

    public Map<String, ParamBean> buildParamBean() {
        if (this.params.size() > 0) {
            return this.params;
        }
        try {
            this.create();
        }
        catch (Exception e) {
            System.out.println("\u521b\u5efa\u8fd4\u56de\u503c:" + this.method.toGenericString() + "\u5931\u8d25");
            e.printStackTrace();
        }
        return this.params;
    }

    private void create() {
        Class aClass = this.filter.parseType(this.method.getReturnType());
        Type type = this.method.getGenericReturnType();
        if (type == Void.TYPE) {
            return;
        }
        GenericTypeBind bind = null;
        if (GenericTypeUtil.isGeneric(type)) {
            aClass = GenericTypeUtil.getOwnerClass(type);
            bind = GenericTypeUtil.getGenericTypes(type);
        }
        MethodParameter mp = new MethodParameter();
        mp.setGenericType(type);
        mp.setOwnerClass(aClass);
        mp.setGenericBind(bind);
        ProjectContext.readBeanApiFilter.buildInfo(new ApiBaseInfo().setController(this.method.getDeclaringClass()).setMethod(this.method).setParameter(mp));
        ParamBean info = new ParamBean();
        info.setName("_null");
        info.setType(JavaType.getJavaTypeByType(type).getType());
        info.setRequired(1);
        info.setShow(1);
        info.setJava_name(aClass.getCanonicalName());
        switch (JavaType.getType(info.getType())) {
            case Map: {
                return;
            }
            case Object: {
                this.params.putAll(this.paramsBeanCreator.readBean(type, bind));
                break;
            }
            case ArrayObject: {
                info.setChildren(this.paramsBeanCreator.readArrayObject(type, bind));
                this.params.put(info.getName(), info);
                break;
            }
            case Array: {
                info.setChildren(this.paramsBeanCreator.readArray(type, bind));
                this.params.put(info.getName(), info);
                break;
            }
            default: {
                this.params.put(info.getName(), info);
            }
        }
    }
}

