/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RequestParameter;
import cn.easyutil.easyapi.entity.doc.ParamBean;
import cn.easyutil.easyapi.filter.ApiBaseInfo;
import cn.easyutil.easyapi.filter.MethodParameter;
import cn.easyutil.easyapi.filter.ReadBeanApiFilter;
import cn.easyutil.easyapi.filter.ReadInterfaceApiFilter;
import cn.easyutil.easyapi.filter.ReadRequestParamApiFilter;
import cn.easyutil.easyapi.filter.model.DefaultReadBeanApi;
import cn.easyutil.easyapi.filter.model.DefaultReadInterfaceApi;
import cn.easyutil.easyapi.filter.model.DefaultReadRequestParamApi;
import cn.easyutil.easyapi.javadoc.reader.SourceParameterComment;
import cn.easyutil.easyapi.logic.creator.NewParamsBeanCreator;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.DefaultParameterNameDiscoverer;

public class RequestParamCreator {
    private Map<String, Parameter> parameters = new HashMap<String, Parameter>();
    private Map<String, ParamBean> params = new HashMap<String, ParamBean>();
    private Method method;
    private ReadBeanApiFilter filter = new DefaultReadBeanApi();
    private ReadInterfaceApiFilter inFilter = new DefaultReadInterfaceApi();
    private ReadRequestParamApiFilter reFilter = new DefaultReadRequestParamApi();
    private List<SourceParameterComment> comment = new ArrayList<SourceParameterComment>();
    private NewParamsBeanCreator paramsBeanCreator;

    private RequestParamCreator() {
    }

    public static RequestParamCreator builder(Method method, NewParamsBeanCreator paramsBeanCreator) {
        RequestParamCreator creator = new RequestParamCreator();
        DefaultParameterNameDiscoverer discover = new DefaultParameterNameDiscoverer();
        String[] parameterNames = discover.getParameterNames(method);
        Parameter[] parameters = method.getParameters();
        if (parameters != null && parameterNames != null) {
            for (int i = 0; i < parameterNames.length; ++i) {
                creator.parameters.put(parameterNames[i], parameters[i]);
            }
        }
        creator.method = method;
        creator.paramsBeanCreator = paramsBeanCreator;
        return creator;
    }

    public RequestParamCreator setBeanFilter(ReadBeanApiFilter filter) {
        if (filter == null) {
            return this;
        }
        this.filter = filter;
        return this;
    }

    public RequestParamCreator setInterfaceFilter(ReadInterfaceApiFilter filter) {
        if (filter == null) {
            return this;
        }
        this.inFilter = filter;
        return this;
    }

    public RequestParamCreator setRequestParamFilter(ReadRequestParamApiFilter filter) {
        if (filter == null) {
            return this;
        }
        this.reFilter = filter;
        return this;
    }

    public RequestParamCreator buildSourceComment(List<SourceParameterComment> comment) {
        if (comment == null) {
            return this;
        }
        this.comment = comment;
        return this;
    }

    public Map<String, ParamBean> buildParamBean() {
        if (this.params.size() > 0) {
            return this.params;
        }
        try {
            this.create();
        }
        catch (Exception e) {
            System.out.println("\u521b\u5efa\u5165\u53c2:" + this.method.toGenericString() + "\u5931\u8d25,\u539f\u56e0:" + e.getMessage());
            e.printStackTrace();
        }
        return this.params;
    }

    private void create() {
        RequestParameter[] requestParameters;
        if (this.parameters == null || this.parameters.size() == 0) {
            return;
        }
        ApidocComment api = this.method.getDeclaredAnnotation(ApidocComment.class);
        HashMap<String, Class> requestParameterParse = new HashMap<String, Class>();
        if (api != null && (requestParameters = api.requestParameterParse()) != null && requestParameters.length > 0) {
            for (RequestParameter parameter : requestParameters) {
                if (StringUtil.isEmpty(parameter.parameterName()) || StringUtil.isEmpty(parameter.parameterType())) continue;
                requestParameterParse.put(parameter.parameterName(), parameter.parameterType());
            }
        }
        block6: for (Map.Entry<String, Parameter> next : this.parameters.entrySet()) {
            String parameterName = next.getKey();
            Parameter parameter = next.getValue();
            MethodParameter mp = new MethodParameter();
            mp.setParameter(parameter);
            mp.setOwnerClass(GenericTypeUtil.getOwnerClass(parameter.getParameterizedType()));
            mp.setGenericType(parameter.getParameterizedType());
            mp.setGenericBind(GenericTypeUtil.getGenericTypes(parameter.getParameterizedType()));
            this.reFilter.buildInfo(new ApiBaseInfo().setController(this.method.getDeclaringClass()).setParameter(mp).setComment(this.comment.stream().filter(item -> item.getName().equals(parameter.getName())).findFirst().orElse(null)).setMethod(this.method));
            Object type = this.reFilter.getType(parameter);
            GenericTypeBind bind = null;
            if (GenericTypeUtil.isGeneric((Type)type)) {
                bind = GenericTypeUtil.getGenericTypes((Type)type);
            }
            Class aClass = GenericTypeUtil.getOwnerClass((Type)type);
            mp.setGenericBind(bind);
            mp.setGenericType((Type)type);
            mp.setOwnerClass(aClass);
            this.reFilter.getInfo().setParameter(mp);
            if (this.reFilter.ignore(aClass) || api != null && api.ignore()) continue;
            if (aClass.equals(Object.class)) {
                type = Map.class;
            }
            if (requestParameterParse.get(parameterName) != null) {
                type = (Type)requestParameterParse.get(parameterName);
            }
            ParamBean info = new ParamBean();
            info.setType(JavaType.getJavaTypeByType((Type)type).getType());
            info.setRequired(1);
            info.setShow(1);
            info.setJava_name(parameter.getType().getCanonicalName());
            String parameterName1 = this.getParameterName(parameter);
            info.setName(parameterName1 == null ? parameterName : parameterName1);
            info.setRemark(this.getParameterComment(parameter, parameterName));
            info.setOldMockValue(this.inFilter.requestParamMockValue(parameter));
            info.setMockValue(this.filter.parseMock(info.getOldMockValue()));
            switch (JavaType.getType(info.getType())) {
                case Object: {
                    this.filter.buildInfo(this.reFilter.getInfo());
                    this.params.putAll(this.paramsBeanCreator.readBean((Type)type, bind));
                    continue block6;
                }
                case ArrayObject: {
                    this.filter.buildInfo(this.reFilter.getInfo());
                    info.setChildren(this.paramsBeanCreator.readArrayObject((Type)type, bind));
                    this.params.put(info.getName(), info);
                    continue block6;
                }
                case Array: {
                    info.setChildren(this.paramsBeanCreator.readArray((Type)type, bind));
                    this.params.put(info.getName(), info);
                    continue block6;
                }
            }
            this.params.put(info.getName(), info);
        }
    }

    private String getParameterName(Parameter parameter) {
        String paramName = this.inFilter.requestParamName(parameter);
        if (StringUtil.isEmpty(paramName)) {
            return null;
        }
        return paramName;
    }

    private String getParameterComment(Parameter parameter, String parameterName) {
        String comment = this.inFilter.requestParamComments(parameter);
        if (StringUtil.isEmpty(comment)) {
            SourceParameterComment parameterComment = this.comment.stream().filter(item -> item.getName().equals(parameterName)).findFirst().orElse(null);
            if (parameterComment != null) {
                comment = parameterComment.getComment();
            }
            if (comment == null) {
                return parameterName;
            }
        }
        return comment;
    }
}

