/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.doc.ParamBean;
import cn.easyutil.easyapi.filter.ReadBeanApiFilter;
import cn.easyutil.easyapi.javadoc.reader.FieldComment;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceReader;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class NewParamsBeanCreator {
    public static final String nullKey = "_null";
    private ReadBeanApiFilter filter;
    private String projectBasePath;
    private Map<String, Map<String, ParamBean>> creaters = new HashMap<String, Map<String, ParamBean>>();

    public static NewParamsBeanCreator builder(ReadBeanApiFilter filter, String projectBasePath) {
        NewParamsBeanCreator creator = new NewParamsBeanCreator(filter, projectBasePath);
        return creator;
    }

    public NewParamsBeanCreator(ReadBeanApiFilter filter, String projectBasePath) {
        this.filter = filter;
        this.projectBasePath = projectBasePath;
    }

    private String buildCreatersKey(Class aClass, Collection genericTypes) {
        String bindKey = "";
        if (genericTypes.size() > 0) {
            bindKey = genericTypes.stream().map(g -> g.toString()).collect(Collectors.joining()).toString();
        }
        return aClass.getCanonicalName() + bindKey;
    }

    public Map<String, ParamBean> readBean(Type type, GenericTypeBind binds) {
        Class aClass;
        HashMap<String, ParamBean> result = new HashMap<String, ParamBean>();
        if (binds == null) {
            binds = new GenericTypeBind();
        }
        if (GenericTypeUtil.isGeneric(type)) {
            aClass = GenericTypeUtil.getOwnerClass(type);
            binds.binds(GenericTypeUtil.getGenericTypes(type));
        } else {
            aClass = (Class)type;
        }
        if (aClass == Object.class || aClass == Class.class) {
            return new HashMap<String, ParamBean>();
        }
        String creatersKey = this.buildCreatersKey(aClass, binds.keys());
        if (binds.size() == 0 && this.creaters.containsKey(creatersKey)) {
            result.putAll(this.creaters.get(creatersKey));
            return result;
        }
        this.creaters.put(creatersKey, new HashMap());
        Map<String, ParamBean> bean = this.getBean(aClass, binds);
        this.creaters.put(creatersKey, bean);
        return bean;
    }

    public List<Object> readArray(Type type, GenericTypeBind binds) {
        if (binds == null) {
            binds = new GenericTypeBind();
        }
        Type arrayType = GenericTypeUtil.getOwnerClass(type);
        if (GenericTypeUtil.isGeneric(type)) {
            GenericTypeBind genericTypeBind = GenericTypeUtil.getGenericTypes(type);
            Type bindType = binds.matchVariable(genericTypeBind.get(0).getTypeName());
            arrayType = bindType != null ? bindType : genericTypeBind.get(0);
        }
        ArrayList<Object> childrenArray = new ArrayList<Object>();
        HashMap<String, ParamBean> childrenMap = new HashMap<String, ParamBean>();
        ParamBean childrean = new ParamBean();
        childrean.setRequired(0);
        childrean.setShow(0);
        childrean.setType(JavaType.getJavaTypeByType(arrayType).getType());
        childrean.setJava_name(type.getTypeName());
        childrenMap.put(nullKey, childrean);
        childrenArray.add(childrenMap);
        return childrenArray;
    }

    public List<Object> readArrayObject(Type type, GenericTypeBind binds) {
        if (binds == null) {
            binds = new GenericTypeBind();
        }
        ArrayList<Object> childrenArray = new ArrayList<Object>();
        Object arrayType = GenericTypeUtil.getOwnerClass(type);
        if (GenericTypeUtil.isGeneric(type)) {
            GenericTypeBind genericTypeBind = GenericTypeUtil.getGenericTypes(type);
            Type bindType = binds.matchVariable(genericTypeBind.get(0).getTypeName());
            arrayType = bindType != null ? bindType : genericTypeBind.get(0);
            binds.binds(GenericTypeUtil.getGenericTypes((Type)arrayType));
        }
        if (arrayType instanceof Class && Collection.class.isAssignableFrom((Class<?>)arrayType)) {
            arrayType = Object.class;
        }
        if (GenericTypeUtil.isArray((Type)arrayType)) {
            JavaType javaType = JavaType.getJavaTypeByType((Type)arrayType);
            HashMap<String, ParamBean> arrayParam = new HashMap<String, ParamBean>();
            ParamBean bean = new ParamBean();
            arrayParam.put(nullKey, bean);
            bean.setType(javaType.getType());
            bean.setRequired(1);
            bean.setShow(1);
            List<Object> children = GenericTypeUtil.isBaseArray((Type)arrayType) ? this.readArray((Type)arrayType, binds) : this.readArrayObject((Type)arrayType, binds);
            bean.setChildren(children);
            childrenArray.add(arrayParam);
            return childrenArray;
        }
        Map<String, ParamBean> map = this.readBean((Type)arrayType, binds);
        if (map.size() > 0) {
            childrenArray.add(map);
        }
        return childrenArray;
    }

    private Map<String, ParamBean> getBean(Class beanClass, GenericTypeBind binds) {
        HashMap<String, ParamBean> result = new HashMap<String, ParamBean>();
        HashSet<String> fieldNames = new HashSet<String>();
        for (Class clazz = beanClass; clazz != null && !clazz.equals(Object.class) && clazz != Class.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            String path = clazz.getCanonicalName().replace(".", File.separator) + ".java";
            JavaSourceReader classFileReader = JavaSourceReader.builder(new File(this.projectBasePath + path));
            List<FieldComment> fieldComments = classFileReader.getComment().getFields();
            Map<String, FieldComment> fieldComment = fieldComments.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
            for (Field field : fields = clazz.getDeclaredFields()) {
                String comments;
                Type bindType;
                this.filter.getInfo().setField(field).setComment(fieldComment.get(field.getName()));
                if (this.filter.ignore(clazz, binds, field)) continue;
                int size = fieldNames.size();
                fieldNames.add(field.getName());
                if (size == fieldNames.size()) continue;
                Class ownerClass = field.getType();
                GenericTypeBind currentBinds = binds;
                Object type = field.getGenericType();
                if (GenericTypeUtil.isGeneric((Type)(type = this.filter.parseType(ownerClass, binds, (Type)type))) && !GenericTypeUtil.isArray((Type)type) && (bindType = binds.matchVariable(type.getTypeName())) != null) {
                    type = bindType;
                    ownerClass = GenericTypeUtil.getOwnerClass((Type)type);
                }
                if (StringUtil.isEmpty(comments = this.filter.comments(clazz, binds, field))) {
                    String string = comments = fieldComment.get(field.getName()) == null ? null : fieldComment.get(field.getName()).getComment();
                    if (StringUtil.isEmpty(comments)) {
                        comments = field.getName();
                    }
                }
                if (ownerClass.equals(Object.class)) {
                    type = Map.class;
                }
                String mock = this.filter.mockTemplate(clazz, currentBinds, field);
                boolean hidden = this.filter.hidden(clazz, binds, field);
                boolean required = this.filter.required(clazz, binds, field);
                ParamBean requestBean = new ParamBean();
                requestBean.setRequired(required ? 1 : 0);
                requestBean.setMockValue(StringUtil.isEmpty(mock) ? "" : this.filter.parseMock(mock));
                requestBean.setOldMockValue(mock);
                requestBean.setShow(hidden ? 0 : 1);
                requestBean.setRemark(comments);
                requestBean.setName(field.getName());
                requestBean.setJava_name(type.getTypeName());
                JavaType javaType = this.filter.type(ownerClass, binds, (Type)type);
                requestBean.setType(javaType.getType());
                switch (JavaType.getType(requestBean.getType())) {
                    case Object: {
                        requestBean.setChildren(this.readBean((Type)type, currentBinds));
                        break;
                    }
                    case ArrayObject: {
                        requestBean.setChildren(this.readArrayObject((Type)type, currentBinds));
                        break;
                    }
                    case Array: {
                        requestBean.setChildren(this.readArray((Type)type, currentBinds));
                    }
                }
                result.put(requestBean.getName(), requestBean);
            }
        }
        return result;
    }
}

