/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.filter.ReadInterfaceApiFilter;
import cn.easyutil.easyapi.filter.model.DefaultReadInterfaceApi;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.reflect.Method;

public class InterfaceCreator {
    private Method method;
    private DBModuleInterfaceEntity interfaceBean;
    private ReadInterfaceApiFilter filter = new DefaultReadInterfaceApi();
    private MethodComment comment;

    private InterfaceCreator() {
    }

    public static InterfaceCreator builder(Method method) {
        InterfaceCreator creator = new InterfaceCreator();
        creator.method = method;
        return creator;
    }

    public InterfaceCreator setFilter(ReadInterfaceApiFilter filter) {
        if (filter == null) {
            return this;
        }
        this.filter = filter;
        return this;
    }

    public InterfaceCreator setAlias(MethodComment comment) {
        if (StringUtil.isEmpty(comment)) {
            return this;
        }
        this.comment = comment;
        return this;
    }

    public DBModuleInterfaceEntity buildInterface() {
        if (this.interfaceBean != null) {
            return this.interfaceBean;
        }
        try {
            this.create();
        }
        catch (Exception e) {
            System.out.println("\u521b\u5efa\u63a5\u53e3:" + this.method.toGenericString() + "\u5931\u8d25,\u539f\u56e0:" + e.getMessage());
            e.printStackTrace();
        }
        return this.interfaceBean;
    }

    private void create() {
        this.interfaceBean = new DBModuleInterfaceEntity();
        this.interfaceBean.setTitle(this.filter.title(this.method));
        if (StringUtil.isEmpty(this.interfaceBean.getTitle())) {
            this.interfaceBean.setTitle(this.comment.getName());
        }
        this.interfaceBean.setControllerClass(this.method.getDeclaringClass().getCanonicalName());
        this.interfaceBean.setMethodName(this.method.getName());
        this.interfaceBean.setDescription(this.filter.comments(this.method));
        this.interfaceBean.setRequestMethod(this.filter.requestMethod(this.method));
        this.interfaceBean.setBodyType(this.filter.bodyType(this.method).getType());
        this.interfaceBean.setRequestUrl(this.filter.requestPath(this.method));
        this.interfaceBean.setPinyin(StringUtil.toPinYin(this.interfaceBean.getTitle()));
        this.interfaceBean.setSource(this.comment.getSource());
        this.interfaceBean.setSearchTags(DBModuleInterfaceEntity.buildSearchTag(this.interfaceBean));
    }
}

