/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.filter.ReadControllerApiFilter;
import cn.easyutil.easyapi.filter.model.DefaultReadControllerApi;
import cn.easyutil.easyapi.javadoc.reader.ClassComment;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

public class ControllerCreator {
    private Class clazz;
    private DBModuleControllerEntity controllerBean;
    private ReadControllerApiFilter filter = new DefaultReadControllerApi();
    private ClassComment comment;

    private ControllerCreator() {
    }

    public static ControllerCreator builder(Class clazz) {
        ControllerCreator creator = new ControllerCreator();
        creator.clazz = clazz;
        return creator;
    }

    public ControllerCreator setFilter(ReadControllerApiFilter filter) {
        if (filter == null) {
            return this;
        }
        this.filter = filter;
        return this;
    }

    public ControllerCreator setSource(ClassComment comment) {
        if (StringUtil.isEmpty(comment)) {
            return this;
        }
        this.comment = comment;
        return this;
    }

    public DBModuleControllerEntity buildController() {
        if (this.controllerBean != null) {
            return this.controllerBean;
        }
        try {
            this.create();
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efacontroller:" + this.clazz.getCanonicalName() + "\u5931\u8d25,\u539f\u56e0:" + e.getMessage());
        }
        return this.controllerBean;
    }

    private void create() {
        this.controllerBean = new DBModuleControllerEntity();
        this.controllerBean.setShowName(this.filter.title(this.clazz));
        if (StringUtil.isEmpty(this.controllerBean.getShowName())) {
            this.controllerBean.setShowName(this.comment.getComment());
        }
        if (StringUtil.isEmpty(this.controllerBean.getShowName())) {
            this.controllerBean.setShowName(this.clazz.getSimpleName());
        }
        this.controllerBean.setApiPath(this.readControllerApiPath(this.clazz));
        this.controllerBean.setClassName(this.clazz.getCanonicalName());
        this.controllerBean.setPinyin(StringUtil.toPinYin(this.controllerBean.getShowName()));
        this.controllerBean.setSource(this.comment.getSource());
        this.controllerBean.setSearchTags(DBModuleControllerEntity.buildSearchTag(this.controllerBean));
    }

    private String readControllerApiPath(Class clazz) {
        Map<String, RequestMapping> classAnnotation = ObjectUtil.getClassAnnotation(clazz, RequestMapping.class);
        String path = "null-";
        if (!StringUtil.isEmpty(classAnnotation)) {
            return this.apiPathParseToFilePath(classAnnotation.entrySet().iterator().next().getValue().value()[0]);
        }
        Map<String, GetMapping> ga = ObjectUtil.getClassAnnotation(clazz, GetMapping.class);
        if (!StringUtil.isEmpty(ga)) {
            return this.apiPathParseToFilePath(ga.entrySet().iterator().next().getValue().value()[0]);
        }
        Map<String, PostMapping> pa = ObjectUtil.getClassAnnotation(clazz, PostMapping.class);
        if (!StringUtil.isEmpty(pa)) {
            return this.apiPathParseToFilePath(pa.entrySet().iterator().next().getValue().value()[0]);
        }
        return path;
    }

    private String apiPathParseToFilePath(String path) {
        if (StringUtil.isEmpty(path)) {
            return path;
        }
        if (!(path = path.replace("/", "-")).endsWith("-")) {
            return path + "-";
        }
        return path;
    }
}

