/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic;

import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiSyncRemoteConfiguration;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.datasource.EasyapiBindSqlExecution;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.auth.AuthMoudle;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleAuthEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleEntity;
import cn.easyutil.easyapi.entity.db.auth.DBRoleProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHostEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.doc.MockBean;
import cn.easyutil.easyapi.entity.doc.ParamBean;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.filter.ApiBaseInfo;
import cn.easyutil.easyapi.interview.controller.ComplexApidocController;
import cn.easyutil.easyapi.interview.dto.ReciveSourceDto;
import cn.easyutil.easyapi.interview.dto.SyncRemoteAllDto;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceReader;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.javadoc.reader.SourceParameterComment;
import cn.easyutil.easyapi.logic.MockExecuter;
import cn.easyutil.easyapi.logic.creator.ControllerCreator;
import cn.easyutil.easyapi.logic.creator.InterfaceCreator;
import cn.easyutil.easyapi.logic.creator.NewParamsBeanCreator;
import cn.easyutil.easyapi.logic.creator.RequestParamCreator;
import cn.easyutil.easyapi.logic.creator.ResponseParamCreator;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import cn.easyutil.easyapi.util.http.HttpRes;
import java.io.File;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;

public class Starter {
    private AllConfiguration all;
    private ApplicationContext appContext;
    private EasyapiBindSqlExecution execution;

    public Starter(AllConfiguration all, ApplicationContext appContext, EasyapiBindSqlExecution execution) {
        this.all = all;
        this.appContext = appContext;
        this.execution = execution;
    }

    public void aotoSync() {
        ComplexApidocController controller = (ComplexApidocController)this.appContext.getBean(ComplexApidocController.class);
        SyncRemoteAllDto dto = new SyncRemoteAllDto();
        dto.setOverwriteType(this.all.getSyncRemoteConfiguration().getOverwriteType().type);
        dto.setTargetHost(this.all.getSyncRemoteConfiguration().getHost());
        dto.setTargetUsername(this.all.getSyncRemoteConfiguration().getAccount());
        dto.setTargetPassword(this.all.getSyncRemoteConfiguration().getPassword());
        dto.setTargetProjectName(this.all.getSyncRemoteConfiguration().getProjectName());
        dto.setTargetModuleName(this.all.getSyncRemoteConfiguration().getModuleName());
        dto.setLocalProjectName(ProjectContext.currentProjectName);
        dto.setLocalModuleName(ProjectContext.currentModuleName);
        if (this.all.getSyncRemoteConfiguration().getSyncType() == EasyapiSyncRemoteConfiguration.SyncType.push) {
            controller.syncRemoteAll(dto);
        } else {
            HttpRes httpRes = controller.doEasyapiUrl(dto.getTargetHost() + "/easyapi/doc/complex/syncPull", JsonUtil.beanToJson(dto));
            String message = controller.getDoEasyapiUrlResult(httpRes);
            ReciveSourceDto reciveSourceDto = JsonUtil.jsonToBean(message, ReciveSourceDto.class);
            controller.saveSyncSource(dto.getLocalProjectName(), dto.getLocalModuleName(), reciveSourceDto.getSources(), dto.getOverwriteType());
        }
    }

    private void initProject() {
        DBProjectEntity project = new DBProjectEntity();
        project.setDefaultStatus(1);
        project = this.execution.selectOne(project);
        DBModuleEntity module = (DBModuleEntity)this.execution.selectOne(EasyapiBindSQLExecuter.build(new DBModuleEntity()).eq(DBModuleEntity::getDefaultStatus, (Object)1, new Boolean[0]));
        if (project == null) {
            project = this.addDefaultProject();
        }
        if (module == null) {
            module = this.addDefaultModule(project);
            this.addDefaultUsers(module);
        }
        ProjectContext.currentProjectId = project.getId();
        ProjectContext.currentModuleId = module.getId();
        ProjectContext.currentProjectName = project.getName();
        ProjectContext.currentModuleName = module.getName();
    }

    private void initFilter() {
        if (ProjectContext.readBeanApiFilter == null) {
            ProjectContext.readBeanApiFilter = this.newInstance(this.all.getFilterConfiguration().getReadBeanApiFilter());
        }
        if (ProjectContext.readControllerApiFilter == null) {
            ProjectContext.readControllerApiFilter = this.newInstance(this.all.getFilterConfiguration().getReadControllerApiFilter());
        }
        if (ProjectContext.readInterfaceApiFilter == null) {
            ProjectContext.readInterfaceApiFilter = this.newInstance(this.all.getFilterConfiguration().getReadInterfaceApiFilter());
        }
        if (ProjectContext.readRequestParamApiFilter == null) {
            ProjectContext.readRequestParamApiFilter = this.newInstance(this.all.getFilterConfiguration().getReadRequestParamApiFilter());
        }
        if (ProjectContext.readResponseParamApiFilter == null) {
            ProjectContext.readResponseParamApiFilter = this.newInstance(this.all.getFilterConfiguration().getReadResponseParamApiFilter());
        }
    }

    private <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ApidocException(e);
        }
    }

    public void start() {
        this.showLogo();
        this.initFilter();
        this.initProject();
        if (this.all.getConfiguration().isRescan()) {
            this.doCreateApi();
        }
        if (this.all.getSyncRemoteConfiguration().isEnable()) {
            this.aotoSync();
        }
        System.out.println("*********************************************");
        System.out.println("**********   \u63a5\u53e3\u6587\u6863\u5df2\u751f\u6210 url=/apidoc.html  ***************");
        System.out.println("*********************************************");
    }

    private void showLogo() {
        String text = "                                        _\n                                       (_)\n  ___  __ _ ___ _   _ ______ __ _ _ __  _\n / _ \\/ _` / __| | | |______/ _` | '_ \\| |\n|  __/ (_| \\__ \\ |_| |     | (_| | |_) | |\n \\___|\\__,_|___/\\__, |      \\__,_| .__/|_|\n                 __/ |           | |\n                |___/            |_|\n    -------------------------------\u63a5\u53e3\u6587\u6863\n    ---http://localhost:\u9879\u76ee\u7aef\u53e3/apidoc.html";
        System.out.println(text);
    }

    private DBModuleEntity addDefaultModule(DBProjectEntity project) {
        DBModuleEntity module = new DBModuleEntity();
        module.setProjectId(project.getId());
        module.setName("\u9ed8\u8ba4\u6a21\u5757");
        module.setDescription("\u521d\u59cb\u5316\u9879\u76ee\u6a21\u5757");
        module.setOutPackgeStatus(0);
        module.setDefaultStatus(1);
        this.execution.insert(module);
        DBModuleHostEntity mock = new DBModuleHostEntity();
        mock.setModuleId(module.getId());
        mock.setProjectId(project.getId());
        mock.setName("mock");
        mock.setDescription("mock\u8bf7\u6c42,\u8fd4\u56demock\u7ed3\u679c");
        mock.setDefaultStatus(1);
        mock.setDisable(0);
        String port = this.appContext.getEnvironment().getProperty("server.port");
        port = port == null ? "8080" : port;
        mock.setHost("http://localhost:" + port + "/easyapi/doc/mock?path=");
        this.execution.insert(mock);
        DBModuleHostEntity local = new DBModuleHostEntity();
        local.setProjectId(project.getId());
        local.setModuleId(module.getId());
        local.setName("\u672c\u5730\u73af\u5883");
        local.setDescription("\u672c\u673a\u73af\u5883");
        local.setDefaultStatus(0);
        local.setDisable(0);
        String address = "localhost";
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        local.setHost("http://" + address + ":" + port);
        this.execution.insert(local);
        return module;
    }

    private DBProjectEntity addDefaultProject() {
        DBProjectEntity project = new DBProjectEntity();
        project.setDefaultStatus(1);
        project.setTitle(this.all.getConfiguration().getProjectName());
        project.setName(this.all.getConfiguration().getProjectName());
        project.setDescription(ProjectContext.javaMockRemark());
        this.execution.insert(project);
        return project;
    }

    private void addDefaultUsers(DBModuleEntity module) {
        DBUserEntity user = new DBUserEntity();
        user.setAccount(this.all.getUserConfiguration().getAccount());
        user.setPassword(StringUtil.toMD5(this.all.getUserConfiguration().getPassword()));
        user.setDisable(0);
        user.setDescription("\u8d85\u7ea7\u7ba1\u7406\u5458");
        user.setNickName("\u8d85\u7ea7\u7ba1\u7406\u5458");
        user.setSuperAdminStatus(1);
        user.setRoleId(0L);
        user.setProjectId(module.getProjectId());
        user.setCreateTime(System.currentTimeMillis());
        user.setUpdateTime(System.currentTimeMillis());
        this.execution.insert(user);
        DBUserEntity hiddenUser = new DBUserEntity();
        hiddenUser.setAccount("remote");
        hiddenUser.setPassword(StringUtil.toMD5("remote"));
        hiddenUser.setSuperAdminStatus(1);
        hiddenUser.setRoleId(0L);
        hiddenUser.setProjectId(module.getProjectId());
        hiddenUser.setCreateTime(System.currentTimeMillis());
        hiddenUser.setUpdateTime(System.currentTimeMillis());
        this.execution.insert(hiddenUser);
        DBRoleEntity testRole = new DBRoleEntity();
        testRole.setRoleName("\u6d4b\u8bd5\u4eba\u5458");
        testRole.setDescription("\u4ec5\u63d0\u4f9b\u6d4b\u8bd5\u76f8\u5173\u7684\u6743\u9650");
        testRole.setSuperAdminStatus(0);
        testRole.setProjectId(module.getProjectId());
        testRole.setCreateTime(System.currentTimeMillis());
        testRole.setUpdateTime(System.currentTimeMillis());
        this.execution.insert(testRole);
        DBRoleProjectEntity roleProject = new DBRoleProjectEntity();
        roleProject.setRoleId(testRole.getId());
        roleProject.setProjectId(module.getProjectId());
        roleProject.setCreateTime(System.currentTimeMillis());
        roleProject.setUpdateTime(System.currentTimeMillis());
        this.execution.insert(roleProject);
        List<Integer> defaultAuthCodes = AuthMoudle.getDefaultAuthCodes();
        ArrayList<DBRoleAuthEntity> auths = new ArrayList<DBRoleAuthEntity>();
        for (Integer code : defaultAuthCodes) {
            DBRoleAuthEntity entity = new DBRoleAuthEntity();
            entity.setRoleId(testRole.getId());
            entity.setAuthCode(code);
            entity.setModuleId(module.getId());
            entity.setProjectId(module.getProjectId());
            entity.setCreateTime(System.currentTimeMillis());
            entity.setUpdateTime(System.currentTimeMillis());
            auths.add(entity);
        }
        this.execution.insert(auths);
        DBUserEntity test = new DBUserEntity();
        test.setAccount("test");
        test.setPassword(StringUtil.toMD5("test"));
        test.setSuperAdminStatus(0);
        test.setProjectId(module.getProjectId());
        test.setRoleId(testRole.getId());
        test.setNickName("\u6d4b\u8bd5\u8d26\u53f7");
        test.setDescription("\u6d4b\u8bd5\u4eba\u5458\u8d26\u53f7");
        test.setDisable(0);
        this.execution.insert(test);
    }

    private void doCreateApi() {
        Set<Class> set = ProjectContext.readControllerApiFilter.readControllers(this.appContext);
        if (set == null || set.isEmpty()) {
            return;
        }
        NewParamsBeanCreator creator = NewParamsBeanCreator.builder(ProjectContext.readBeanApiFilter, ProjectContext.projectBasePath);
        for (Class aClass : set) {
            String canonicalName = aClass.getCanonicalName();
            if (!StringUtil.isEmpty(this.all.getConfiguration().getScanPackage()) && !canonicalName.startsWith(this.all.getConfiguration().getScanPackage()) || ProjectContext.readControllerApiFilter.ignore(aClass)) continue;
            String controllerPath = ProjectContext.projectBasePath + File.separator + aClass.getCanonicalName().replace(".", File.separator) + ".java";
            JavaSourceReader controllerSourceReader = JavaSourceReader.builder(new File(controllerPath));
            ProjectContext.readControllerApiFilter.buildInfo(new ApiBaseInfo().setController(aClass).setComment(controllerSourceReader.getComment()));
            DBModuleControllerEntity controllerBean = ControllerCreator.builder(aClass).setFilter(ProjectContext.readControllerApiFilter).setSource(controllerSourceReader.getComment()).buildController();
            controllerBean.setProjectId(ProjectContext.currentProjectId);
            controllerBean.setModuleId(ProjectContext.currentModuleId);
            DBModuleControllerEntity queryController = (DBModuleControllerEntity)this.execution.selectOne(EasyapiBindSQLExecuter.build(new DBModuleControllerEntity()).eq(BaseDbEntity::getProjectId, (Object)controllerBean.getProjectId(), new Boolean[0]).eq(DBModuleControllerEntity::getModuleId, (Object)controllerBean.getModuleId(), new Boolean[0]).eq(DBModuleControllerEntity::getClassName, (Object)controllerBean.getClassName(), new Boolean[0]));
            if (queryController == null) {
                controllerBean.setCreateTime(System.currentTimeMillis());
                controllerBean.setUpdateTime(System.currentTimeMillis());
                this.execution.insert(controllerBean);
                queryController = controllerBean;
            }
            DBModuleInterfaceEntity queryInterface = new DBModuleInterfaceEntity();
            queryInterface.setProjectId(ProjectContext.currentProjectId);
            queryInterface.setModuleId(ProjectContext.currentModuleId);
            queryInterface.setControllerId(queryController.getId());
            List<DBModuleInterfaceEntity> apiInterfaceBeans = this.execution.select(queryInterface);
            if (apiInterfaceBeans == null) {
                apiInterfaceBeans = new ArrayList<DBModuleInterfaceEntity>();
            }
            Set allExistInterface = apiInterfaceBeans.stream().map(item -> item.getUnique()).collect(Collectors.toSet());
            List<Method> methods = this.getApiInterfaceMethod(aClass);
            List<MethodComment> methodComment = controllerSourceReader.getComment().getMethods();
            HashMap readMethodParamComment = new HashMap();
            for (MethodComment comment : methodComment) {
                List<SourceParameterComment> parameters = comment.getParameters();
                HashMap<String, String> map = new HashMap<String, String>();
                for (SourceParameterComment parameter : parameters) {
                    map.put(parameter.getName(), parameter.getComment());
                }
                readMethodParamComment.put(comment.getName(), map);
            }
            for (Method method : methods) {
                if (ProjectContext.readInterfaceApiFilter.ignore(method) || allExistInterface.contains(StringUtil.toMD5(method.toGenericString()))) continue;
                MethodComment methodSourceComment = controllerSourceReader.getComment().getMethod(method.getName());
                ProjectContext.readInterfaceApiFilter.buildInfo(new ApiBaseInfo().setController(aClass).setMethod(method).setComment(methodSourceComment));
                Optional<MethodComment> findMethodAlias = methodComment.stream().filter(a -> a.getName().equals(method.getName())).findFirst();
                DBModuleInterfaceEntity interfaceBean = InterfaceCreator.builder(method).setFilter(ProjectContext.readInterfaceApiFilter).setAlias(findMethodAlias.isPresent() ? findMethodAlias.get() : new MethodComment()).buildInterface();
                interfaceBean.setRequestUrl(ProjectContext.readControllerApiFilter.requestPath(aClass) + interfaceBean.getRequestUrl());
                interfaceBean.setProjectId(ProjectContext.currentProjectId);
                interfaceBean.setModuleId(ProjectContext.currentModuleId);
                interfaceBean.setControllerId(queryController.getId());
                interfaceBean.setMethodName(queryController.getClassName() + "." + method.getName());
                interfaceBean.setUnique(StringUtil.toMD5(method.toGenericString()));
                interfaceBean.setCreateTime(System.currentTimeMillis());
                interfaceBean.setUpdateTime(System.currentTimeMillis());
                this.execution.insert(interfaceBean);
                apiInterfaceBeans.add(interfaceBean);
                Map<String, ParamBean> requestParam = RequestParamCreator.builder(method, creator).setBeanFilter(ProjectContext.readBeanApiFilter).setInterfaceFilter(ProjectContext.readInterfaceApiFilter).setRequestParamFilter(ProjectContext.readRequestParamApiFilter).buildSourceComment(methodSourceComment.getParameters()).buildParamBean();
                String requestParams = JsonUtil.beanToJson(requestParam);
                DBInterfaceParamEntity reqPram = new DBInterfaceParamEntity();
                reqPram.setProjectId(ProjectContext.currentProjectId);
                reqPram.setProjectId(ProjectContext.currentProjectId);
                reqPram.setInterfaceId(interfaceBean.getId());
                reqPram.setRequestParamJson(requestParams);
                reqPram.setCreateTime(System.currentTimeMillis());
                reqPram.setUpdateTime(System.currentTimeMillis());
                Map<String, ParamBean> responseParam = ResponseParamCreator.builder(method, creator).setFilter(ProjectContext.readResponseParamApiFilter).buildParamBean();
                String res = JsonUtil.beanToJson(responseParam);
                reqPram.setResponseParamJson(res);
                if (responseParam == null || responseParam.size() == 0) {
                    this.execution.insert(reqPram);
                    continue;
                }
                try {
                    String mock = this.buildMock(res);
                    reqPram.setResponseMock(mock);
                    this.execution.insert(reqPram);
                    MockBean mockBean = new MockBean();
                    mockBean.setProjectId(ProjectContext.currentProjectId);
                    mockBean.setInterfaceId(interfaceBean.getId());
                    mockBean.setMock(mock);
                }
                catch (Exception e) {
                    if (reqPram.getId() == null) {
                        this.execution.insert(reqPram);
                    }
                    e.printStackTrace();
                    System.out.println("response mock error:" + interfaceBean.getControllerClass() + "." + interfaceBean.getMethodName());
                }
            }
        }
    }

    private List<Method> getApiInterfaceMethod(Class aClass) {
        return ProjectContext.readInterfaceApiFilter.readAllInterfaces(aClass);
    }

    private String buildMock(String responseParam) {
        MockExecuter executer = new MockExecuter(ProjectContext.readBeanApiFilter);
        executer.setMockHidden(ProjectContext.readResponseParamApiFilter.isMockHiddenParam(true));
        executer.setMockShow(ProjectContext.readResponseParamApiFilter.isMockHiddenParam(false));
        executer.setMockRequired(ProjectContext.readResponseParamApiFilter.isMockRequiredParam(true));
        executer.setMockUnRequired(ProjectContext.readResponseParamApiFilter.isMockRequiredParam(false));
        Object mockValue = executer.mockByApiBean(responseParam);
        return JsonUtil.beanToJson(mockValue);
    }
}

