/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic;

import cn.easyutil.easyapi.configuration.AllConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiConfiguration;
import cn.easyutil.easyapi.configuration.EasyapiDataConfiguration;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.content.TableDDL;
import cn.easyutil.easyapi.datasource.EasyapiBindSqlExecution;
import cn.easyutil.easyapi.logic.Starter;
import cn.easyutil.easyapi.util.StringUtil;
import com.alibaba.druid.pool.DruidDataSource;
import java.io.File;
import java.io.IOException;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContext;

public class EasyapiRun {
    public static void run(AllConfiguration all, ApplicationContext applicationContext) {
        EasyapiRun.run(applicationContext, all);
    }

    public static void run(ApplicationContext appContext, AllConfiguration all) {
        EasyapiConfiguration configuration = all.getConfiguration();
        EasyapiDataConfiguration dataConfiguration = all.getDataConfiguration();
        if (!configuration.isEnable()) {
            return;
        }
        if (StringUtil.isEmpty(configuration.getProjectSourcePath())) {
            try {
                configuration.setProjectSourcePath(new File("").getCanonicalPath());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        ProjectContext.allConfiguration = all;
        ProjectContext.init(configuration);
        if (ProjectContext.execution == null) {
            ProjectContext.execution = new EasyapiBindSqlExecution();
        }
        if (StringUtil.isEmpty(dataConfiguration.getDriverClassName())) {
            dataConfiguration.setDriverClassName("org.h2.Driver");
        }
        if (StringUtil.isEmpty(dataConfiguration.getUrl())) {
            dataConfiguration.setUrl("jdbc:h2:file:" + ProjectContext.dbPath + ProjectContext.dbFileName + "-" + configuration.getProjectName());
        }
        if (StringUtil.isEmpty(dataConfiguration.getUserName())) {
            dataConfiguration.setUserName("easyapi");
        }
        if (StringUtil.isEmpty(dataConfiguration.getPassword())) {
            dataConfiguration.setPassword("123456");
        }
        if (dataConfiguration.getDataSource() != null) {
            ProjectContext.execution.setDataSource(dataConfiguration.getDataSource());
        } else {
            DataSource dataSource = EasyapiRun.dataSource(dataConfiguration.getUrl(), dataConfiguration.getDriverClassName(), dataConfiguration.getUserName(), dataConfiguration.getPassword());
            ProjectContext.execution.setDataSource(dataSource);
        }
        if (configuration.isDropOldData()) {
            for (String s : TableDDL.dropAll) {
                ProjectContext.execution.update(s);
            }
        }
        for (String s : TableDDL.all) {
            ProjectContext.execution.update(s);
        }
        if (configuration.isDelOldApi()) {
            for (String s : TableDDL.dropDoc) {
                ProjectContext.execution.update(s);
            }
        }
        Starter starter = new Starter(all, appContext, ProjectContext.execution);
        starter.start();
    }

    private static DataSource dataSource(String url, String driverClassName, String username, String password) {
        DruidDataSource druidDataSource = new DruidDataSource();
        druidDataSource.setUrl(url);
        druidDataSource.setUsername(username);
        druidDataSource.setPassword(password);
        druidDataSource.setDriverClassName(driverClassName);
        druidDataSource.setInitialSize(0);
        druidDataSource.setMaxActive(100);
        druidDataSource.setMaxWait(10000L);
        druidDataSource.setMinIdle(20);
        druidDataSource.setValidationQuery("Select  'x' from DUAL");
        druidDataSource.setTestOnBorrow(false);
        druidDataSource.setTestOnReturn(false);
        druidDataSource.setTestWhileIdle(true);
        druidDataSource.setTimeBetweenEvictionRunsMillis(60000L);
        druidDataSource.setMinEvictableIdleTimeMillis(25200000L);
        druidDataSource.setRemoveAbandoned(true);
        druidDataSource.setRemoveAbandonedTimeout(1800);
        druidDataSource.setLogAbandoned(true);
        return druidDataSource;
    }
}

