/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.javadoc.html;

import cn.easyutil.easyapi.datasource.EasyapiBindSqlExecution;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.BaseBean;
import cn.easyutil.easyapi.entity.doc.ControllerBean;
import cn.easyutil.easyapi.entity.doc.InterfaceBean;
import cn.easyutil.easyapi.entity.doc.InterfaceParamBean;
import cn.easyutil.easyapi.entity.doc.MockBean;
import cn.easyutil.easyapi.entity.doc.ProjectBean;
import cn.easyutil.easyapi.util.JsonUtil;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CreateHtml {
    private StringBuffer html = new StringBuffer();
    private StringBuffer js = new StringBuffer();
    private EasyapiBindSqlExecution sqlExecution;

    public CreateHtml(EasyapiBindSqlExecution sqlExecution) {
        this.sqlExecution = sqlExecution;
    }

    public void createHtml() {
    }

    public CreateHtml createJs(Long projectId) {
        EasyapiBindSQLExecuter build = EasyapiBindSQLExecuter.build(new ProjectBean());
        if (projectId != null) {
            build.eq(BaseBean::getId, (Object)projectId, new Boolean[0]);
        } else {
            build.eq(ProjectBean::getInitProject, (Object)1, new Boolean[0]);
        }
        ProjectBean infoBean = (ProjectBean)this.sqlExecution.selectOne(build);
        if (infoBean == null) {
            return null;
        }
        projectId = infoBean.getId();
        List controllerBeans = this.sqlExecution.select(EasyapiBindSQLExecuter.build(new ControllerBean()).eq(ControllerBean::getProject_id, (Object)projectId, new Boolean[0]));
        List interfaces = this.sqlExecution.select(EasyapiBindSQLExecuter.build(new InterfaceBean()).eq(InterfaceBean::getProject_id, (Object)projectId, new Boolean[0]));
        List requests = this.sqlExecution.select(EasyapiBindSQLExecuter.build(new InterfaceParamBean()).eq(InterfaceParamBean::getProjectId, (Object)projectId, new Boolean[0]).eq(InterfaceParamBean::getType, (Object)0, new Boolean[0]));
        List responses = this.sqlExecution.select(EasyapiBindSQLExecuter.build(new InterfaceParamBean()).eq(InterfaceParamBean::getProjectId, (Object)projectId, new Boolean[0]).eq(InterfaceParamBean::getType, (Object)1, new Boolean[0]));
        List mocks = this.sqlExecution.select(EasyapiBindSQLExecuter.build(new MockBean()).eq(MockBean::getProjectId, (Object)projectId, new Boolean[0]));
        this.js.append("function getInfo(){");
        this.js.append("return " + JsonUtil.beanToJson(infoBean) + ";");
        this.js.append("}");
        this.js.append(this.newLine());
        this.js.append("function getControllers(){");
        this.js.append("return " + JsonUtil.beanToJson(controllerBeans) + ";");
        this.js.append("}");
        this.js.append(this.newLine());
        this.js.append("function getInterfaces(controllerId){");
        this.js.append("switch(controllerId){");
        Map<Long, List<InterfaceBean>> interfaceMap = interfaces.stream().collect(Collectors.groupingBy(InterfaceBean::getController_id));
        interfaceMap.keySet().forEach(im -> {
            this.js.append("case " + im + ": ");
            this.js.append("return " + JsonUtil.beanToJson(interfaceMap.get(im)) + ";");
        });
        this.js.append("}");
        this.js.append("}");
        this.js.append(this.newLine());
        this.js.append("function getRequests(interfaceId){");
        this.js.append("switch(interfaceId){");
        Map<Long, List<InterfaceParamBean>> reqMap = requests.stream().collect(Collectors.groupingBy(InterfaceParamBean::getInterfaceId));
        reqMap.keySet().forEach(reqm -> {
            this.js.append("case " + reqm + ": ");
            this.js.append("return " + JsonUtil.beanToJson(reqMap.get(reqm)) + ";");
        });
        this.js.append("}");
        this.js.append("}");
        this.js.append(this.newLine());
        this.js.append("function getResponses(interfaceId){");
        this.js.append("switch(interfaceId){");
        Map<Long, List<InterfaceParamBean>> resMap = responses.stream().collect(Collectors.groupingBy(InterfaceParamBean::getInterfaceId));
        reqMap.keySet().forEach(resm -> {
            this.js.append("case " + resm + ": ");
            this.js.append("return " + JsonUtil.beanToJson(resMap.get(resMap)) + ";");
        });
        this.js.append("}");
        this.js.append("}");
        this.js.append(this.newLine());
        this.js.append("function getMocks(interfaceId){");
        this.js.append("switch(interfaceId){");
        Map<Long, List<MockBean>> mockMap = mocks.stream().collect(Collectors.groupingBy(MockBean::getInterfaceId));
        mockMap.keySet().forEach(mm -> {
            this.js.append("case " + mm + ": ");
            this.js.append("return " + JsonUtil.beanToJson(mockMap.get(mm)) + ";");
        });
        this.js.append("}");
        this.js.append("}");
        this.js.append(this.newLine());
        return this;
    }

    public String getJs() {
        return this.js.toString();
    }

    private String newLine() {
        return "\r\n";
    }
}

