/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.session;

import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.interview.session.SessionUser;
import cn.easyutil.easyapi.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class CurrentSession {
    private static final String session_user = "session_user";
    public static final String projectId = "projectId";
    public static final String moduleId = "moduleId";

    private static HttpSession getHttpSession() {
        return CurrentSession.getRequest().getSession();
    }

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return servletRequestAttributes.getResponse();
    }

    public static void loginSuccess(SessionUser user) {
        CurrentSession.getHttpSession().setAttribute(session_user, (Object)user);
    }

    public static SessionUser getCurrentUser() {
        Object attribute = CurrentSession.getHttpSession().getAttribute(session_user);
        if (attribute == null) {
            throw new ApidocException("\u7528\u6237\u672a\u767b\u9646", 304);
        }
        return (SessionUser)attribute;
    }

    public static Long getCurrentProjectId() {
        Object header = CurrentSession.getRequest().getSession().getAttribute(projectId);
        if (StringUtil.isEmpty(header)) {
            return null;
        }
        return Long.parseLong(header.toString());
    }

    public static Long getCurrentModuleId() {
        Object header = CurrentSession.getRequest().getSession().getAttribute(moduleId);
        if (StringUtil.isEmpty(header)) {
            return null;
        }
        return Long.parseLong(header.toString());
    }
}

