/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.datasource.bean.EasyApiBindSqlResult;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestGroupEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestInfoEntity;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.dto.SelectGroupsDto;
import cn.easyutil.easyapi.service.TestGroupService;
import cn.easyutil.easyapi.service.TestInfoService;
import cn.easyutil.easyapi.service.TestService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.StringUtil;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnMissingBean(name={"easyapiUnitController"})
@RequestMapping(value={"/easyapi/doc/unit"})
public class UnitController {
    @Resource(name="easyapiTestGroupService")
    private TestGroupService groupService;
    @Resource(name="easyapiTestService")
    private TestService testService;
    @Resource(name="easyapiTestInfoService")
    private TestInfoService testInfoService;

    @ApidocComment(value="\u6761\u4ef6\u67e5\u8be2\u63a5\u53e3\u6d4b\u8bd5\u5206\u7ec4\u5217\u8868")
    @PostMapping(value={"/selectGroups"})
    @AccessAuth(code=1000)
    public EasyApiBindSqlResult<DBComplexTestGroupEntity> selectGroups(@RequestBody SelectGroupsDto dto) {
        DBComplexTestGroupEntity query = new DBComplexTestGroupEntity();
        BeanUtils.copyProperties((Object)dto, (Object)query);
        query.setName(null);
        EasyApiBindSqlResult page = this.groupService.page(EasyapiBindSQLExecuter.build(query).like(!StringUtil.isEmpty(dto.getName()), DBComplexTestGroupEntity::getName, dto.getName(), new Boolean[0]), dto.getCurrentPage(), dto.getShowCount());
        return page;
    }

    @ApidocComment(value="\u6dfb\u52a0\u63a5\u53e3\u6d4b\u8bd5\u5206\u7ec4")
    @PostMapping(value={"/addGroups"})
    @AccessAuth(code=1000)
    public void addGroups(@RequestBody DBComplexTestGroupEntity entity) {
        AssertUtil.isEmpty(entity.getName(), "\u5206\u7ec4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.groupService.insert(entity);
    }

    @ApidocComment(value="\u4fee\u6539\u63a5\u53e3\u6d4b\u8bd5\u5206\u7ec4")
    @PostMapping(value={"/updateGroups"})
    @AccessAuth(code=1000)
    public void updateGroups(@RequestBody DBComplexTestGroupEntity entity) {
        AssertUtil.isNull((Object)entity.getId(), "\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        this.groupService.update(entity);
    }

    @ApidocComment(value="\u5220\u9664\u63a5\u53e3\u6d4b\u8bd5\u5206\u7ec4")
    @PostMapping(value={"/delGroups"})
    @AccessAuth(code=1000)
    public void delGroups(@RequestBody IdDto dto) {
        this.groupService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u6761\u4ef6\u67e5\u8be2\u63a5\u53e3\u6d4b\u8bd5\u5386\u53f2")
    @PostMapping(value={"/selectTests"})
    @AccessAuth(code=1000)
    public EasyApiBindSqlResult<DBComplexTestEntity> selectTests(@RequestBody SelectGroupsDto dto) {
        DBComplexTestEntity query = new DBComplexTestEntity();
        BeanUtils.copyProperties((Object)dto, (Object)query);
        EasyApiBindSqlResult page = this.testService.page(EasyapiBindSQLExecuter.build(query).like(!StringUtil.isEmpty(dto.getName()), DBComplexTestGroupEntity::getName, dto.getName(), new Boolean[0]), dto.getCurrentPage(), dto.getShowCount());
        return page;
    }

    @ApidocComment(value="\u5220\u9664\u63a5\u53e3\u6d4b\u8bd5\u5386\u53f2")
    @PostMapping(value={"/delTests"})
    @AccessAuth(code=1000)
    public void delTests(@RequestBody IdDto dto) {
        this.testService.deleteById(dto.getId());
        DBComplexTestInfoEntity entity = new DBComplexTestInfoEntity();
        entity.setTestId(dto.getId());
        this.testInfoService.delete(entity);
    }
}

