/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHostEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleOutPackageEntity;
import cn.easyutil.easyapi.entity.db.doc.DBMouduleEnvEntity;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.dto.SearchDto;
import cn.easyutil.easyapi.interview.dto.SelectInterfacesDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.vo.InterfaceInfoVo;
import cn.easyutil.easyapi.service.ControllerService;
import cn.easyutil.easyapi.service.EnvService;
import cn.easyutil.easyapi.service.HostService;
import cn.easyutil.easyapi.service.InterfaceParamService;
import cn.easyutil.easyapi.service.InterfaceService;
import cn.easyutil.easyapi.service.OutPackageService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnMissingBean(name={"easyapiSimpleApidocController"})
@RequestMapping(value={"/easyapi/doc/simple"})
public class SimpleApidocController {
    @Resource(name="easyapiControllerService")
    private ControllerService controllerService;
    @Resource(name="easyapiInterfaceService")
    private InterfaceService interfaceService;
    @Resource(name="easyapiInterfaceParamService")
    private InterfaceParamService interfaceParamService;
    @Resource(name="easyapiHostService")
    private HostService hostService;
    @Resource(name="easyapiEnvService")
    private EnvService envService;
    @Resource(name="easyapiOutPackageService")
    private OutPackageService outPackageService;

    @ApidocComment(value="\u83b7\u53d6\u63a5\u53e3\u63a7\u5236\u5668\u5217\u8868")
    @PostMapping(value={"/getControllers"})
    @AccessAuth(code=1000)
    public List<DBModuleControllerEntity> getControllers(@RequestBody(required=false) SearchDto dto) {
        if (dto == null) {
            dto = new SearchDto();
        }
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        DBModuleControllerEntity entity = new DBModuleControllerEntity();
        entity.setModuleId(currentModuleId);
        List<DBModuleControllerEntity> list = this.controllerService.list(EasyapiBindSQLExecuter.build(entity).like(!StringUtil.isEmpty(dto), DBModuleControllerEntity::getSearchTags, dto.getSearch(), new Boolean[0]).orderBy(DBModuleControllerEntity::getSort, true));
        if (dto.getSearch() == null) {
            return list;
        }
        HashSet controllerIds = new HashSet();
        if (list != null && list.size() > 0) {
            controllerIds.addAll(list.stream().map(item -> item.getId()).collect(Collectors.toSet()));
        }
        DBModuleInterfaceEntity interfaceEntity = new DBModuleInterfaceEntity();
        interfaceEntity.setModuleId(currentModuleId);
        List inList = this.interfaceService.list(EasyapiBindSQLExecuter.build(interfaceEntity).setReturnParam(DBModuleInterfaceEntity::getControllerId).like(!StringUtil.isEmpty(dto), DBModuleControllerEntity::getSearchTags, dto.getSearch(), new Boolean[0]));
        if (inList != null) {
            controllerIds.addAll(inList.stream().map(DBModuleInterfaceEntity::getControllerId).collect(Collectors.toSet()));
        }
        List<DBModuleControllerEntity> result = this.controllerService.list(EasyapiBindSQLExecuter.build(entity).in(BaseDbEntity::getId, controllerIds, new Boolean[0]));
        return result;
    }

    @ApidocComment(value="\u4fee\u6539\u63a7\u5236\u5668\u4fe1\u606f")
    @PostMapping(value={"/updateControllerInfo"})
    @AccessAuth(code=1000)
    public void updateControllerInfo(@RequestBody DBModuleControllerEntity entity) {
        AssertUtil.isNull((Object)entity.getId(), "\u63a7\u5236\u5668id\u4e0d\u80fd\u4e3a\u7a7a");
        this.controllerService.update(entity);
        DBModuleControllerEntity query = (DBModuleControllerEntity)this.controllerService.getById(entity.getId());
        query.setSearchTags(DBModuleControllerEntity.buildSearchTag(query));
        this.controllerService.update(query);
    }

    @ApidocComment(value="\u5220\u9664\u63a7\u5236\u5668\u4fe1\u606f")
    @PostMapping(value={"/delController"})
    @AccessAuth(code=1000)
    public void delController(@RequestBody IdDto dto) {
        this.controllerService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u67e5\u8be2\u63a5\u53e3\u5217\u8868")
    @PostMapping(value={"/selectInterfaces"})
    @AccessAuth(code=1000)
    public List<DBModuleInterfaceEntity> selectInterfaces(@RequestBody(required=false) SelectInterfacesDto dto) {
        DBModuleInterfaceEntity entity = new DBModuleInterfaceEntity();
        entity.setModuleId(CurrentSession.getCurrentModuleId());
        List<DBModuleInterfaceEntity> list = this.interfaceService.list(EasyapiBindSQLExecuter.build(entity).like(!StringUtil.isEmpty(dto.getSearch()), DBModuleInterfaceEntity::getSearchTags, dto.getSearch(), new Boolean[0]).eq(dto.getControllerId() != null, DBModuleInterfaceEntity::getControllerId, dto.getControllerId(), new Boolean[0]));
        return list;
    }

    @ApidocComment(value="\u4fee\u6539\u63a5\u53e3\u4fe1\u606f")
    @PostMapping(value={"/updateInterfaces"})
    @AccessAuth(code=1000)
    public void updateInterfaces(@RequestBody InterfaceInfoVo vo) {
        if (vo.getInfo() != null) {
            AssertUtil.isNull((Object)vo.getInfo().getId(), "\u63a5\u53e3id\u4e0d\u80fd\u4e3a\u7a7a");
            this.interfaceService.update(vo.getInfo());
            DBModuleInterfaceEntity query = (DBModuleInterfaceEntity)this.interfaceService.getById(vo.getInfo().getId());
            query.setSearchTags(DBModuleInterfaceEntity.buildSearchTag(query));
            this.interfaceService.update(query);
        }
        if (vo.getParams() != null) {
            AssertUtil.isNull((Object)vo.getParams().getId(), "\u63a5\u53e3\u8be6\u60c5id\u4e0d\u80fd\u4e3a\u7a7a");
            DBInterfaceParamEntity entity = vo.getParams();
            this.interfaceParamService.update(entity);
        }
    }

    @ApidocComment(value="\u6839\u636e\u63a5\u53e3id\u83b7\u53d6\u63a5\u53e3\u8be6\u60c5\u4fe1\u606f")
    @PostMapping(value={"/interfaceInfo"})
    @AccessAuth(code=1000)
    public InterfaceInfoVo interfaceInfo(@RequestBody IdDto dto) {
        DBModuleInterfaceEntity info = (DBModuleInterfaceEntity)this.interfaceService.getById(dto.getId());
        AssertUtil.isNull((Object)info, "\u63a5\u53e3\u4e0d\u5b58\u5728");
        DBInterfaceParamEntity query = new DBInterfaceParamEntity();
        query.setInterfaceId(info.getId());
        DBInterfaceParamEntity params = this.interfaceParamService.get(query);
        InterfaceInfoVo vo = new InterfaceInfoVo();
        vo.setInfo(info);
        vo.setParams(params);
        return vo;
    }

    @ApidocComment(value="\u5220\u9664\u63a5\u53e3\u4fe1\u606f")
    @PostMapping(value={"/delInterfaces"})
    @AccessAuth(code=1000)
    public void delInterfaces(@RequestBody IdDto dto) {
        this.interfaceService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u83b7\u53d6\u8bf7\u6c42\u73af\u5883\u5217\u8868")
    @PostMapping(value={"/getHosts"})
    @AccessAuth(code=1000)
    public List<DBModuleHostEntity> getHosts() {
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        DBModuleHostEntity entity = new DBModuleHostEntity();
        entity.setModuleId(currentModuleId);
        List<DBModuleHostEntity> list = this.hostService.list(entity);
        return list;
    }

    @ApidocComment(value="\u6dfb\u52a0\u8bf7\u6c42\u73af\u5883")
    @PostMapping(value={"/addHost"})
    @AccessAuth(code=1000)
    public void addHost(@RequestBody DBModuleHostEntity hostEntity) {
        this.hostService.insert(hostEntity);
    }

    @ApidocComment(value="\u4fee\u6539\u8bf7\u6c42\u73af\u5883")
    @PostMapping(value={"/updateHost"})
    @AccessAuth(code=1000)
    public void updateHost(@RequestBody DBModuleHostEntity hostEntity) {
        AssertUtil.isNull((Object)hostEntity.getId(), "\u73af\u5883id\u4e0d\u80fd\u4e3a\u7a7a");
        this.hostService.update(hostEntity);
    }

    @ApidocComment(value="\u5220\u9664\u8bf7\u6c42\u73af\u5883")
    @PostMapping(value={"/delHost"})
    @AccessAuth(code=1000)
    public void delHost(@RequestBody IdDto dto) {
        this.hostService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u83b7\u53d6\u5168\u90e8\u73af\u5883\u53d8\u91cf")
    @PostMapping(value={"/getEnvsgs"})
    @AccessAuth(code=1000)
    public List<DBMouduleEnvEntity> getEnvsgs() {
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        DBMouduleEnvEntity entity = new DBMouduleEnvEntity();
        entity.setModuleId(currentModuleId);
        List<DBMouduleEnvEntity> list = this.envService.list(entity);
        return list;
    }

    @ApidocComment(value="\u6dfb\u52a0\u73af\u5883\u53d8\u91cf")
    @PostMapping(value={"/addEnv"})
    @AccessAuth(code=1000)
    public void addEnv(@RequestBody DBMouduleEnvEntity env) {
        this.envService.insert(env);
    }

    @ApidocComment(value="\u4fee\u6539\u73af\u5883\u53d8\u91cf")
    @PostMapping(value={"/updateEnv"})
    @AccessAuth(code=1000)
    public void updateEnv(@RequestBody DBMouduleEnvEntity env) {
        AssertUtil.isNull((Object)env.getId(), "\u73af\u5883\u53d8\u91cfid\u4e0d\u80fd\u4e3a\u7a7a");
        this.envService.update(env);
    }

    @ApidocComment(value="\u5220\u9664\u73af\u5883\u53d8\u91cf")
    @PostMapping(value={"/delEnv"})
    @AccessAuth(code=1000)
    public void delEnv(@RequestBody IdDto dto) {
        this.envService.deleteById(dto.getId());
    }

    @ApidocComment(value="\u83b7\u53d6\u8fd4\u56de\u53c2\u6570\u7684\u5916\u5305\u88c5\u5217\u8868")
    @PostMapping(value={"/getOutPackages"})
    @AccessAuth(code=1000)
    public List<DBModuleOutPackageEntity> getOutPackages() {
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        DBModuleOutPackageEntity entity = new DBModuleOutPackageEntity();
        entity.setModuleId(currentModuleId);
        List<DBModuleOutPackageEntity> list = this.outPackageService.list(entity);
        return list;
    }

    @ApidocComment(value="\u65b0\u589e\u8fd4\u56de\u53c2\u6570\u7684\u5916\u5305\u88c5")
    @PostMapping(value={"/addOutPackages"})
    @AccessAuth(code=1000)
    public void addOutPackages(@RequestBody DBModuleOutPackageEntity entity) {
        if (entity.getDefaultStatus() == 1) {
            Long currentModuleId = CurrentSession.getCurrentModuleId();
            DBModuleOutPackageEntity query = new DBModuleOutPackageEntity();
            query.setModuleId(currentModuleId);
            query.setDefaultStatus(entity.getDefaultStatus());
            query = this.outPackageService.get(query);
            AssertUtil.isTrue(query != null, "\u5916\u5305\u88c5\u53ea\u5141\u8bb8\u6709\u4e00\u4e2a\u5305\u88c5\u503c");
        }
        this.outPackageService.insert(entity);
    }

    @ApidocComment(value="\u4fee\u6539\u8fd4\u56de\u53c2\u6570\u7684\u5916\u5305\u88c5")
    @PostMapping(value={"/updateOutPackages"})
    @AccessAuth(code=1000)
    public void updateOutPackages(@RequestBody DBModuleOutPackageEntity entity) {
        AssertUtil.isNull((Object)entity.getId(), "\u5916\u5305\u88c5id\u4e0d\u80fd\u4e3a\u7a7a");
        DBModuleOutPackageEntity query = (DBModuleOutPackageEntity)this.outPackageService.getById(entity.getId());
        if (entity.getDefaultStatus() != null && entity.getDefaultStatus() == 1 && !entity.getDefaultStatus().equals(query.getDefaultStatus())) {
            Long currentModuleId = CurrentSession.getCurrentModuleId();
            DBModuleOutPackageEntity find = new DBModuleOutPackageEntity();
            find.setModuleId(currentModuleId);
            find.setDefaultStatus(entity.getDefaultStatus());
            find = this.outPackageService.get(query);
            AssertUtil.isTrue(find != null, "\u5916\u5305\u88c5\u53ea\u5141\u8bb8\u6709\u4e00\u4e2a\u5305\u88c5\u503c");
        }
        this.outPackageService.update(entity);
    }

    @ApidocComment(value="\u5220\u9664\u8fd4\u56de\u53c2\u6570\u7684\u5916\u5305\u88c5")
    @PostMapping(value={"/delOutPackages"})
    @AccessAuth(code=1000)
    public void delOutPackages(@RequestBody IdDto dto) {
        this.outPackageService.deleteById(dto.getId());
    }
}

