/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleEntity;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.service.ModuleService;
import cn.easyutil.easyapi.util.AssertUtil;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnMissingBean(name={"easyapiModuleController"})
@RequestMapping(value={"/easyapi/doc/module"})
public class ModuleController {
    @Resource(name="easyapiModuleService")
    private ModuleService moduleService;

    @ApidocComment(value="\u83b7\u53d6\u6a21\u5757\u5217\u8868")
    @PostMapping(value={"/getModules"})
    @AccessAuth(code=1000)
    public List<DBModuleEntity> getModules() {
        Long projectId = CurrentSession.getCurrentProjectId();
        List<Integer> modules = CurrentSession.getCurrentUser().getProjectIds().get(projectId);
        List<DBModuleEntity> list = this.moduleService.list(EasyapiBindSQLExecuter.build(new DBModuleEntity()).in(BaseDbEntity::getId, modules, new Boolean[0]));
        return list;
    }

    @ApidocComment(value="\u4fee\u6539\u6a21\u5757\u4fe1\u606f")
    @PostMapping(value={"/updateModules"})
    @AccessAuth(code=1000)
    public void updateModules(@RequestBody DBModuleEntity entity) {
        AssertUtil.isNull((Object)entity.getId(), "\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        if (entity.getDefaultStatus() != null && entity.getDefaultStatus() == 1) {
            DBModuleEntity query = new DBModuleEntity();
            query.setDefaultStatus(entity.getDefaultStatus());
            query = this.moduleService.get(query);
            AssertUtil.isTrue(query != null, "\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u6a21\u5757");
        }
        this.moduleService.update(entity);
    }

    @ApidocComment(value="\u65b0\u589e\u6a21\u5757\u4fe1\u606f")
    @PostMapping(value={"/addModules"})
    @AccessAuth(code=1000)
    public void addModules(@RequestBody DBModuleEntity entity) {
        if (entity.getDefaultStatus() != null && entity.getDefaultStatus() == 1) {
            DBModuleEntity query = new DBModuleEntity();
            query.setDefaultStatus(entity.getDefaultStatus());
            query = this.moduleService.get(query);
            AssertUtil.isTrue(query != null, "\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u6a21\u5757");
        }
        this.moduleService.insert(entity);
    }

    @ApidocComment(value="\u5220\u9664\u6a21\u5757\u4fe1\u606f")
    @PostMapping(value={"/delModules"})
    @AccessAuth(code=1000)
    public void delModules(@RequestBody IdDto dto) {
        this.moduleService.deleteById(dto.getId());
    }
}

