/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestEntity;
import cn.easyutil.easyapi.entity.db.unit.DBComplexTestInfoEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.interview.dto.GroupExtendsDto;
import cn.easyutil.easyapi.interview.dto.ReciveSourceDto;
import cn.easyutil.easyapi.interview.dto.StartTestDto;
import cn.easyutil.easyapi.interview.dto.SyncRemoteAllDto;
import cn.easyutil.easyapi.interview.dto.SyncSourceDto;
import cn.easyutil.easyapi.interview.entity.HttpEntity;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.vo.InterfaceInfoVo;
import cn.easyutil.easyapi.interview.vo.StartTestVo;
import cn.easyutil.easyapi.logic.unit.ComplexTestProcess;
import cn.easyutil.easyapi.logic.unit.UnitTestProcesser;
import cn.easyutil.easyapi.service.ControllerService;
import cn.easyutil.easyapi.service.InterfaceParamService;
import cn.easyutil.easyapi.service.InterfaceService;
import cn.easyutil.easyapi.service.ModuleService;
import cn.easyutil.easyapi.service.ProjectService;
import cn.easyutil.easyapi.service.UserService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import cn.easyutil.easyapi.util.http.HttpMethod;
import cn.easyutil.easyapi.util.http.HttpOperation;
import cn.easyutil.easyapi.util.http.HttpRes;
import cn.easyutil.easyapi.util.http.HttpUtilFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnMissingBean(name={"easyapiComplexApidocController"})
@RequestMapping(value={"/easyapi/doc/complex"})
public class ComplexApidocController {
    @Resource(name="easyapiInterfaceService")
    private InterfaceService interfaceService;
    @Resource(name="easyapiModuleService")
    private ModuleService moduleService;
    @Resource(name="easyapiControllerService")
    private ControllerService controllerService;
    @Resource(name="easyapiInterfaceParamService")
    private InterfaceParamService parameterService;
    @Resource(name="easyapiUserService")
    private UserService userService;
    @Resource(name="easyapiProjectService")
    private ProjectService projectService;
    @Resource(name="easyapiInterfaceParamService")
    private InterfaceParamService interfaceParamService;

    @ApidocComment(value="\u7f51\u7edc\u8bf7\u6c42")
    @PostMapping(value={"/doUrl"})
    @AccessAuth(code=1000)
    public HttpRes doUrl(@RequestBody HttpEntity entity) {
        return ComplexTestProcess.doUrl(entity, true);
    }

    @ApidocComment(value="\u6267\u884c\u6d4b\u8bd5")
    @PostMapping(value={"/startTest"})
    @AccessAuth(code=1000)
    public StartTestVo startTest(@RequestBody StartTestDto dto) {
        AssertUtil.isNull(dto.getGroups(), "\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isEmpty(dto.getUrl(), "\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(dto.getGroups().isEmpty(), "\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNull((Object)dto.getInterfaceId(), "\u63a5\u53e3id\u4e0d\u80fd\u4e3a\u7a7a");
        Long userId = CurrentSession.getCurrentUser().getId();
        DBModuleInterfaceEntity interfaceEntity = (DBModuleInterfaceEntity)this.interfaceService.getById(dto.getInterfaceId());
        AssertUtil.isNull((Object)interfaceEntity, "\u63a5\u53e3\u4e0d\u5b58\u5728");
        HttpEntity enty = new HttpEntity();
        enty.setUrl(dto.getUrl());
        enty.setMethod(interfaceEntity.getRequestMethodString());
        enty.setBodyType(interfaceEntity.getBodyType());
        ArrayList<HttpEntity> processers = new ArrayList<HttpEntity>();
        List<GroupExtendsDto> groups = dto.getGroups();
        for (GroupExtendsDto group : groups) {
            if (group.getThreadCount() == null || group.getThreadCount() <= 0) continue;
            for (int i = 0; i < group.getThreadCount(); ++i) {
                HttpEntity cp = new HttpEntity();
                BeanUtils.copyProperties((Object)enty, (Object)cp);
                cp.setJsonHeaders(group.getRequestHeaders());
                cp.setJsonParams(group.getRequestParam());
                processers.add(cp);
            }
        }
        if (processers.size() == 0) {
            throw new ApidocException("\u7ebf\u7a0b\u6570\u4e3a0");
        }
        StartTestVo vo = new StartTestVo();
        DBComplexTestEntity result = new DBComplexTestEntity();
        result.setSuccessCount(0);
        result.setFailCount(0);
        vo.setTest(result);
        result.setUserId(userId);
        Long startTime = System.currentTimeMillis();
        List<UnitTestProcesser> unitTestProcessers = ComplexTestProcess.startTest(processers, ProjectContext.allConfiguration.getUnitConfiguration(), true);
        Long endTime = System.currentTimeMillis();
        result.setTimeConsuming(endTime - startTime);
        result.setInterfaceId(interfaceEntity.getId());
        result.setSuccessKey(dto.getSuccessKey());
        result.setSuccessOper(dto.getSuccessOper());
        result.setSuccessVal(dto.getSuccessVal());
        result.setGroupIds(groups.stream().filter(item -> item.getId() != null).map(item -> item.getId().toString()).collect(Collectors.joining(",")));
        if (unitTestProcessers.size() == 0) {
            return vo;
        }
        ArrayList<DBComplexTestInfoEntity> infos = new ArrayList<DBComplexTestInfoEntity>();
        for (UnitTestProcesser processer : unitTestProcessers) {
            DBComplexTestInfoEntity entity = ComplexTestProcess.buildInfo(processer.getHttpRes(), processer.getDecodes(), dto.getSuccessKey(), dto.getSuccessOper(), dto.getSuccessVal());
            entity.setRequestHeaders(processer.getEnty().getJsonHeaders());
            entity.setRequestParam(processer.getEnty().getJsonParams());
            entity.setTestId(null);
            infos.add(entity);
        }
        result.setSuccessCount((int)infos.stream().filter(item -> item.getSuccessStatus() == 1).count());
        result.setFailCount(infos.size() - result.getSuccessCount());
        vo.setInfos(infos);
        return vo;
    }

    @ApidocComment(value="\u5c06\u672c\u5730\u9879\u76ee\u6a21\u5757\u4e0b\u53d1\u5230\u5bf9\u65b9\u673a\u5668")
    @PostMapping(value={"/syncPull"})
    @AccessAuth(code=1000)
    public ReciveSourceDto syncPull(@RequestBody SyncRemoteAllDto dto) {
        DBProjectEntity project = this.syncCheckProject(dto, dto.getTargetProjectName());
        DBModuleEntity module = this.syncCheckModule(project.getId(), dto.getTargetModuleName());
        DBUserEntity user = this.userService.getByAccount(dto.getTargetUsername());
        AssertUtil.isNull((Object)user, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        AssertUtil.isTrue(!user.getPassword().equals(dto.getTargetPassword()), "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        ReciveSourceDto reciveSourceDto = this.syncBuild(module.getId());
        BeanUtils.copyProperties((Object)dto, (Object)reciveSourceDto);
        return reciveSourceDto;
    }

    @ApidocComment(value="\u5c06\u9879\u76ee\u540c\u6b65\u5230\u8fdc\u7a0b\u673a\u5668")
    @PostMapping(value={"/syncRemoteAll"})
    @AccessAuth(code=1000)
    public void syncRemoteAll(@RequestBody SyncRemoteAllDto dto) {
        DBProjectEntity project = this.syncCheckProject(dto, dto.getLocalProjectName());
        DBModuleEntity module = this.syncCheckModule(project.getId(), dto.getLocalModuleName());
        ReciveSourceDto reciveSourceDto = this.syncBuild(module.getId());
        BeanUtils.copyProperties((Object)dto, (Object)reciveSourceDto);
        HttpRes login = this.doEasyapiUrl(dto.getTargetHost() + "/easyapi/doc/user/login", JsonUtil.beanToJson(dto));
        this.getDoEasyapiUrlResult(login);
        HttpRes sync = this.doEasyapiUrl(dto.getTargetHost() + "/easyapi/doc/complex/reciveSource", JsonUtil.beanToJson(reciveSourceDto));
        this.getDoEasyapiUrlResult(sync);
    }

    @ApidocComment(value="\u63a5\u6536\u8fdc\u7a0b\u6765\u7684\u540c\u6b65")
    @PostMapping(value={"/reciveSource"})
    @AccessAuth(code=1000)
    public void reciveSource(@RequestBody ReciveSourceDto dto) {
        String username = dto.getTargetUsername();
        String password = dto.getTargetPassword();
        String projectName = dto.getTargetProjectName();
        String moduleName = dto.getTargetModuleName();
        AssertUtil.isTrue(StringUtil.isEmpty(username), "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        AssertUtil.isTrue(StringUtil.isEmpty(password), "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        DBUserEntity user = this.userService.getByAccount(username);
        AssertUtil.isNull((Object)user, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        AssertUtil.isTrue(!user.getPassword().equals(password), "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        this.saveSyncSource(projectName, moduleName, dto.getSources(), dto.getOverwriteType());
    }

    private DBModuleControllerEntity syncController(DBModuleControllerEntity controller, DBModuleControllerEntity currentController, int overwriteType) {
        switch (overwriteType) {
            case 0: {
                if (currentController != null) {
                    controller.setId(currentController.getId());
                    this.controllerService.update(controller);
                    break;
                }
                this.controllerService.insert(controller);
                break;
            }
            case 1: {
                if (currentController != null) break;
                this.controllerService.insert(controller);
                break;
            }
            case 2: {
                if (currentController == null) break;
                controller.setId(currentController.getId());
                this.controllerService.update(controller);
            }
        }
        return controller;
    }

    private DBModuleInterfaceEntity syncInterface(DBModuleInterfaceEntity in, DBModuleInterfaceEntity currentInterface, DBInterfaceParamEntity params, int overwriteType) {
        switch (overwriteType) {
            case 0: {
                if (in != null) {
                    in.setId(currentInterface.getId());
                    this.interfaceService.update(in);
                } else {
                    this.interfaceService.insert(in);
                }
                this.interfaceParamService.delete(EasyapiBindSQLExecuter.build(new DBInterfaceParamEntity()).eq(DBInterfaceParamEntity::getInterfaceId, (Object)in.getId(), new Boolean[0]));
                params.setInterfaceId(in.getId());
                this.interfaceParamService.insert(params);
                break;
            }
            case 1: {
                if (currentInterface != null) break;
                this.interfaceService.insert(in);
                params.setInterfaceId(in.getId());
                this.interfaceParamService.insert(params);
                break;
            }
            case 2: {
                if (currentInterface == null) break;
                in.setId(currentInterface.getId());
                this.interfaceService.update(in);
                this.interfaceParamService.delete(EasyapiBindSQLExecuter.build(new DBInterfaceParamEntity()).eq(DBInterfaceParamEntity::getInterfaceId, (Object)in.getId(), new Boolean[0]));
                params.setInterfaceId(in.getId());
                this.interfaceParamService.insert(params);
            }
        }
        return in;
    }

    public HttpRes doEasyapiUrl(String url, String param) {
        HttpOperation operation = HttpUtilFactory.fastCreate(url, HttpMethod.POST);
        operation.getHttpReq().addParam(param);
        operation.getHttpReq().addHeader("Content-Type", "application/json");
        HttpRes httpRes = operation.doUrl();
        if (httpRes.getResponseCode() != 200) {
            throw new ApidocException("\u8bf7\u6c42\u8fdc\u7a0b\u673a\u5668\u5931\u8d25");
        }
        String responseMsg = httpRes.getResponseMsg();
        if (StringUtil.isEmpty(responseMsg)) {
            throw new ApidocException("\u8bf7\u6c42\u8fdc\u7a0b\u673a\u5668\u5931\u8d25");
        }
        Map<String, Object> map = JsonUtil.jsonToMap(responseMsg);
        if (!map.get("code").equals(200)) {
            throw new ApidocException("\u76ee\u6807\u673a\u5668\u8fd4\u56de:" + map.get("remark"));
        }
        return httpRes;
    }

    private DBProjectEntity syncCheckProject(SyncRemoteAllDto dto, String projectName) {
        AssertUtil.isEmpty(dto.getTargetHost(), "\u672a\u77e5\u7684\u76ee\u6807\u673a\u5668");
        AssertUtil.isEmpty(dto.getTargetProjectName(), "\u672a\u77e5\u7684\u76ee\u6807\u9879\u76ee");
        AssertUtil.isEmpty(dto.getTargetModuleName(), "\u672a\u77e5\u7684\u76ee\u6807\u6a21\u5757");
        AssertUtil.isEmpty(dto.getTargetUsername(), "\u76ee\u6807\u673a\u5668\u767b\u9646\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isEmpty(dto.getTargetPassword(), "\u76ee\u6807\u673a\u5668\u767b\u9646\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isEmpty(dto.getLocalProjectName(), "\u672a\u77e5\u7684\u672c\u5730\u9879\u76ee");
        AssertUtil.isEmpty(dto.getLocalModuleName(), "\u672a\u77e5\u7684\u672c\u5730\u6a21\u5757");
        DBProjectEntity project = this.projectService.getByName(projectName);
        AssertUtil.isNull((Object)project, "\u672a\u77e5\u7684\u672c\u5730\u9879\u76ee");
        return project;
    }

    private DBModuleEntity syncCheckModule(Long projectId, String moduleName) {
        DBModuleEntity module = (DBModuleEntity)this.moduleService.get(EasyapiBindSQLExecuter.build(new DBModuleEntity()).eq(BaseDbEntity::getProjectId, (Object)projectId, new Boolean[0]).eq(DBModuleEntity::getName, (Object)moduleName, new Boolean[0]));
        AssertUtil.isNull((Object)module, "\u672a\u77e5\u7684\u672c\u5730\u6a21\u5757");
        return module;
    }

    private ReciveSourceDto syncBuild(Long moduleId) {
        List controllers = this.controllerService.list(EasyapiBindSQLExecuter.build(new DBModuleControllerEntity()).eq(DBModuleControllerEntity::getModuleId, (Object)moduleId, new Boolean[0]));
        if (StringUtil.isEmpty(controllers)) {
            throw new ApidocException("\u8be5\u6a21\u5757\u4e0b\u6ca1\u6709\u63a5\u53e3");
        }
        ArrayList<SyncSourceDto> sources = new ArrayList<SyncSourceDto>();
        for (DBModuleControllerEntity controller : controllers) {
            SyncSourceDto source = new SyncSourceDto();
            source.setController(controller);
            ArrayList<InterfaceInfoVo> ins = new ArrayList<InterfaceInfoVo>();
            source.setInterfaces(ins);
            List list = this.interfaceService.list(EasyapiBindSQLExecuter.build(new DBModuleInterfaceEntity()).eq(DBModuleInterfaceEntity::getControllerId, (Object)controller.getId(), new Boolean[0]));
            if (list == null) continue;
            for (DBModuleInterfaceEntity in : list) {
                InterfaceInfoVo vo = new InterfaceInfoVo();
                vo.setInfo(in);
                DBInterfaceParamEntity paramEntity = (DBInterfaceParamEntity)this.parameterService.get(EasyapiBindSQLExecuter.build(new DBInterfaceParamEntity()).eq(DBInterfaceParamEntity::getInterfaceId, (Object)in.getId(), new Boolean[0]));
                vo.setParams(paramEntity);
                ins.add(vo);
            }
            sources.add(source);
        }
        ReciveSourceDto reciveSourceDto = new ReciveSourceDto();
        reciveSourceDto.setSources(sources);
        return reciveSourceDto;
    }

    public String getDoEasyapiUrlResult(HttpRes result) {
        if (result.getResponseCode() != 200 || StringUtil.isEmpty(result.getResponseMsg())) {
            throw new ApidocException("\u8fdc\u7a0b\u673a\u5668\u8fde\u63a5\u5931\u8d25");
        }
        Map<String, Object> doResult = JsonUtil.jsonToMap(result.getResponseMsg());
        if (!doResult.get("code").equals(200)) {
            throw new ApidocException(doResult.get("remark").toString());
        }
        return doResult.get("data").toString();
    }

    public void saveSyncSource(String projectName, String moduleName, List<SyncSourceDto> sources, int overwriteType) {
        DBProjectEntity project = this.projectService.getByName(projectName);
        BaseDbEntity module = null;
        if (project != null) {
            module = (DBModuleEntity)this.moduleService.get(EasyapiBindSQLExecuter.build(new DBModuleEntity()).eq(BaseDbEntity::getProjectId, (Object)project.getId(), new Boolean[0]).eq(DBModuleEntity::getName, (Object)moduleName, new Boolean[0]));
        }
        if (overwriteType == 2 && project == null) {
            return;
        }
        if (project == null) {
            DBProjectEntity entity = new DBProjectEntity();
            entity.setDefaultStatus(0);
            entity.setDescription("\u8fdc\u7a0b\u540c\u6b65\u9879\u76ee");
            entity.setDisable(0);
            entity.setName(projectName);
            entity.setTitle(projectName);
            this.projectService.insert(entity);
            project = entity;
            DBModuleEntity mo = new DBModuleEntity();
            mo.setProjectId(project.getId());
            mo.setName(moduleName);
            mo.setDescription("\u8fdc\u7a0b\u540c\u6b65\u6a21\u5757");
            mo.setDefaultStatus(0);
            mo.setOutPackgeStatus(0);
            this.moduleService.insert(mo);
            module = mo;
        }
        if (overwriteType == 0) {
            this.moduleService.clearById(module.getId());
        }
        for (SyncSourceDto source : sources) {
            DBModuleControllerEntity controller = source.getController();
            controller.setProjectId(project.getId());
            controller.setModuleId(module.getId());
            controller.setId(null);
            String className = controller.getClassName();
            DBModuleControllerEntity currentController = (DBModuleControllerEntity)this.controllerService.get(EasyapiBindSQLExecuter.build(new DBModuleControllerEntity()).eq(BaseDbEntity::getProjectId, (Object)project.getId(), new Boolean[0]).eq(DBModuleControllerEntity::getModuleId, (Object)module.getId(), new Boolean[0]).eq(DBModuleControllerEntity::getClassName, (Object)className, new Boolean[0]));
            DBModuleControllerEntity resultController = this.syncController(controller, currentController, overwriteType);
            List<InterfaceInfoVo> interfaces = source.getInterfaces();
            if (interfaces == null) continue;
            for (InterfaceInfoVo infoVo : interfaces) {
                DBModuleInterfaceEntity info = infoVo.getInfo();
                DBInterfaceParamEntity params = infoVo.getParams();
                info.setId(null);
                info.setProjectId(resultController.getProjectId());
                info.setModuleId(resultController.getModuleId());
                info.setControllerId(resultController.getId());
                String requestUrl = info.getRequestUrl();
                DBModuleInterfaceEntity currentInterface = (DBModuleInterfaceEntity)this.interfaceService.get(EasyapiBindSQLExecuter.build(new DBModuleInterfaceEntity()).eq(DBModuleInterfaceEntity::getControllerId, (Object)resultController.getId(), new Boolean[0]).eq(DBModuleInterfaceEntity::getRequestUrl, (Object)requestUrl, new Boolean[0]));
                this.syncInterface(info, currentInterface, params, overwriteType);
            }
        }
    }
}

