/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.datasource.bean.EasyapiBindSQLExecuter;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleHostEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleOutPackageEntity;
import cn.easyutil.easyapi.entity.doc.ControllerBean;
import cn.easyutil.easyapi.entity.doc.InterfaceBean;
import cn.easyutil.easyapi.entity.doc.MockOutPackageBean;
import cn.easyutil.easyapi.entity.doc.ProjectBean;
import cn.easyutil.easyapi.entity.doc.ProjectHostBean;
import cn.easyutil.easyapi.interview.controller.ComplexApidocController;
import cn.easyutil.easyapi.interview.controller.ProjectController;
import cn.easyutil.easyapi.interview.controller.SimpleApidocController;
import cn.easyutil.easyapi.interview.dto.SelectInterfacesDto;
import cn.easyutil.easyapi.interview.entity.HttpEntity;
import cn.easyutil.easyapi.interview.entity.ResponseBody;
import cn.easyutil.easyapi.interview.entity.SyncFileBean;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.service.ControllerService;
import cn.easyutil.easyapi.util.HttpUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import cn.easyutil.easyapi.util.http.HttpRes;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Deprecated
@RestController
@ConditionalOnMissingBean(name={"easyapiApiDocController"})
@RequestMapping(value={"/easyapi/doc"})
public class ApiDocController {
    @Resource(name="easyapiProjectController")
    private ProjectController projectControl;
    @Resource(name="easyapiSimpleApidocController")
    private SimpleApidocController simpleApidocController;
    @Resource(name="easyapiControllerService")
    private ControllerService controllerService;
    @Resource(name="easyapiComplexApidocController")
    private ComplexApidocController complexApidocController;

    @PostMapping(value={"/getInfo"})
    public ResponseBody getInfo(Long projectId) {
        List<DBProjectEntity> data = this.projectControl.getProjects();
        if (data == null || data.size() == 0) {
            return ResponseBody.success(null);
        }
        ProjectBean infoBean = new ProjectBean();
        DBProjectEntity entity = data.get(0);
        infoBean.setName(entity.getName());
        infoBean.setTitle(entity.getTitle());
        infoBean.setRemark(entity.getDescription());
        List<DBModuleHostEntity> hosts = this.simpleApidocController.getHosts();
        ArrayList<ProjectHostBean> phs = new ArrayList<ProjectHostBean>();
        for (DBModuleHostEntity host : hosts) {
            ProjectHostBean bean = new ProjectHostBean();
            bean.setName(host.getName());
            bean.setProjectId(host.getProjectId());
            bean.setHost(host.getHost());
            bean.setAddress(host.getHost());
            phs.add(bean);
        }
        infoBean.setRequestHost(phs);
        return ResponseBody.success(infoBean);
    }

    @PostMapping(value={"/getOutPackage"})
    public ResponseBody getOutPackage(Long projectId) {
        ArrayList<MockOutPackageBean> list = new ArrayList<MockOutPackageBean>();
        List<DBModuleOutPackageEntity> data = this.simpleApidocController.getOutPackages();
        for (DBModuleOutPackageEntity out : data) {
            MockOutPackageBean op = new MockOutPackageBean();
            op.setProjectId(CurrentSession.getCurrentProjectId());
            op.setDataStatus(out.getDefaultStatus());
            op.setKey(out.getKey());
            op.setType(out.getType());
            op.setOldVal(out.getVal());
            op.setVal(out.getVal());
            list.add(op);
        }
        return ResponseBody.success(list);
    }

    @PostMapping(value={"/updateOutPackage"})
    public ResponseBody updateOutPackage(String json, Long projectId) {
        if (StringUtil.isEmpty(json)) {
            return ResponseBody.error("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            List<MockOutPackageBean> list = JsonUtil.jsonToList(json, MockOutPackageBean.class);
            boolean hasData = false;
            ArrayList<DBModuleOutPackageEntity> outList = new ArrayList<DBModuleOutPackageEntity>();
            for (MockOutPackageBean bean : list) {
                bean.setProjectId(projectId);
                Integer dataStatus = bean.getDataStatus();
                if (dataStatus == null) {
                    dataStatus = 0;
                    bean.setDataStatus(0);
                }
                if (dataStatus == 1 && hasData) {
                    return ResponseBody.error("\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u5b9e\u4f53\u5916\u5305\u88c5");
                }
                if (dataStatus == 1) {
                    hasData = true;
                }
                DBModuleOutPackageEntity entity = new DBModuleOutPackageEntity();
                entity.setProjectId(ProjectContext.currentProjectId);
                entity.setDefaultStatus(bean.getDataStatus());
                entity.setModuleId(ProjectContext.currentModuleId);
                entity.setKey(bean.getKey());
                if (!StringUtil.isEmpty(bean.getVal())) {
                    entity.setVal(JsonUtil.beanToJson(bean.getVal()));
                }
                outList.add(entity);
            }
            if (!hasData) {
                return ResponseBody.error("\u5fc5\u987b\u5b58\u5728\u4e00\u4e2a\u5b9e\u4f53\u5916\u5305\u88c5");
            }
            ProjectContext.execution.delete(EasyapiBindSQLExecuter.build(new DBModuleOutPackageEntity()).gte(BaseDbEntity::getId, (Object)1, new Boolean[0]));
            ProjectContext.execution.insert(outList);
            return ResponseBody.success(null);
        }
        catch (Exception e) {
            return ResponseBody.error("\u6570\u636e\u7ed3\u6784\u9519\u8bef");
        }
    }

    @PostMapping(value={"/getControllers"})
    public ResponseBody getControllers(Long projectId) {
        List<DBModuleControllerEntity> cons = this.simpleApidocController.getControllers(null);
        ArrayList<ControllerBean> list = new ArrayList<ControllerBean>();
        for (DBModuleControllerEntity con : cons) {
            ControllerBean cb = new ControllerBean();
            cb.setProject_id(CurrentSession.getCurrentProjectId());
            cb.setController_java_name(con.getClassName());
            cb.setController_comment(con.getDescription());
            cb.setController_comment_pinyin(con.getPinyin());
            cb.setController_comment(con.getShowName());
            cb.setApi_path(con.getApiPath());
            SelectInterfacesDto dto = new SelectInterfacesDto();
            dto.setControllerId(con.getId());
            List<DBModuleInterfaceEntity> ins = this.simpleApidocController.selectInterfaces(dto);
            for (DBModuleInterfaceEntity in : ins) {
                InterfaceBean ib = new InterfaceBean();
                ib.setController_id(in.getControllerId());
                ib.setController_name(in.getControllerClass());
                ib.setProject_id(in.getProjectId());
                ib.setRequest_method(in.getRequestMethod());
                ib.setRequest_type(in.getBodyType());
                ib.setRequest_url(in.getRequestUrl());
                ib.setTitle(in.getTitle());
                ib.setRemark(in.getDescription());
                ib.setJavaName(in.getMethodName());
                ib.setRequest_param_name(in.getId().toString());
                ib.setResponse_param_name(in.getId().toString());
                cb.setChildren(ib);
            }
            list.add(cb);
        }
        return ResponseBody.success(list);
    }

    @PostMapping(value={"/findInterfaces"})
    public ResponseBody findInterfaces(String text, Long projectId) {
        SelectInterfacesDto dto = new SelectInterfacesDto();
        dto.setSearch(text);
        List<DBModuleInterfaceEntity> data = this.simpleApidocController.selectInterfaces(dto);
        HashMap<Long, ControllerBean> map = new HashMap<Long, ControllerBean>();
        for (DBModuleInterfaceEntity entity : data) {
            Long controllerId = entity.getControllerId();
            if (map.get(controllerId) == null) {
                ControllerBean cb = new ControllerBean();
                DBModuleControllerEntity dct = (DBModuleControllerEntity)this.controllerService.getById(entity.getControllerId());
                cb.setController_comment_pinyin(dct.getPinyin());
                cb.setController_comment(dct.getDescription());
                cb.setController_java_name(dct.getClassName());
                cb.setApi_path(dct.getApiPath());
                cb.setController_comment(dct.getShowName());
                map.put(entity.getControllerId(), cb);
            }
            InterfaceBean in = new InterfaceBean();
            in.setController_id(entity.getControllerId());
            in.setController_name(entity.getControllerClass());
            in.setProject_id(entity.getProjectId());
            in.setRequest_url(entity.getRequestUrl());
            in.setTitle(entity.getTitle());
            in.setRequest_type(entity.getBodyType());
            in.setRequest_method(entity.getRequestMethod());
            in.setRequest_param_name(entity.getId().toString());
            in.setResponse_param_name(entity.getId().toString());
            ((ControllerBean)map.get(controllerId)).setChildren(in);
        }
        Collection values = map.values();
        return ResponseBody.success(values);
    }

    @RequestMapping(value={"/mock"})
    public Object mockResponse(String path, Long projectId, Long interfaceId) {
        DBModuleInterfaceEntity in = (DBModuleInterfaceEntity)ProjectContext.execution.selectOne(EasyapiBindSQLExecuter.build(new DBModuleInterfaceEntity()).eq(DBModuleInterfaceEntity::getRequestUrl, (Object)path, new Boolean[0]));
        if (in == null) {
            return "{}";
        }
        DBInterfaceParamEntity parameter = (DBInterfaceParamEntity)ProjectContext.execution.selectOne(EasyapiBindSQLExecuter.build(new DBInterfaceParamEntity()).eq(DBInterfaceParamEntity::getInterfaceId, (Object)in.getId(), new Boolean[0]));
        HashMap<String, Object> result = new HashMap<String, Object>();
        List outPackages = ProjectContext.execution.select(EasyapiBindSQLExecuter.build(new DBModuleOutPackageEntity()));
        String mockJson = parameter.getResponseMock();
        Object mockVal = this.getStrRealVal(mockJson);
        if (!ProjectContext.allConfiguration.getConfiguration().isEnableOutPackage()) {
            return mockVal;
        }
        if (outPackages == null) {
            return mockVal;
        }
        for (DBModuleOutPackageEntity out : outPackages) {
            if (out.getDefaultStatus() == 1) {
                result.put(out.getKey(), mockVal);
                continue;
            }
            result.put(out.getKey(), this.getStrRealVal(out.getVal()));
        }
        return result;
    }

    private Object getStrRealVal(String val) {
        if (StringUtil.isEmpty(val) || !JsonUtil.isJson(val)) {
            return val;
        }
        Object realVal = val;
        try {
            realVal = JsonUtil.jsonToList(val, Map.class);
        }
        catch (Exception e) {
            try {
                realVal = JsonUtil.jsonToList(val, List.class);
            }
            catch (Exception e1) {
                try {
                    realVal = JsonUtil.jsonToMap(val);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return realVal;
    }

    @PostMapping(value={"/getMock"})
    public ResponseBody getMockData(String responseParamName, Long projectId, Long interfaceId) {
        if (StringUtil.isEmpty(responseParamName)) {
            return ResponseBody.error();
        }
        DBInterfaceParamEntity request = new DBInterfaceParamEntity();
        request.setInterfaceId(Long.valueOf(responseParamName));
        request = ProjectContext.execution.selectOne(request);
        String content = request.getResponseMock();
        try {
            return ResponseBody.success(JSONArray.parseArray((String)content));
        }
        catch (Exception e) {
            try {
                return ResponseBody.success(JSONObject.parse((String)content));
            }
            catch (Exception e1) {
                return ResponseBody.success(content);
            }
        }
    }

    @PostMapping(value={"/getRequestParam"})
    public ResponseBody getRequestParam(String requestParamName) {
        DBInterfaceParamEntity request = new DBInterfaceParamEntity();
        request.setInterfaceId(Long.valueOf(requestParamName));
        request = ProjectContext.execution.selectOne(request);
        String context = request.getRequestParamJson();
        Pattern pvalue = Pattern.compile("\"uuid\":\"(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{0,}\"");
        Matcher matcher = pvalue.matcher(context);
        while (matcher.find()) {
            String group = matcher.group();
            while (context.contains(group)) {
                context = context.replaceFirst(group, "\"uuid\":\"" + UUID.randomUUID().toString().replace("-", "") + "\"");
            }
        }
        return ResponseBody.success(JsonUtil.jsonToMap(context));
    }

    @PostMapping(value={"/getResponseParam"})
    public ResponseBody getResponseParam(String responseParamName, Long interfaceId, Long projectId) {
        DBInterfaceParamEntity request = new DBInterfaceParamEntity();
        request.setInterfaceId(Long.valueOf(responseParamName));
        request = ProjectContext.execution.selectOne(request);
        String context = request.getResponseParamJson();
        Pattern pvalue = Pattern.compile("\"uuid\":\"(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{0,}\"");
        Matcher matcher = pvalue.matcher(context);
        while (matcher.find()) {
            String group = matcher.group();
            while (context.contains(group)) {
                context = context.replaceFirst(group, "\"uuid\":\"" + UUID.randomUUID().toString().replace("-", "") + "\"");
            }
        }
        return ResponseBody.success(JsonUtil.jsonToMap(context));
    }

    @RequestMapping(value={"/doUrl"})
    public ResponseBody doUrl(TemporaryHttpEntity enty) {
        enty.setBodyType(enty.getType());
        HttpRes httpRes = this.complexApidocController.doUrl(enty);
        String res = httpRes.getResponseMsg();
        if (StringUtil.isEmpty(httpRes)) {
            res = "{}";
        }
        String base64Result = StringUtil.base64Encode(res);
        return ResponseBody.success(base64Result);
    }

    @PostMapping(value={"/updateInfo"})
    public ResponseBody updateInfo(ProjectBean info, Long projectId) {
        List<ProjectHostBean> requestHost;
        if (!StringUtil.isEmpty(info.getJson())) {
            info = JsonUtil.jsonToBean(info.getJson(), ProjectBean.class);
        }
        if ((requestHost = info.getRequestHost()) != null) {
            ProjectContext.execution.delete(EasyapiBindSQLExecuter.build(new DBModuleHostEntity()).gte(BaseDbEntity::getId, (Object)1, new Boolean[0]));
            ArrayList<DBModuleHostEntity> hosts = new ArrayList<DBModuleHostEntity>();
            for (ProjectHostBean host : requestHost) {
                host.setProjectId(projectId);
                host.setCreateTime(System.currentTimeMillis());
                DBModuleHostEntity entity = new DBModuleHostEntity();
                entity.setProjectId(ProjectContext.currentProjectId);
                entity.setHost(host.getHost());
                entity.setDefaultStatus(host.getName().equals("mock") ? 1 : 0);
                entity.setName(host.getName());
                entity.setModuleId(ProjectContext.currentModuleId);
                hosts.add(entity);
            }
            ProjectContext.execution.insert(hosts);
        }
        DBProjectEntity entity = new DBProjectEntity();
        entity.setId(ProjectContext.currentProjectId);
        entity.setName(info.getName());
        entity.setDescription(info.getRemark());
        entity.setTitle(info.getTitle());
        entity.setDefaultStatus(1);
        info.setId(projectId);
        ProjectContext.execution.update(entity);
        return ResponseBody.success(null);
    }

    public void updateChildrenShow(Map m) {
        Set keySet = m.keySet();
        for (String key : keySet) {
            if (!Map.class.isAssignableFrom(m.get(key).getClass())) continue;
            Map valMap = (Map)m.get(key);
            this.updateShow(valMap);
        }
    }

    public void updateShow(Map map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        if (map.containsKey("show")) {
            map.put("show", 0);
        }
        if (!map.containsKey("children")) {
            return;
        }
        Object object = map.get("children");
        if (Collection.class.isAssignableFrom(object.getClass()) || object.getClass().isArray()) {
            List<Map> jsonToList = JsonUtil.jsonToList(JsonUtil.beanToJson(object), Map.class);
            for (Map map2 : jsonToList) {
                this.updateChildrenShow(map2);
            }
            map.put("children", jsonToList);
        } else {
            Map<String, Object> m = JsonUtil.jsonToMap(JsonUtil.beanToJson(object));
            this.updateChildrenShow(m);
            map.put("children", m);
        }
    }

    private void sycnFile(SyncFileBean bean) {
        HttpUtil util = new HttpUtil(bean.getAddress());
        util.setRequestMethod("POST");
        util.setFormRequestParam(bean);
        try {
            util.doUrl();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class TemporaryHttpEntity
    extends HttpEntity {
        private int type;

        TemporaryHttpEntity() {
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }
}

