/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.filter.model;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.common.CustomRemarkEnum;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.filter.ReadBeanApiFilter;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.util.AnnotationUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.springframework.web.multipart.MultipartFile;

public class DefaultReadBeanApi
extends ReadBeanApiFilter {
    @Override
    public JavaType type(Class aClass, GenericTypeBind bind, Type type) {
        if (type.equals(BigDecimal.class)) {
            return JavaType.Long;
        }
        if (type.equals(Date.class) || type.equals(java.sql.Date.class) || type.equals(LocalDate.class) || type.equals(LocalDateTime.class)) {
            return JavaType.Long;
        }
        if (type instanceof Class && MultipartFile.class.isAssignableFrom((Class)type)) {
            return JavaType.File;
        }
        return JavaType.getJavaTypeByType(type);
    }

    @Override
    public Type parseType(Class aClass, GenericTypeBind bind, Type type) {
        return type;
    }

    @Override
    public Class parseClass(Class aClass, GenericTypeBind bind) {
        return aClass;
    }

    @Override
    public String comments(Class aClass, GenericTypeBind bind, Field field) {
        Object value;
        ApidocComment api = field.getDeclaredAnnotation(ApidocComment.class);
        if (api != null && !StringUtil.isEmpty(api.value())) {
            return api.value();
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiModelProperty", field.getAnnotations());
        if (annotation != null && !StringUtil.isEmpty(value = AnnotationUtil.getAnnotationValue(annotation, "value"))) {
            return value.toString();
        }
        return null;
    }

    @Override
    public String parseMock(String template) {
        if (StringUtil.isEmpty(template)) {
            return "";
        }
        return CustomRemarkEnum.getExample(template);
    }

    @Override
    public String mockTemplate(Class aClass, GenericTypeBind bind, Field field) {
        Object example;
        ApidocComment api = field.getDeclaredAnnotation(ApidocComment.class);
        if (api != null && !StringUtil.isEmpty(api.mockValue())) {
            return api.mockValue();
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiModelProperty", field.getAnnotations());
        if (annotation != null && !StringUtil.isEmpty(example = AnnotationUtil.getAnnotationValue(annotation, "example"))) {
            return example.toString();
        }
        return "";
    }

    @Override
    public boolean required(Class aClass, GenericTypeBind bind, Field field) {
        ApidocComment api = field.getDeclaredAnnotation(ApidocComment.class);
        if (api != null) {
            return api.required();
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiModelProperty", field.getAnnotations());
        if (annotation != null) {
            Object required = AnnotationUtil.getAnnotationValue(annotation, "required");
            return (Boolean)required;
        }
        return false;
    }

    @Override
    public boolean hidden(Class aClass, GenericTypeBind bind, Field field) {
        ApidocComment api = field.getDeclaredAnnotation(ApidocComment.class);
        if (api != null) {
            return api.hidden();
        }
        Annotation annotation = AnnotationUtil.getByAnnotationName("io.swagger.annotations.ApiModelProperty", field.getAnnotations());
        if (annotation != null) {
            Object hidden = AnnotationUtil.getAnnotationValue(annotation, "hidden");
            return (Boolean)hidden;
        }
        return false;
    }

    @Override
    public boolean ignore(Class aClass, GenericTypeBind bind, Field field) {
        if (field.getType().isAssignableFrom(Serializable.class) && field.getGenericType() == null) {
            return true;
        }
        if (field.getName().equals("serialVersionUID")) {
            return true;
        }
        if (field.getName().startsWith("java.") || field.getName().startsWith("sun.")) {
            return true;
        }
        ApidocComment api = field.getDeclaredAnnotation(ApidocComment.class);
        if (api != null) {
            return api.ignore();
        }
        return field.getType().equals(Class.class);
    }
}

