/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easySql.util;

import cn.easyutil.easySql.EasySqlExecution;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MysqlFieldParseToJavaBeanUtil {
    private String Field;
    private String Type;
    private String Comment;
    private boolean addSwaggerAnnotation = false;
    private boolean formatToHump = false;
    private boolean addComment = false;
    private String baseName;
    private String beanPackage;
    private String beanPath;
    private String beanName;
    private String mapperPackage;
    private String mapperPath;
    private String mapperName;
    private String xmlPath;
    private String xmlName;
    private String servicePackage;
    private String servicePath;
    private String serviceName;
    private String serviceImplPackage;
    private String serviceImplPath;
    private String serviceImplName;
    private boolean useYifeiCore = false;
    private List<String> ignoreFields = new ArrayList<String>();
    private EasySqlExecution easySqlExecution;
    private List<MysqlFieldParseToJavaBeanUtil> mysqlFields;
    private Map<String, List<AnnotationBuild>> costomAnnotations = new HashMap<String, List<AnnotationBuild>>();

    public static MysqlFieldParseToJavaBeanUtil queryFields(String tableName, String url, String username, String password) {
        MysqlFieldParseToJavaBeanUtil util = new MysqlFieldParseToJavaBeanUtil();
        util.easySqlExecution = new EasySqlExecution(url, username, password);
        return MysqlFieldParseToJavaBeanUtil.queryFields(tableName, util.easySqlExecution);
    }

    public static MysqlFieldParseToJavaBeanUtil queryFields(String tableName, Connection connection) {
        MysqlFieldParseToJavaBeanUtil util = new MysqlFieldParseToJavaBeanUtil();
        util.easySqlExecution = new EasySqlExecution(connection);
        return MysqlFieldParseToJavaBeanUtil.queryFields(tableName, util.easySqlExecution);
    }

    public static MysqlFieldParseToJavaBeanUtil queryFields(String tableName, EasySqlExecution easySqlExecution) {
        MysqlFieldParseToJavaBeanUtil util = new MysqlFieldParseToJavaBeanUtil();
        util.easySqlExecution = easySqlExecution;
        util.mysqlFields = util.easySqlExecution.customQuery("show full fields from " + tableName, MysqlFieldParseToJavaBeanUtil.class);
        if (util.mysqlFields == null || util.mysqlFields.isEmpty()) {
            throw new RuntimeException("\u6570\u636e\u5e93\u8868:" + tableName + " \u65e0\u5b57\u6bb5");
        }
        util.baseName = util.conversionCamelCase(tableName);
        String first = new String(new char[]{util.baseName.charAt(0)}).toUpperCase();
        util.baseName = first + util.baseName.substring(1);
        return util;
    }

    public String getField() {
        return this.Field;
    }

    public void setField(String field) {
        this.Field = field;
    }

    public String getType() {
        return this.Type;
    }

    public void setType(String type) {
        this.Type = type;
    }

    public String getComment() {
        return this.Comment;
    }

    public void setComment(String comment) {
        this.Comment = comment;
    }

    public MysqlFieldParseToJavaBeanUtil addCostomAnnotation(String annotation, String annotationField) {
        return this.addCostomAnnotation(annotation, AnnotationBuild.build(annotationField, TableFieldDetail.TABLE_FIELD_NAME, new boolean[0]));
    }

    public MysqlFieldParseToJavaBeanUtil addCostomAnnotation(String annotation, AnnotationBuild ... build) {
        if (this.costomAnnotations.get(annotation) == null) {
            this.costomAnnotations.put(annotation, new ArrayList());
        }
        if (build.length == 0) {
            build = new AnnotationBuild[]{AnnotationBuild.build("value", TableFieldDetail.TABLE_FIELD_NAME, new boolean[0])};
        }
        for (AnnotationBuild bu : build) {
            this.costomAnnotations.get(annotation).add(AnnotationBuild.build(bu.getAnnotationField(), bu.getValue(), bu.isToUpperCase()));
        }
        return this;
    }

    public MysqlFieldParseToJavaBeanUtil addCostomAnnotation(String annotation) {
        return this.addCostomAnnotation(annotation, "value");
    }

    public MysqlFieldParseToJavaBeanUtil addSwaggerAnnotation() {
        this.addSwaggerAnnotation = true;
        return this;
    }

    public MysqlFieldParseToJavaBeanUtil addComment() {
        this.addComment = true;
        return this;
    }

    public MysqlFieldParseToJavaBeanUtil addIgnore(String ... fieldName) {
        if (fieldName.length > 0) {
            this.ignoreFields.addAll(Arrays.asList(fieldName));
        }
        return this;
    }

    public MysqlFieldParseToJavaBeanUtil formatToHump() {
        this.formatToHump = true;
        return this;
    }

    public MysqlFieldParseToJavaBeanUtil buildJavaBean(String beanPath, String beanPackage, String beanName) {
        this.beanPackage = beanPackage;
        this.beanName = beanName;
        this.beanPath = beanPath;
        return this;
    }

    public MysqlFieldParseToJavaBeanUtil buildJavaBean(String classFullName) {
        if (!classFullName.contains(".")) {
            throw new RuntimeException("\u8bf7\u4f20\u5165\u5305\u540d+\u7c7b\u540d");
        }
        String className = classFullName.substring(classFullName.lastIndexOf(".") + 1);
        String packageName = classFullName.substring(0, classFullName.lastIndexOf("."));
        String packagePath = "";
        try {
            File file = new File("");
            String filePath = file.getCanonicalPath() + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
            packagePath = filePath + packageName.replace(".", File.separator);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.buildJavaBean(packagePath, packageName, className);
    }

    public MysqlFieldParseToJavaBeanUtil buildMapperBean(String mapperPath, String mapperPackage, String mapperName) {
        this.mapperPackage = mapperPackage;
        this.mapperName = mapperName;
        this.mapperPath = mapperPath;
        return this;
    }

    public MysqlFieldParseToJavaBeanUtil buildMapperBean(String classFullName) {
        if (!classFullName.contains(".")) {
            throw new RuntimeException("\u8bf7\u4f20\u5165\u5305\u540d+\u7c7b\u540d");
        }
        String className = classFullName.substring(classFullName.lastIndexOf(".") + 1);
        String packageName = classFullName.substring(0, classFullName.lastIndexOf("."));
        String packagePath = "";
        try {
            File file = new File("");
            String filePath = file.getCanonicalPath() + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
            packagePath = filePath + packageName.replace(".", File.separator);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.buildMapperBean(packagePath, packageName, className);
    }

    public MysqlFieldParseToJavaBeanUtil buildMapperXml(String xmlPath, String xmlName) {
        this.xmlName = xmlName;
        this.xmlPath = xmlPath;
        return this;
    }

    public MysqlFieldParseToJavaBeanUtil buildMapperXml(String classFullName) {
        if (!classFullName.contains(".")) {
            throw new RuntimeException("\u8bf7\u4f20\u5165\u5305\u540d+\u7c7b\u540d");
        }
        String className = classFullName.substring(classFullName.lastIndexOf(".") + 1);
        String packageName = classFullName.substring(0, classFullName.lastIndexOf("."));
        String packagePath = "";
        try {
            File file = new File("");
            String filePath = file.getCanonicalPath() + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
            packagePath = filePath + packageName.replace(".", File.separator);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.buildMapperXml(packagePath, className);
    }

    public MysqlFieldParseToJavaBeanUtil buildServiceBean(String servicePath, String servicePackage, String serviceName) {
        this.servicePackage = servicePackage;
        this.serviceName = serviceName;
        this.servicePath = servicePath;
        return this;
    }

    public MysqlFieldParseToJavaBeanUtil buildServiceBean(String classFullName) {
        if (!classFullName.contains(".")) {
            throw new RuntimeException("\u8bf7\u4f20\u5165\u5305\u540d+\u7c7b\u540d");
        }
        String className = classFullName.substring(classFullName.lastIndexOf(".") + 1);
        String packageName = classFullName.substring(0, classFullName.lastIndexOf("."));
        String packagePath = "";
        try {
            File file = new File("");
            String filePath = file.getCanonicalPath() + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
            packagePath = filePath + packageName.replace(".", File.separator);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.buildServiceBean(packagePath, packageName, className);
    }

    public MysqlFieldParseToJavaBeanUtil buildServiceImplBean(String implPath, String implPackage, String implName) {
        this.serviceImplPackage = implPackage;
        this.serviceImplName = implName;
        this.serviceImplPath = implPath;
        return this;
    }

    public MysqlFieldParseToJavaBeanUtil buildServiceImplBean(String classFullName) {
        if (!classFullName.contains(".")) {
            throw new RuntimeException("\u8bf7\u4f20\u5165\u5305\u540d+\u7c7b\u540d");
        }
        String className = classFullName.substring(classFullName.lastIndexOf(".") + 1);
        String packageName = classFullName.substring(0, classFullName.lastIndexOf("."));
        String packagePath = "";
        try {
            File file = new File("");
            String filePath = file.getCanonicalPath() + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
            packagePath = filePath + packageName.replace(".", File.separator);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.buildServiceImplBean(packagePath, packageName, className);
    }

    public MysqlFieldParseToJavaBeanUtil buildYifeiExample(String basePackagePath) {
        if (basePackagePath.contains(".")) {
            try {
                File file = new File("");
                String filePath = file.getCanonicalPath() + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator;
                basePackagePath = filePath + basePackagePath.replace(".", File.separator);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.beanPath == null) {
            this.beanPath = basePackagePath + File.separator + "bean";
        }
        if (this.mapperPath == null) {
            this.mapperPath = basePackagePath + File.separator + "mapper";
        }
        if (this.xmlPath == null) {
            this.xmlPath = basePackagePath + File.separator + "mapper" + File.separator + "xml";
        }
        if (this.servicePath == null) {
            this.servicePath = basePackagePath + File.separator + "service";
        }
        if (this.serviceImplPath == null) {
            this.serviceImplPath = basePackagePath + File.separator + "service" + File.separator + "impl";
        }
        this.formatToHump = true;
        this.addSwaggerAnnotation();
        this.addIgnore("id", "create_time", "update_time", "deleted");
        this.addCostomAnnotation("TableField");
        this.useYifeiCore = true;
        return this;
    }

    private StringBuffer createJavaBeanTitle(StringBuffer sb) {
        if (this.beanPackage == null) {
            if (this.beanPath == null) {
                return sb;
            }
            String basePackage = this.beanPath.replace(File.separator, ".");
            this.beanPackage = basePackage.substring(basePackage.indexOf("java.") + 5);
        }
        sb.append("package " + this.beanPackage + ";" + this.newline());
        if (this.useYifeiCore) {
            sb.append("import com.yifei.core.bean.BizBean;" + this.newline());
            sb.append("import com.yifei.core.sqlExecuter.annotation.TableField;" + this.newline());
            sb.append("import io.swagger.annotations.ApiModel;" + this.newline());
            sb.append("import io.swagger.annotations.ApiModelProperty;" + this.newline());
            sb.append(this.newline());
            sb.append("@ApiModel()" + this.newline());
            sb.append("public class " + this.beanName + " extends BizBean {" + this.newline());
        } else {
            sb.append("public class " + this.beanName + " {" + this.newline());
        }
        return sb;
    }

    private StringBuffer createMapperBean(StringBuffer sb) {
        if (this.mapperPackage == null) {
            if (this.mapperPath == null) {
                return sb;
            }
            String basePackage = this.mapperPath.replace(File.separator, ".");
            this.mapperPackage = basePackage.substring(basePackage.indexOf("java.") + 5);
        }
        sb.append("package " + this.mapperPackage + ";" + this.newline());
        if (this.useYifeiCore) {
            sb.append("import com.yifei.core.service.BaseMapper;" + this.newline());
            sb.append("import " + this.beanPackage + "." + this.beanName + ";" + this.newline());
            sb.append(this.newline());
            sb.append("public interface " + this.mapperName + " extends BaseMapper<" + this.beanName + "> {" + this.newline());
        } else {
            sb.append("public interface " + this.mapperName + " {" + this.newline());
        }
        return sb;
    }

    private StringBuffer createServiceBean(StringBuffer sb) {
        if (this.servicePackage == null) {
            if (this.servicePath == null) {
                return sb;
            }
            String basePackage = this.servicePath.replace(File.separator, ".");
            this.servicePackage = basePackage.substring(basePackage.indexOf("java.") + 5);
        }
        sb.append("package " + this.servicePackage + ";" + this.newline());
        if (this.useYifeiCore) {
            sb.append("import com.yifei.core.service.BaseService;" + this.newline());
            sb.append("import " + this.beanPackage + "." + this.beanName + ";" + this.newline());
            sb.append(this.newline());
            sb.append("public interface " + this.serviceName + " extends BaseService<" + this.beanName + "> {" + this.newline());
        } else {
            sb.append("public interface " + this.serviceName + " {" + this.newline());
        }
        return sb;
    }

    private StringBuffer createImplBean(StringBuffer sb) {
        if (this.serviceImplPackage == null) {
            if (this.serviceImplPath == null) {
                return sb;
            }
            String basePackage = this.serviceImplPath.replace(File.separator, ".");
            this.serviceImplPackage = basePackage.substring(basePackage.indexOf("java.") + 5);
        }
        sb.append("package " + this.serviceImplPackage + ";" + this.newline());
        sb.append("import org.springframework.beans.factory.annotation.Autowired;" + this.newline());
        sb.append("import org.springframework.stereotype.Service;" + this.newline());
        if (this.useYifeiCore) {
            sb.append("import com.yifei.core.service.BaseMapper;" + this.newline());
            sb.append("import com.yifei.core.service.BaseServiceImpl;" + this.newline());
        }
        sb.append("import " + this.beanPackage + "." + this.beanName + ";" + this.newline());
        sb.append("import " + this.mapperPackage + "." + this.mapperName + ";" + this.newline());
        sb.append("import " + this.servicePackage + "." + this.serviceName + ";" + this.newline());
        sb.append(this.newline());
        sb.append("@Service" + this.newline());
        if (this.useYifeiCore) {
            sb.append("public class " + this.serviceImplName + " extends BaseServiceImpl<" + this.beanName + "> implements " + this.serviceName + "{");
        } else {
            sb.append("public class " + this.serviceImplName + " implements " + this.serviceName + "{");
        }
        sb.append(this.newline());
        sb.append(this.tab() + "@Autowired");
        sb.append(this.newline());
        String mapperBeanName = new String(new char[]{this.mapperName.charAt(0)}).toLowerCase() + this.mapperName.substring(1);
        sb.append(this.tab() + "private " + this.mapperName + " " + mapperBeanName + ";");
        sb.append(this.newline());
        if (this.useYifeiCore) {
            sb.append(this.tab() + "@Override");
            sb.append(this.newline());
            sb.append(this.tab() + "protected BaseMapper<" + this.beanName + "> getMainMapper() {");
            sb.append(this.newline());
            sb.append(this.tab() + this.tab() + "return " + mapperBeanName + ";");
            sb.append(this.newline());
            sb.append(this.tab() + "}");
            sb.append(this.newline());
        }
        return sb;
    }

    private StringBuffer createXml(StringBuffer sb) {
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE mapper PUBLIC \"-//mybatis.org//DTD Mapper 3.0//EN\" \"http://mybatis.org/dtd/mybatis-3-mapper.dtd\">");
        sb.append(this.newline());
        sb.append("<mapper namespace=\"" + this.mapperPackage + "." + this.mapperName + "\">");
        sb.append(this.newline());
        String xmlContext = "<select id=\"listPage\" parameterType=\"BackUserBean\" resultType=\"BackUserBean\">\r\n    </select>\r\n\r\n    <select id=\"get\" parameterType=\"BackUserBean\" resultType=\"BackUserBean\">\r\n    </select>\r\n\r\n    <delete id=\"delete\" parameterType=\"BackUserBean\">\r\n    </delete>\r\n\r\n    <insert id=\"add\" parameterType=\"BackUserBean\" keyProperty=\"id\" useGeneratedKeys=\"true\">\r\n    </insert>\r\n\r\n    <update id=\"update\" parameterType=\"BackUserBean\">\r\n    </update>\r\n\r\n    <select id=\"select\" parameterType=\"BackUserBean\" resultType=\"BackUserBean\">\r\n    </select>\r\n\r\n    <select id=\"count\" parameterType=\"BackUserBean\" resultType=\"Integer\">\r\n    </select>\r\n    \r\n</mapper>";
        sb.append(xmlContext.replace("BackUserBean", this.beanName));
        return sb;
    }

    private void createFile(String basePackage, StringBuffer sb) {
        File file = new File(basePackage);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            out.write(sb.toString().getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void unBuild() {
        this.unBuild(true, true, true, true, true);
    }

    public void unBuild(boolean delJavaBeanFile, boolean delMapperFile, boolean delXmlFile, boolean delServiceFile, boolean delImplFile) {
        File file;
        this.build(false);
        if (delJavaBeanFile && this.beanPath != null) {
            file = new File(this.beanPath + File.separator + this.beanName + ".java");
            if (!file.exists()) {
                throw new RuntimeException("javaBean\u6587\u4ef6:" + file.getPath() + "\u672a\u627e\u5230");
            }
            file.delete();
        }
        if (delMapperFile && this.mapperPath != null) {
            file = new File(this.mapperPath + File.separator + this.mapperName + ".java");
            if (!file.exists()) {
                throw new RuntimeException("mapper\u6587\u4ef6:" + file.getPath() + "\u672a\u627e\u5230");
            }
            file.delete();
        }
        if (delXmlFile && this.xmlPath != null) {
            file = new File(this.xmlPath + File.separator + this.xmlName + ".xml");
            if (!file.exists()) {
                throw new RuntimeException("xml\u6587\u4ef6:" + file.getPath() + "\u672a\u627e\u5230");
            }
            file.delete();
        }
        if (delServiceFile && this.servicePath != null) {
            file = new File(this.servicePath + File.separator + this.serviceName + ".java");
            if (!file.exists()) {
                throw new RuntimeException("service\u6587\u4ef6:" + file.getPath() + "\u672a\u627e\u5230");
            }
            file.delete();
        }
        if (delImplFile && this.serviceImplPath != null) {
            file = new File(this.serviceImplPath + File.separator + this.serviceImplName + ".java");
            if (!file.exists()) {
                throw new RuntimeException("serviceImpl\u6587\u4ef6:" + file.getPath() + "\u672a\u627e\u5230");
            }
            file.delete();
        }
    }

    public String build(boolean createFile) {
        return this.build(createFile, createFile, createFile, createFile, createFile);
    }

    public String build(boolean createJavaBeanFile, boolean createMapperFile, boolean createXmlFile, boolean createServiceFile, boolean createImplFile) {
        File file;
        if (this.mysqlFields == null || this.mysqlFields.size() == 0) {
            throw new RuntimeException("\u8bf7\u5148\u6267\u884c queryFields(String tableName) \u65b9\u6cd5");
        }
        StringBuffer javaBeanSb = new StringBuffer();
        if (this.beanName == null) {
            this.beanName = this.baseName + "Bean";
        }
        javaBeanSb = this.createJavaBeanTitle(javaBeanSb);
        StringBuffer mapperSb = new StringBuffer();
        if (this.mapperName == null) {
            this.mapperName = this.baseName + "Mapper";
        }
        mapperSb = this.createMapperBean(mapperSb);
        StringBuffer xmlSb = new StringBuffer();
        if (this.xmlName == null) {
            this.xmlName = this.baseName + "Mapper";
        }
        xmlSb = this.createXml(xmlSb);
        StringBuffer serviceSb = new StringBuffer();
        if (this.serviceName == null) {
            this.serviceName = this.baseName + "Service";
        }
        serviceSb = this.createServiceBean(serviceSb);
        StringBuffer implSb = new StringBuffer();
        if (this.serviceImplName == null) {
            this.serviceImplName = this.baseName + "ServiceImpl";
        }
        implSb = this.createImplBean(implSb);
        for (MysqlFieldParseToJavaBeanUtil field : this.mysqlFields) {
            if (this.ignoreFields.contains(field.Field)) continue;
            javaBeanSb.append(this.newline());
            if (this.addComment) {
                javaBeanSb.append(this.tab() + "/** " + field.Comment + "*/" + this.newline());
            }
            if (this.addSwaggerAnnotation) {
                javaBeanSb.append(this.tab() + "@ApiModelProperty(\"" + field.Comment + "\")" + this.newline());
            }
            if (this.costomAnnotations.size() > 0) {
                Set<Map.Entry<String, List<AnnotationBuild>>> entrySet = this.costomAnnotations.entrySet();
                for (Map.Entry<String, List<AnnotationBuild>> entry : entrySet) {
                    String annotation = entry.getKey();
                    List<AnnotationBuild> annotationValues = entry.getValue();
                    javaBeanSb.append(this.tab() + "@" + annotation + "(");
                    for (AnnotationBuild annotationValue : annotationValues) {
                        String anv = field.Field;
                        switch (annotationValue.value) {
                            case TABLE_FIELD_COMMENT: {
                                anv = field.Comment;
                                break;
                            }
                            case TABLE_FIELD_TYPE: {
                                anv = field.Type;
                                if (!anv.contains("(") || !anv.contains(")")) break;
                                anv = anv.substring(0, anv.indexOf("("));
                                break;
                            }
                        }
                        if (annotationValue.toUpperCase) {
                            anv = anv.toUpperCase();
                        }
                        javaBeanSb.append(annotationValue.getAnnotationField() + "=\"" + anv + "\",");
                    }
                    if (javaBeanSb.toString().endsWith(",")) {
                        javaBeanSb.deleteCharAt(javaBeanSb.length() - 1);
                    }
                    javaBeanSb.append(")" + this.newline());
                }
            }
            javaBeanSb.append(this.tab() + "private " + this.mysqlTypeToJavaType(field.Type));
            if (this.formatToHump) {
                javaBeanSb.append(" " + this.conversionCamelCase(field.Field) + ";");
            } else {
                javaBeanSb.append(" " + field.Field + ";");
            }
            javaBeanSb.append(this.newline());
        }
        javaBeanSb.append(this.newline());
        javaBeanSb.append("}");
        mapperSb.append(this.newline());
        mapperSb.append("}");
        serviceSb.append(this.newline());
        serviceSb.append("}");
        implSb.append(this.newline());
        implSb.append("}");
        if (createJavaBeanFile && this.beanPath != null) {
            file = new File(this.beanPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            this.createFile(this.beanPath + File.separator + this.beanName + ".java", javaBeanSb);
        }
        if (createMapperFile && this.mapperPath != null) {
            file = new File(this.mapperPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            this.createFile(this.mapperPath + File.separator + this.mapperName + ".java", mapperSb);
        }
        if (createXmlFile && this.xmlPath != null) {
            file = new File(this.xmlPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            this.createFile(this.xmlPath + File.separator + this.xmlName + ".xml", xmlSb);
        }
        if (createServiceFile && this.servicePath != null) {
            file = new File(this.servicePath);
            if (!file.exists()) {
                file.mkdirs();
            }
            this.createFile(this.servicePath + File.separator + this.serviceName + ".java", serviceSb);
        }
        if (createImplFile && this.serviceImplPath != null) {
            file = new File(this.serviceImplPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            this.createFile(this.serviceImplPath + File.separator + this.serviceImplName + ".java", implSb);
        }
        StringBuffer all = new StringBuffer();
        all.append(javaBeanSb.toString());
        all.append(this.newline());
        all.append("=================================================================");
        all.append(this.newline());
        all.append(mapperSb.toString());
        all.append(this.newline());
        all.append("=================================================================");
        all.append(this.newline());
        all.append(xmlSb.toString());
        all.append(this.newline());
        all.append("=================================================================");
        all.append(this.newline());
        all.append(serviceSb.toString());
        all.append(this.newline());
        all.append("=================================================================");
        all.append(this.newline());
        all.append(implSb.toString());
        return all.toString();
    }

    private String mysqlTypeToJavaType(String mysqlType) {
        String type = mysqlType.toUpperCase().trim();
        if (type.startsWith("INT") || type.startsWith("INTEGER") || type.startsWith("TINYINT") || type.startsWith("SMALLINT") || type.startsWith("MEDIUMINT")) {
            return "Integer";
        }
        if (type.startsWith("BIGINT")) {
            return "Long";
        }
        if (type.startsWith("DOUBLE")) {
            return "Double";
        }
        if (type.startsWith("FLOAT")) {
            return "Float";
        }
        if (type.startsWith("DECIMAL")) {
            return "BigDecimal";
        }
        if (type.startsWith("DATE") || type.startsWith("YEAR")) {
            return "Date";
        }
        if (type.startsWith("TIME")) {
            return "Time";
        }
        if (type.startsWith("DATATIME")) {
            return "Timestamp";
        }
        return "String";
    }

    private String conversionCamelCase(String v) {
        int index = v.indexOf("_");
        while (index != -1) {
            v = v.replace(v.substring(index, index + 2), v.substring(index + 1, index + 2).toUpperCase());
            index = v.indexOf("_");
        }
        return v;
    }

    private String newline() {
        return " \n";
    }

    private String tab() {
        return " \t";
    }

    static enum TableFieldDetail {
        TABLE_FIELD_NAME,
        TABLE_FIELD_COMMENT,
        TABLE_FIELD_TYPE;

    }

    static class AnnotationBuild {
        private String annotationField;
        private TableFieldDetail value;
        private boolean toUpperCase = false;

        AnnotationBuild() {
        }

        public static AnnotationBuild build(String annotationField, TableFieldDetail value, boolean ... toUpperCase) {
            AnnotationBuild build = new AnnotationBuild();
            build.annotationField = annotationField;
            build.value = value;
            if (toUpperCase.length > 0) {
                build.toUpperCase = toUpperCase[0];
            }
            return build;
        }

        public String getAnnotationField() {
            return this.annotationField;
        }

        public TableFieldDetail getValue() {
            return this.value;
        }

        public boolean isToUpperCase() {
            return this.toUpperCase;
        }
    }
}

