/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easySql.util;

import cn.easyutil.easySql.annotations.TableField;
import cn.easyutil.easySql.util.LambdaFunction;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class LamdbaUtil {
    public static <T> String getFieldName(LambdaFunction<T, ?> fun) {
        return LamdbaUtil.getFieldName(fun, true);
    }

    public static <T> String getFieldName(LambdaFunction<T, ?> fun, boolean conver) {
        Field field = LamdbaUtil.getField(fun);
        if (field == null) {
            return null;
        }
        TableField an = field.getDeclaredAnnotation(TableField.class);
        if (an != null) {
            if (an.value() != null && an.value().length() > 0) {
                return an.value();
            }
            if (an.name() != null && an.name().length() > 0) {
                return an.name();
            }
        }
        if (conver) {
            return LamdbaUtil.conversionMapUnderscore(field.getName());
        }
        return field.getName();
    }

    private static <T, R> Field getField(LambdaFunction<T, R> fun) {
        SerializedLambda lambda = LamdbaUtil.getSerializedLambda(fun);
        String methodName = lambda.getImplMethodName();
        String fieldName = null;
        if (methodName.startsWith("get")) {
            fieldName = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            fieldName = methodName.substring(2);
        }
        if (fieldName == null) {
            return null;
        }
        fieldName = fieldName.toUpperCase();
        String className = lambda.getImplClass().replace("/", ".");
        Object field = null;
        try {
            Class<?> aClass;
            for (Class<?> clazz = aClass = Class.forName(className); clazz != Object.class; clazz = clazz.getSuperclass()) {
                Field[] fields;
                for (Field f : fields = aClass.getDeclaredFields()) {
                    if (!f.getName().toUpperCase().equals(fieldName)) continue;
                    return f;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static SerializedLambda getSerializedLambda(Serializable fn) {
        try {
            Method method = fn.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            return (SerializedLambda)method.invoke((Object)fn, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String conversionMapUnderscore(String v) {
        String str = "";
        for (int i = 0; i < v.toCharArray().length; ++i) {
            char c = v.toCharArray()[i];
            if (i == 0) {
                c = Character.toLowerCase(c);
            } else if (Character.isUpperCase(c)) {
                str = str + "_" + Character.toLowerCase(c);
                continue;
            }
            str = str + c;
        }
        return str;
    }
}

