/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easySql.config;

import cn.easyutil.easySql.util.LoggerUtil;
import cn.easyutil.easySql.util.YamlUitl;
import com.alibaba.druid.pool.DruidDataSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public class EasySqlConfiguration {
    public static DataSource dataSource;
    private static Map<String, String> propers;
    private static ConcurrentHashMap<String, DataSource> dataSourceMap;
    public static String url;
    public static String username;
    public static String password;

    public static DataSource getDataSourceMapValue(String flag) {
        return dataSourceMap.get(flag);
    }

    public static void setDataSourceMapValue(String flag, DataSource dataSource) {
        if (dataSource == null) {
            dataSourceMap.put(flag, (DataSource)new EasySqlConfiguration().dataSource(null));
        } else {
            dataSourceMap.put(flag, dataSource);
        }
    }

    public DruidDataSource dataSource(String propertiesName) {
        if (url != null && username != null && password != null) {
            propers.put("url", url);
            propers.put("username", username);
            propers.put("password", password);
        } else if (propertiesName == null || propertiesName.length() == 0) {
            this.loadResource();
        } else if (propertiesName.endsWith("yaml")) {
            this.loadYaml(propertiesName);
        } else if (propertiesName.endsWith("properties")) {
            this.loadPropertites(propertiesName);
        }
        if (propers.get("url") == null || propers.get("username") == null || propers.get("password") == null) {
            throw new RuntimeException("JDBC config not found in " + propertiesName);
        }
        url = propers.get("url");
        username = propers.get("username");
        password = propers.get("password");
        LoggerUtil.info(this.getClass(), "\u8bfb\u53d6\u5230\u914d\u7f6e\u6587\u4ef6\u7684username=" + propers.get("username"));
        LoggerUtil.info(this.getClass(), "\u8bfb\u53d6\u5230\u914d\u7f6e\u6587\u4ef6\u7684password=" + propers.get("password"));
        LoggerUtil.info(this.getClass(), "\u8bfb\u53d6\u5230\u914d\u7f6e\u6587\u4ef6\u7684url=" + propers.get("url"));
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(propers.get("url"));
        dataSource.setUsername(propers.get("username"));
        dataSource.setPassword(propers.get("password"));
        dataSource.setInitialSize(2);
        dataSource.setMaxActive(20);
        dataSource.setMinIdle(0);
        dataSource.setMaxWait(60000L);
        dataSource.setValidationQuery("SELECT 1");
        dataSource.setTestOnBorrow(false);
        dataSource.setTestWhileIdle(true);
        dataSource.setPoolPreparedStatements(false);
        dataSource.setRemoveAbandoned(true);
        dataSource.setRemoveAbandonedTimeout(1800);
        Properties properties = dataSource.getConnectProperties();
        properties.put("autoReconnect", "true");
        dataSource.setConnectProperties(properties);
        return dataSource;
    }

    private void loadResource() {
        ArrayList<String> resourceName = new ArrayList<String>();
        resourceName.add("/application.properties");
        resourceName.add("/application.yaml");
        for (String name : resourceName) {
            if (name.endsWith("properties")) {
                try {
                    this.loadPropertites(name);
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                this.loadYaml(name);
            }
            catch (Exception exception) {}
        }
    }

    private void loadYaml(String yamlPath) {
        YamlUitl util = new YamlUitl();
        try {
            Map<String, Object> map = util.readYaml(EasySqlConfiguration.class.getResourceAsStream(yamlPath));
            Set<Map.Entry<String, Object>> set = map.entrySet();
            for (Map.Entry<String, Object> entry : set) {
                this.hasMySqlConfig(entry.getKey(), entry.getValue().toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropertites(String propertiesPath) {
        Properties properties = new Properties();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(EasySqlConfiguration.class.getResourceAsStream(propertiesPath)));
            properties.load(bufferedReader);
            for (Map.Entry<Object, Object> next : properties.entrySet()) {
                String key = next.getKey().toString();
                this.hasMySqlConfig(key, next.getValue().toString());
            }
        }
        catch (Exception e) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                    return;
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                    return;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void listFile(File file) {
        if (propers.get("url") != null && propers.get("username") != null && propers.get("password") != null) {
            return;
        }
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                try {
                    if (f.isFile() && f.getName().endsWith(".properties")) {
                        this.loadPropertites(f.getAbsolutePath());
                    } else if (f.isFile() && f.getName().endsWith(".yaml")) {
                        this.loadYaml(f.getAbsolutePath());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!f.isDirectory()) continue;
                this.listFile(f);
            }
        }
    }

    private void hasMySqlConfig(String key, String value) {
        if ((key = key.toUpperCase()).contains("MYSQL") && key.contains("USER") && key.contains("NAME")) {
            propers.put("username", value);
        } else if (key.contains("DATASOURCE") && key.contains("USER") && key.contains("NAME")) {
            propers.put("username", value);
        } else if (key.contains("JDBC") && key.contains("USER") && key.contains("NAME")) {
            propers.put("username", value);
        }
        if (key.contains("MYSQL") && (key.contains("PASSWORD") || key.contains("PWD"))) {
            propers.put("password", value);
        } else if (key.contains("DATASOURCE") && (key.contains("PASSWORD") || key.contains("PWD"))) {
            propers.put("password", value);
        } else if (key.contains("JDBC") && (key.contains("PASSWORD") || key.contains("PWD"))) {
            propers.put("password", value);
        }
        if (key.contains("MYSQL") && key.contains("URL")) {
            propers.put("url", value);
        } else if (key.contains("DATASOURCE") && key.contains("URL")) {
            propers.put("url", value);
        } else if (key.contains("JDBC") && key.contains("URL")) {
            propers.put("url", value);
        }
        propers.put("driver", "mysql");
        if (key.contains("DRIVER") && key.contains("MYSQL")) {
            propers.put("driver", "mysql");
        }
        if (key.contains("DRIVER") && key.contains("ORACLE")) {
            propers.put("driver", "oracle");
        }
        if (propers.get("url") != null && propers.get("username") != null && propers.get("password") != null) {
            return;
        }
    }

    static {
        propers = new HashMap<String, String>();
        dataSourceMap = new ConcurrentHashMap();
    }
}

