package cn.easyproject.easyshiro;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.LogoutFilter;

/**
 * 能够实现会话安全信息(Subjec/Session)，RememberMe信息和AutoLogin自动登录信息的注销
 * @author Ray
 * @author inthinkcolor@gmail.com
 * @author easyproject.cn
 * @since 1.0.0
 */
public class EasyLogoutFilter extends LogoutFilter{
	
//	 注销时是否注销自动登录信息， true注销时同时清除自动登录信息；false，注销时，仅清除会话安全信息(Subjec/Session)和RememberMe信息，页面直接转向登录页面（不会产生新的自动登录）
//	private String autoLoginClear="true";
	private EasyFormAuthenticationFilter easyFormAuthenticationFilter;
	
	   @Override
	    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
	        Subject subject = getSubject(request, response);
	        String redirectUrl = getRedirectUrl(request, response, subject);
	        //try/catch added for SHIRO-298:
	        
	         subject.logout();
	         
//	         if(EasyShiroUtils.isTrue(autoLoginClear) && easyFormAuthenticationFilter!=null){
//	        	 easyFormAuthenticationFilter.clearAutoLoginCookie(response);
//	         }else{
//	        	 // 如果是登录注销，仅清除会话，不删除自动登录Cookie
//	        	 subject.getSession().setAttribute("EASYSHIRO_DONT_AUTOLOGIN", "true");
//	         }
	         easyFormAuthenticationFilter.clearAutoLoginCookie(response);
	        
	        
	        issueRedirect(request, response, redirectUrl);
	        return false;
	    }

	public void setEasyFormAuthenticationFilter(EasyFormAuthenticationFilter easyFormAuthenticationFilter) {
		this.easyFormAuthenticationFilter = easyFormAuthenticationFilter;
	}

//	public void setAutoLoginClear(String autoLoginClear) {
//		this.autoLoginClear = autoLoginClear;
//	}

	
}
