package cn.easyproject.easyshiro;

import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;

/**
 * EasyJdbcRealm 拦截器，可以认证和授权信息获得后，对SimpleAuthenticationInfo认证和SimpleAuthorizationInfo授权信息进行额外处理
 * @author Ray
 * @author inthinkcolor@gmail.com
 * @author easyproject.cn
 * @since 1.0.0
 */
public interface EasyJdbcRealmInterceptor {

	/**
	 * 认证信息获取后，处理方法，如果返回null，代表获取失败
	 * @param info 认证信息
	 */
	public void afterDoGetAuthenticationInfo(SimpleAuthenticationInfo info);
	
	/**
	 * 授权信息获取后，处理方法，如果返回null，代表获取失败
	 * @param info 认证信息
	 */
	public void afterDoGetAuthorizationInfo(SimpleAuthorizationInfo info);
	
}
