package cn.easyproject.easyshiro;

import org.apache.shiro.authc.UsernamePasswordToken;

/**
 * 带密码加密的 EasyUsernamePasswordToken，扩展了 Shiro 默认的 UsernamePasswordToken
 * @author Ray
 * @author inthinkcolor@gmail.com
 * @author easyproject.cn
 * @since
 */

/**
 * Shiro 用户名密码加密认证Token，扩展了 Shiro 默认的 UsernamePasswordToken <br>
 * 能在使用 EasyJdbcRealm 登录认证时，从数据库查询并初始化自定义的属性。
 * 使用方法：<br>
 * <ol>
 * <li>直接在类中加入数据库相关的列属性</li>
  * <li>重写encodePassword()，使用自定义的加密方式进行密码加密，支持使用数据库列属性值作为salt加密</li>
  * <li>使用 EasyJdbcRealm 在登录认证时，能自动将数据库用户的所有信息，填充到该认证 Token 的扩展属性中</li>
 * </ol>
 * 
 * @author Ray
 * @author inthinkcolor@gmail.com
 * @author easyproject.cn
 * @since 1.0.0
 */
public abstract  class EasyUsernamePasswordEndcodeToken extends UsernamePasswordToken {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public abstract String encodePassword();
}
