package cn.easyproject.easyshiro;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.filter.authz.PermissionsAuthorizationFilter;
import org.apache.shiro.web.util.WebUtils;
/**
 * 基于 URL 规则是否匹配的授权判断，如果权限类别中有该URL字符串，则允许访问，否则不允许
 * 
 * @author Ray
 * @author inthinkcolor@gmail.com
 * @author easyproject.cn
 * @since 1.0.0
 */
public class EasyURLPermissionFilter extends PermissionsAuthorizationFilter {

	// 是否仅需消息存储
	public static final String DEFAULT_SESSION_MSG = "false";
	private String sessionMsg = DEFAULT_SESSION_MSG;
	public static final String DEFAULT_REQUEST_MSG = "false";
	private String requestMsg = DEFAULT_REQUEST_MSG;
	
	// 消息存储和Ajax输出的消息名
	public static final String DEFAULT_MSG_KEY = "msg";
	private String msgKey = DEFAULT_MSG_KEY;
	public static final String DEFAULT_STATUS_CODE_NAME = "statusCode";
	private String statusCode = DEFAULT_STATUS_CODE_NAME;
	
	// 登录检测
	private static final String DEFAULT_AUTHENTICATION_TIMEOUT_CHECK = "true";
	private String authenticationTimeoutCheck = DEFAULT_AUTHENTICATION_TIMEOUT_CHECK;
	
	// 提示的消息内容
	private static final String DEFAULT_PERMISSION_DENIED_MSG = "Permission denied!";
	private String permissionDeniedMsg = DEFAULT_PERMISSION_DENIED_MSG;
	private static final String DEFAULT_AUTHENTICATION_TIMEOUT_MSG = "Your login has expired, please login again!";
	private String authenticationTimeoutMsg = DEFAULT_AUTHENTICATION_TIMEOUT_MSG;

	
	@Override
	public boolean isAccessAllowed(ServletRequest req, ServletResponse rsp, Object mappedValue) throws IOException {
		HttpServletRequest request = (HttpServletRequest) req;
		HttpServletResponse response = (HttpServletResponse) rsp;
		
		// 欲操作 URL 权限为
//		if (request != null && ("XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With"))
//				|| "XMLHttpRequest".equalsIgnoreCase(request.getParameter("xRequestedWith")))) {
//		}
		String permission = request.getRequestURI().substring(request.getContextPath().length() + 1);
//		String permission= WebUtils.getPathWithinApplication(request).substring(1);
		Subject subject = getSubject(request, response);
		if (subject.isPermitted(permission)) {
			return true;
		} else {
			return false;
		}
	}



	@Override
	protected boolean onAccessDenied(ServletRequest req, ServletResponse response) throws IOException {
		HttpServletRequest request = (HttpServletRequest) req;
		
		Subject subject = getSubject(request, response);
		
		// 访问拒绝
		String msg=permissionDeniedMsg;
		int code=HttpServletResponse.SC_UNAUTHORIZED;
//		String locationUrl=(getUnauthorizedUrl()==null?"":getUnauthorizedUrl());
	
		//  登录超时检测
		if(EasyShiroUtils.isTrue(authenticationTimeoutCheck)){
			// 登录超时提示
			if(!subject.isAuthenticated()){
				msg=authenticationTimeoutMsg;
				code=HttpServletResponse.SC_MOVED_PERMANENTLY;
			}
		}
		
		/*
		 * 验证未通过统一处理
		 */
		if (request != null && ("XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With"))
				|| "XMLHttpRequest".equalsIgnoreCase(request.getParameter("xRequestedWith")))) {
			// AJax请求处理
			// 没有权限，返回错误信息，无须存入session和request
			
			response.setCharacterEncoding("UTF-8");
			response.setContentType("text/json;charset=utf-8");
			PrintWriter out = response.getWriter();
//			out.println("{\""+msgKey+"\":\""+msg+"\",\""+statusCode+"\":\""+code+"\", \"locationUrl\":\""+locationUrl+"\"}");
			out.println("{\""+msgKey+"\":\""+msg+"\",\""+statusCode+"\":\""+code+"\"}");
			out.flush();
			out.close();
			
			
//			WebUtils.toHttp(response).sendError(HttpServletResponse.SC_UNAUTHORIZED, "Authentication required");
		} else {

			
			
			// 是否开启消息存入session
			if (EasyShiroUtils.isTrue(sessionMsg)) {
				subject.getSession().setAttribute(msgKey, msg);
			}
			// 是否开启消息存入request
			if (EasyShiroUtils.isTrue(requestMsg)) {
				req.setAttribute(msgKey, msg);
			}
			// If the subject isn't identified, redirect to login URL
			if (subject.getPrincipal() == null) {
				saveRequestAndRedirectToLogin(request, response);
			} else {
				// If subject is known but not authorized, redirect to the
				// unauthorized URL if there is one
				// If no unauthorized URL is specified, just return an
				// unauthorized HTTP status code
				String unauthorizedUrl = getUnauthorizedUrl();
				// SHIRO-142 - ensure that redirect _or_ error code occurs -
				// both cannot happen due to response commit:
				if (StringUtils.hasText(unauthorizedUrl)) {
					WebUtils.issueRedirect(request, response, unauthorizedUrl);
				} else {
					WebUtils.toHttp(response).sendError(HttpServletResponse.SC_UNAUTHORIZED);
				}
			}
		}
		return false;
	}

	
	
	

	public void setSessionMsg(String sessionMsg) {
		this.sessionMsg = sessionMsg;
	}

	public void setRequestMsg(String requestMsg) {
		this.requestMsg = requestMsg;
	}

	public void setMsgKey(String msgKey) {
		this.msgKey = msgKey;
	}

	public void setPermissionDeniedMsg(String permissionDeniedMsg) {
		this.permissionDeniedMsg = permissionDeniedMsg;
	}


	public void setStatusCode(String statusCode) {
		this.statusCode = statusCode;
	}


	public void setAuthenticationTimeoutCheck(String authenticationTimeoutCheck) {
		this.authenticationTimeoutCheck = authenticationTimeoutCheck;
	}


	public void setAuthenticationTimeoutMsg(String authenticationTimeoutMsg) {
		this.authenticationTimeoutMsg = authenticationTimeoutMsg;
	}
	
	
}
