/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easyshiro;

import cn.easyproject.easyshiro.EasyShiroUtils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.filter.authz.PermissionsAuthorizationFilter;
import org.apache.shiro.web.util.WebUtils;

public class EasyURLPermissionFilter
extends PermissionsAuthorizationFilter {
    public static final String DEFAULT_SESSION_MSG = "false";
    private String sessionMsg = "false";
    public static final String DEFAULT_REQUEST_MSG = "false";
    private String requestMsg = "false";
    public static final String DEFAULT_MSG_KEY = "msg";
    private String msgKey = "msg";
    public static final String DEFAULT_STATUS_CODE_NAME = "statusCode";
    private String statusCode = "statusCode";
    private static final String DEFAULT_AUTHENTICATION_TIMEOUT_CHECK = "true";
    private String authenticationTimeoutCheck = "true";
    private static final String DEFAULT_PERMISSION_DENIED_MSG = "Permission denied!";
    private String permissionDeniedMsg = "Permission denied!";
    private static final String DEFAULT_AUTHENTICATION_TIMEOUT_MSG = "Your login has expired, please login again!";
    private String authenticationTimeoutMsg = "Your login has expired, please login again!";

    public boolean isAccessAllowed(ServletRequest req, ServletResponse rsp, Object mappedValue) throws IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)rsp;
        String permission = request.getRequestURI().substring(request.getContextPath().length() + 1);
        Subject subject = this.getSubject((ServletRequest)request, (ServletResponse)response);
        return subject.isPermitted(permission);
    }

    protected boolean onAccessDenied(ServletRequest req, ServletResponse response) throws IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        Subject subject = this.getSubject((ServletRequest)request, response);
        String msg = this.permissionDeniedMsg;
        int code = 401;
        if (EasyShiroUtils.isTrue(this.authenticationTimeoutCheck) && !subject.isAuthenticated()) {
            msg = this.authenticationTimeoutMsg;
            code = 301;
        }
        if (request != null && ("XMLHttpRequest".equalsIgnoreCase(request.getHeader("X-Requested-With")) || "XMLHttpRequest".equalsIgnoreCase(request.getParameter("xRequestedWith")))) {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/json;charset=utf-8");
            PrintWriter out = response.getWriter();
            out.println("{\"" + this.msgKey + "\":\"" + msg + "\",\"" + this.statusCode + "\":\"" + code + "\"}");
            out.flush();
            out.close();
        } else {
            if (EasyShiroUtils.isTrue(this.sessionMsg)) {
                subject.getSession().setAttribute((Object)this.msgKey, (Object)msg);
            }
            if (EasyShiroUtils.isTrue(this.requestMsg)) {
                req.setAttribute(this.msgKey, (Object)msg);
            }
            if (subject.getPrincipal() == null) {
                this.saveRequestAndRedirectToLogin((ServletRequest)request, response);
            } else {
                String unauthorizedUrl = this.getUnauthorizedUrl();
                if (StringUtils.hasText((String)unauthorizedUrl)) {
                    WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)unauthorizedUrl);
                } else {
                    WebUtils.toHttp((ServletResponse)response).sendError(401);
                }
            }
        }
        return false;
    }

    public void setSessionMsg(String sessionMsg) {
        this.sessionMsg = sessionMsg;
    }

    public void setRequestMsg(String requestMsg) {
        this.requestMsg = requestMsg;
    }

    public void setMsgKey(String msgKey) {
        this.msgKey = msgKey;
    }

    public void setPermissionDeniedMsg(String permissionDeniedMsg) {
        this.permissionDeniedMsg = permissionDeniedMsg;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    public void setAuthenticationTimeoutCheck(String authenticationTimeoutCheck) {
        this.authenticationTimeoutCheck = authenticationTimeoutCheck;
    }

    public void setAuthenticationTimeoutMsg(String authenticationTimeoutMsg) {
        this.authenticationTimeoutMsg = authenticationTimeoutMsg;
    }
}

