/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easyshiro;

import cn.easyproject.easyshiro.EasyJdbcRealmInterceptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.jdbc.JdbcRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.JdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyJdbcRealm
extends AuthorizingRealm
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_AUTHENTICATION_QUERY = "select * from users where username = ?";
    protected static final String DEFAULT_USER_ROLES_QUERY = "select role_name from user_roles where username = ?";
    protected static final String DEFAULT_PERMISSIONS_QUERY = "select permission from user_roles_permissions where username = ?";
    protected static final String DEFAULT_PASSWORD_COLUMN = "password";
    private static final Logger log = LoggerFactory.getLogger(JdbcRealm.class);
    protected DataSource dataSource;
    protected String authenticationQuery = "select * from users where username = ?";
    protected String passwordColumn = "password";
    protected String userRolesQuery = "select role_name from user_roles where username = ?";
    protected String permissionsQuery = "select permission from user_roles_permissions where username = ?";
    protected boolean permissionsLookupEnabled = true;
    EasyJdbcRealmInterceptor interceptor;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setAuthenticationQuery(String authenticationQuery) {
        this.authenticationQuery = authenticationQuery;
    }

    public void setUserRolesQuery(String userRolesQuery) {
        this.userRolesQuery = userRolesQuery;
    }

    public void setPermissionsQuery(String permissionsQuery) {
        this.permissionsQuery = permissionsQuery;
    }

    public void setPermissionsLookupEnabled(boolean permissionsLookupEnabled) {
        this.permissionsLookupEnabled = permissionsLookupEnabled;
    }

    public boolean supports(AuthenticationToken token) {
        return super.supports(token);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        String username = upToken.getUsername();
        if (username == null) {
            throw new AccountException("Null usernames are not allowed by this realm.");
        }
        Connection conn = null;
        SimpleAuthenticationInfo info = null;
        try {
            conn = this.dataSource.getConnection();
            String password = null;
            password = this.getUser(conn, username, (AuthenticationToken)upToken);
            if (password == null) {
                throw new UnknownAccountException("No account found for user [" + username + "]");
            }
            info = new SimpleAuthenticationInfo((Object)username, (Object)password.toCharArray(), this.getName());
        }
        catch (SQLException e) {
            String message = "There was a SQL error while authenticating user [" + username + "]";
            if (log.isErrorEnabled()) {
                log.error(message, (Throwable)e);
            }
            throw new AuthenticationException(message, (Throwable)e);
        }
        finally {
            JdbcUtils.closeConnection((Connection)conn);
        }
        if (SecurityUtils.getSubject().getSession().getAttribute((Object)"EasyShiro_AutoLogin") == null) {
            try {
                Method method = upToken.getClass().getMethod("encodePassword", new Class[0]);
                if (method != null) {
                    String encodePwd = method.invoke((Object)upToken, new Object[0]).toString();
                    upToken.setPassword(encodePwd.toCharArray());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.interceptor.afterDoGetAuthenticationInfo(info);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUser(Connection conn, String username, AuthenticationToken token) throws SQLException {
        String password = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Field[] tokenFields = token.getClass().getDeclaredFields();
        try {
            ps = conn.prepareStatement(this.authenticationQuery);
            ps.setString(1, username);
            rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int count = rsmd.getColumnCount();
            boolean foundResult = false;
            while (rs.next()) {
                if (foundResult) {
                    throw new AuthenticationException("More than one user row found for user [" + username + "]. Usernames must be unique.");
                }
                for (int i = 1; i <= count; ++i) {
                    String columnLabel = rsmd.getColumnLabel(i);
                    if (columnLabel.equalsIgnoreCase(this.passwordColumn)) {
                        password = rs.getString(i);
                    }
                    for (int j = 0; j < tokenFields.length; ++j) {
                        if (!columnLabel.equalsIgnoreCase(tokenFields[j].getName())) continue;
                        tokenFields[j].setAccessible(true);
                        try {
                            if (tokenFields[j].getType().isAssignableFrom(String.class)) {
                                tokenFields[j].set(token, rs.getString(i));
                            }
                            if (tokenFields[j].getType().isAssignableFrom(Integer.TYPE) || tokenFields[j].getType().isAssignableFrom(Integer.class)) {
                                tokenFields[j].set(token, rs.getInt(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(Short.TYPE) || tokenFields[j].getType().isAssignableFrom(Short.class)) {
                                tokenFields[j].set(token, rs.getShort(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(Long.TYPE) || tokenFields[j].getType().isAssignableFrom(Long.class)) {
                                tokenFields[j].set(token, rs.getLong(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(Float.TYPE) || tokenFields[j].getType().isAssignableFrom(Float.class)) {
                                tokenFields[j].set(token, rs.getInt(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(Double.TYPE) || tokenFields[j].getType().isAssignableFrom(Double.class)) {
                                tokenFields[j].set(token, rs.getDouble(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(Boolean.TYPE) || tokenFields[j].getType().isAssignableFrom(Boolean.class)) {
                                tokenFields[j].set(token, rs.getBoolean(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(Character.TYPE) || tokenFields[j].getType().isAssignableFrom(Character.class)) {
                                tokenFields[j].set(token, Character.valueOf(rs.getString(i).charAt(0)));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(Byte.TYPE) || tokenFields[j].getType().isAssignableFrom(Byte.class)) {
                                tokenFields[j].set(token, rs.getByte(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(java.util.Date.class) || tokenFields[j].getType().isAssignableFrom(Date.class)) {
                                tokenFields[j].set(token, rs.getDate(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(Time.class)) {
                                tokenFields[j].set(token, rs.getTime(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(String.class)) {
                                tokenFields[j].set(token, rs.getString(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(BigDecimal.class)) {
                                tokenFields[j].set(token, rs.getBigDecimal(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(Blob.class)) {
                                tokenFields[j].set(token, rs.getBlob(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(Clob.class)) {
                                tokenFields[j].set(token, rs.getClob(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(NClob.class)) {
                                tokenFields[j].set(token, rs.getNClob(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(RowId.class)) {
                                tokenFields[j].set(token, rs.getRowId(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(URL.class)) {
                                tokenFields[j].set(token, rs.getURL(i));
                                continue;
                            }
                            if (tokenFields[j].getType().isAssignableFrom(Timestamp.class)) {
                                tokenFields[j].set(token, rs.getTimestamp(i));
                                continue;
                            }
                            try {
                                tokenFields[j].set(token, rs.getObject(i));
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                            continue;
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                }
                foundResult = true;
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(rs);
            JdbcUtils.closeStatement((Statement)ps);
            throw throwable;
        }
        JdbcUtils.closeResultSet((ResultSet)rs);
        JdbcUtils.closeStatement((Statement)ps);
        return password;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        if (principals == null) {
            throw new AuthorizationException("PrincipalCollection method argument cannot be null.");
        }
        String username = (String)this.getAvailablePrincipal(principals);
        Connection conn = null;
        Set<String> roleNames = null;
        Set<String> permissions = null;
        try {
            conn = this.dataSource.getConnection();
            roleNames = this.getRoleNamesForUser(conn, username);
            if (this.permissionsLookupEnabled) {
                permissions = this.getPermissions(conn, username, roleNames);
            }
        }
        catch (SQLException e) {
            String message = "There was a SQL error while authorizing user [" + username + "]";
            if (log.isErrorEnabled()) {
                log.error(message, (Throwable)e);
            }
            throw new AuthorizationException(message, (Throwable)e);
        }
        finally {
            JdbcUtils.closeConnection((Connection)conn);
        }
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo(roleNames);
        info.setStringPermissions(permissions);
        this.interceptor.afterDoGetAuthorizationInfo(info);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getRoleNamesForUser(Connection conn, String username) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedHashSet<String> roleNames = new LinkedHashSet<String>();
        try {
            ps = conn.prepareStatement(this.userRolesQuery);
            int paramCount = ps.getParameterMetaData().getParameterCount();
            for (int i = 1; i <= paramCount; ++i) {
                ps.setString(i, username);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                String roleName = rs.getString(1);
                if (roleName != null) {
                    roleNames.add(roleName);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn("Null role name found while retrieving role names for user [" + username + "]");
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(rs);
            JdbcUtils.closeStatement((Statement)ps);
            throw throwable;
        }
        JdbcUtils.closeResultSet((ResultSet)rs);
        JdbcUtils.closeStatement((Statement)ps);
        return roleNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getPermissions(Connection conn, String username, Collection<String> roleNames) throws SQLException {
        PreparedStatement ps = null;
        LinkedHashSet<String> permissions = new LinkedHashSet<String>();
        try {
            ps = conn.prepareStatement(this.permissionsQuery);
            int paramCount = ps.getParameterMetaData().getParameterCount();
            for (int i = 1; i <= paramCount; ++i) {
                ps.setString(i, username);
            }
            ResultSet rs = null;
            try {
                rs = ps.executeQuery();
                while (rs.next()) {
                    String permissionString = rs.getString(1);
                    if (permissionString == null || permissionString.trim().equals("")) continue;
                    permissions.add(permissionString);
                }
            }
            finally {
                JdbcUtils.closeResultSet((ResultSet)rs);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeStatement(ps);
            throw throwable;
        }
        JdbcUtils.closeStatement((Statement)ps);
        return permissions;
    }

    public void setPasswordColumn(String passwordColumn) {
        this.passwordColumn = passwordColumn;
    }

    public void setInterceptor(EasyJdbcRealmInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public static void reloadPermissions(EasyJdbcRealm easyJdbcRealm) {
        if (easyJdbcRealm != null) {
            easyJdbcRealm.clearCachedAuthorizationInfo(SecurityUtils.getSubject().getPrincipals());
        }
    }
}

