/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easyshiro;

import cn.easyproject.easyshiro.EasyAuthenticationInterceptor;
import cn.easyproject.easyshiro.EasyIncorrectCaptchaException;
import cn.easyproject.easyshiro.EasyLockIPException;
import cn.easyproject.easyshiro.EasyLockLoginException;
import cn.easyproject.easyshiro.EasyLockUser;
import cn.easyproject.easyshiro.EasyLockUserException;
import cn.easyproject.easyshiro.EasyShiroUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.Cache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.PersistenceConfiguration;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.cache.ehcache.EhCacheManager;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.codec.CodecSupport;
import org.apache.shiro.crypto.AesCipherService;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ByteSource;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyFormAuthenticationFilter
extends FormAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(EasyFormAuthenticationFilter.class);
    static AesCipherService aes = new AesCipherService();
    static byte[] keyEncode;
    public static final String DEFAULT_ENABLE_CAPTCAH = "true";
    private String enableCaptcha = "true";
    public static final String DEFAULT_CAPTCHA_PARAM = "captcha";
    private String captchaParam = "captcha";
    public static final String DEFAULT_SESSION_CAPTCHA_KEY = "captcha";
    private String sessionCaptchaKey = "captcha";
    public static final String DEFAULT_ENABLE_AUTO_LOGIN = "true";
    private String enableAutoLogin = "true";
    public static final String DEFAULT_AUTO_LOGIN_PARAM = "autologin";
    private String autoLoginParam = "autologin";
    public static final int DEFAULT_AUTO_LOGIN_MAXAGE = 31536000;
    private int autoLoginMaxAge = 31536000;
    public static final String DEFAULT_AUTO_LOGIN_PATH = "/";
    private String autoLoginPath = "/";
    public static final String DEFAULT_AUTO_LOGIN_DOMAIN = "";
    private String autoLoginDomain = "";
    public static final String DEFAULT_SESSION_TOKEN_KEY = "TOKEN";
    private String sessionTokenKey = "TOKEN";
    public static final String DEFAULT_LOGIN_FAILURE_REDIRECT_TO_LOGIN = "false";
    public String loginFailureRedirectToLogin = "false";
    public static final String DEFAULT_SESSION_MSG = "false";
    private String sessionMsg = "false";
    public static final String DEFAULT_REQUEST_MSG = "false";
    private String requestMsg = "false";
    public static final String DEFAULT_MSG_KEY = "MSG";
    private String msgKey = "MSG";
    private Map<String, String> exceptionMsg = new HashMap<String, String>();
    private static final String autoLoginNameCookie = "easyshiro_n";
    private static final String autoLoginPwdCookie = "easyshiro_p";
    private EasyAuthenticationInterceptor interceptor;
    private String tokenClassName = "org.apache.shiro.authc.UsernamePasswordToken";
    private String enableLockLogin = "false";
    private EhCacheManager ehcacheManager;
    private String lockLoginCacheName = "shiro-lockLoginCache";
    private String lockCheckCacheName = "shiro-lockCheckCache";
    private int userLock = 6;
    private int ipLock = 15;
    private int showCaptcha = 1;
    private org.apache.shiro.cache.Cache<String, EasyLockUser> lockCache;
    private org.apache.shiro.cache.Cache<String, AtomicInteger> checkCache;
    private long lockseconds;

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        UsernamePasswordToken token = this.createToken(request, response);
        if (token == null) {
            String msg = "createToken method implementation returned null. A valid non-null AuthenticationToken must be created in order to execute a login attempt.";
            throw new IllegalStateException(msg);
        }
        HttpServletRequest req = (HttpServletRequest)request;
        String ip = req.getRemoteAddr();
        if (EasyShiroUtils.isTrue(this.enableLockLogin)) {
            int status = this.lockLoginOnLoginCheck(token.getUsername(), ip);
            EasyLockLoginException e = null;
            if (status == 1) {
                e = new EasyLockIPException("IP locked.");
            } else if (status == 2) {
                e = new EasyLockUserException("User locked.");
            }
            if (status != 0) {
                if (this.interceptor != null) {
                    this.interceptor.afterFailure(request, response, (AuthenticationToken)token, (Exception)((Object)e));
                }
                return this.onLoginFailure((AuthenticationToken)token, e, request, response);
            }
        }
        if (EasyShiroUtils.isTrue(this.enableCaptcha)) {
            String userCaptcha = this.getCaptcha(request);
            String captcha = req.getSession().getAttribute(this.sessionCaptchaKey) + DEFAULT_AUTO_LOGIN_DOMAIN;
            String key = "captcha:" + ip.toLowerCase();
            if (EasyShiroUtils.isTrue(this.enableLockLogin)) {
                if (this.showCaptcha == -1 || this.checkCache.get((Object)key) != null && ((AtomicInteger)this.checkCache.get((Object)key)).intValue() >= this.showCaptcha) {
                    if (userCaptcha != null && userCaptcha.equalsIgnoreCase(captcha)) {
                        return this.login(request, response, token, ip);
                    }
                    this.lockLoginOnLoginFailure(token.getUsername(), ip, false);
                    EasyIncorrectCaptchaException e = new EasyIncorrectCaptchaException("Incorrect Captcha!");
                    if (this.interceptor != null) {
                        this.interceptor.afterFailure(request, response, (AuthenticationToken)token, (Exception)((Object)e));
                    }
                    return this.onLoginFailure((AuthenticationToken)token, (AuthenticationException)e, request, response);
                }
                return this.login(request, response, token, ip);
            }
            if (userCaptcha != null && userCaptcha.equalsIgnoreCase(captcha)) {
                return this.login(request, response, token, ip);
            }
            this.lockLoginOnLoginFailure(token.getUsername(), ip, false);
            EasyIncorrectCaptchaException e = new EasyIncorrectCaptchaException("Incorrect Captcha!");
            if (this.interceptor != null) {
                this.interceptor.afterFailure(request, response, (AuthenticationToken)token, (Exception)((Object)e));
            }
            return this.onLoginFailure((AuthenticationToken)token, (AuthenticationException)e, request, response);
        }
        return this.login(request, response, token, ip);
    }

    private boolean login(ServletRequest request, ServletResponse response, UsernamePasswordToken token, String ip) throws Exception {
        Subject subject = this.getSubject(request, response);
        try {
            subject.login((AuthenticationToken)token);
            subject.getSession().setAttribute((Object)this.sessionTokenKey, (Object)token);
            if (this.interceptor != null) {
                this.interceptor.afterSuccess(request, response, (AuthenticationToken)token);
            }
            if (EasyShiroUtils.isTrue(this.enableAutoLogin)) {
                this.autoLoginSave(request, response, token);
            }
            if (EasyShiroUtils.isTrue(this.enableLockLogin)) {
                this.lockLoginOnLoginSuccess(token.getUsername(), ip);
            }
            return this.onLoginSuccess((AuthenticationToken)token, subject, request, response);
        }
        catch (AuthenticationException e) {
            this.lockLoginOnLoginFailure(token.getUsername(), ip, true);
            subject.logout();
            if (this.interceptor != null) {
                this.interceptor.afterFailure(request, response, (AuthenticationToken)token, (Exception)((Object)e));
            }
            return this.onLoginFailure((AuthenticationToken)token, e, request, response);
        }
        catch (Exception e) {
            this.lockLoginOnLoginFailure(token.getUsername(), ip, true);
            subject.logout();
            if (this.interceptor != null) {
                this.interceptor.afterFailure(request, response, (AuthenticationToken)token, e);
            }
            return this.onLoginFailure((AuthenticationToken)token, new AuthenticationException(e.getMessage()), request, response);
        }
    }

    protected void autoLoginSave(ServletRequest request, ServletResponse response, UsernamePasswordToken token) {
        String autoLogin = WebUtils.getCleanParam((ServletRequest)request, (String)this.getAutoLoginParam());
        if (EasyShiroUtils.isTrue(autoLogin)) {
            HttpServletResponse rep = (HttpServletResponse)response;
            String name = token.getUsername();
            String pwd = new String(token.getPassword());
            ByteSource encrypted = aes.encrypt(name.getBytes(), keyEncode);
            name = Base64.encodeToString((byte[])encrypted.getBytes());
            encrypted = aes.encrypt(pwd.getBytes(), keyEncode);
            pwd = Base64.encodeToString((byte[])encrypted.getBytes());
            Cookie nameCookie = new Cookie(autoLoginNameCookie, name);
            nameCookie.setMaxAge(this.autoLoginMaxAge);
            nameCookie.setPath(this.autoLoginPath);
            Cookie passwordCookie = new Cookie(autoLoginPwdCookie, pwd);
            passwordCookie.setMaxAge(this.autoLoginMaxAge);
            passwordCookie.setPath(this.autoLoginPath);
            if (StringUtils.hasText((String)this.autoLoginDomain)) {
                nameCookie.setDomain(this.autoLoginDomain);
                passwordCookie.setDomain(this.autoLoginDomain);
            }
            rep.addCookie(nameCookie);
            rep.addCookie(passwordCookie);
        }
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest req, ServletResponse rsp) {
        String exceptionClassName;
        Session session = this.getSubject(req, rsp).getSession();
        if (EasyShiroUtils.isTrue(this.sessionMsg) && e != null) {
            exceptionClassName = ((Object)((Object)e)).getClass().getSimpleName();
            if (e instanceof EasyIncorrectCaptchaException) {
                session.setAttribute((Object)this.msgKey, (Object)this.exceptionMsg.get("EasyIncorrectCaptchaException"));
            } else if (e instanceof EasyLockUserException) {
                session.setAttribute((Object)this.msgKey, (Object)this.exceptionMsg.get("EasyLockUserException"));
            } else if (e instanceof EasyLockIPException) {
                session.setAttribute((Object)this.msgKey, (Object)this.exceptionMsg.get("EasyLockIPException"));
            } else if (e instanceof AuthenticationException) {
                if (this.exceptionMsg.get(exceptionClassName) != null) {
                    session.setAttribute((Object)this.msgKey, (Object)this.exceptionMsg.get(exceptionClassName));
                } else {
                    session.setAttribute((Object)this.msgKey, (Object)this.exceptionMsg.get(AuthenticationException.class.getSimpleName()));
                }
            }
        }
        if (EasyShiroUtils.isTrue(this.requestMsg) && e != null) {
            exceptionClassName = ((Object)((Object)e)).getClass().getSimpleName();
            if (e instanceof EasyIncorrectCaptchaException) {
                req.setAttribute(this.msgKey, (Object)this.exceptionMsg.get("EasyIncorrectCaptchaException"));
            } else if (e instanceof EasyLockUserException) {
                req.setAttribute(this.msgKey, (Object)this.exceptionMsg.get("EasyLockUserException"));
            } else if (e instanceof EasyLockIPException) {
                req.setAttribute(this.msgKey, (Object)this.exceptionMsg.get("EasyLockIPException"));
            } else if (e instanceof AuthenticationException) {
                if (this.exceptionMsg.get(exceptionClassName) != null) {
                    req.setAttribute(this.msgKey, (Object)this.exceptionMsg.get(exceptionClassName));
                } else {
                    req.setAttribute(this.msgKey, (Object)this.exceptionMsg.get(AuthenticationException.class.getSimpleName()));
                }
            }
        }
        if (EasyShiroUtils.isTrue(this.loginFailureRedirectToLogin)) {
            try {
                session.setAttribute((Object)"shiroLoginFailure", (Object)((Object)((Object)e)).getClass().getName());
                WebUtils.redirectToSavedRequest((ServletRequest)req, (ServletResponse)rsp, (String)this.getSuccessUrl());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        return super.onLoginFailure(token, e, req, rsp);
    }

    public void clearAutoLoginCookie(ServletResponse response) {
        HttpServletResponse rep = (HttpServletResponse)response;
        String name = DEFAULT_AUTO_LOGIN_DOMAIN;
        String pwd = DEFAULT_AUTO_LOGIN_DOMAIN;
        Cookie nameCookie = new Cookie(autoLoginNameCookie, name);
        nameCookie.setMaxAge(0);
        nameCookie.setPath(this.autoLoginPath);
        Cookie passwordCookie = new Cookie(autoLoginPwdCookie, pwd);
        passwordCookie.setMaxAge(0);
        passwordCookie.setPath(this.autoLoginPath);
        if (StringUtils.hasText((String)this.autoLoginDomain)) {
            nameCookie.setDomain(this.autoLoginDomain);
            passwordCookie.setDomain(this.autoLoginDomain);
        }
        rep.addCookie(nameCookie);
        rep.addCookie(passwordCookie);
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        HttpServletRequest req = (HttpServletRequest)request;
        String ip = req.getRemoteAddr();
        Subject subject = this.getSubject(request, response);
        if (EasyShiroUtils.isTrue(this.enableLockLogin)) {
            if (this.showCaptcha >= 0) {
                if (this.checkCache.get((Object)("captcha:" + ip.toLowerCase())) != null && ((AtomicInteger)this.checkCache.get((Object)("captcha:" + ip.toLowerCase()))).intValue() >= this.showCaptcha) {
                    req.getSession().setAttribute("ShowCAPTCHA", (Object)"true");
                } else {
                    req.getSession().removeAttribute("ShowCAPTCHA");
                }
            }
            if (this.ipLock != 0) {
                String name = "ip:" + ip.toLowerCase();
                if (this.lockCache.get((Object)name) != null) {
                    req.getSession().setAttribute("IPLock", (Object)"true");
                } else {
                    req.getSession().removeAttribute("IPLock");
                }
            }
        }
        if (this.isLoginSubmission(request, response)) {
            return false;
        }
        if (EasyShiroUtils.isTrue(this.enableAutoLogin) && !subject.isAuthenticated()) {
            Cookie[] cookies = req.getCookies();
            String username = null;
            String password = null;
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (cookie.getName().equalsIgnoreCase(autoLoginNameCookie)) {
                        username = cookie.getValue();
                        continue;
                    }
                    if (!cookie.getName().equalsIgnoreCase(autoLoginPwdCookie)) continue;
                    password = cookie.getValue();
                }
                if (username != null && password != null) {
                    ByteSource decrypted = aes.decrypt(Base64.decode(username), keyEncode);
                    username = CodecSupport.toString((byte[])decrypted.getBytes());
                    decrypted = aes.decrypt(Base64.decode((String)password), keyEncode);
                    password = CodecSupport.toString((byte[])decrypted.getBytes());
                    try {
                        UsernamePasswordToken token = this.createToken(request, username, password);
                        try {
                            subject.getSession().setAttribute((Object)"EasyShiro_AutoLogin", (Object)"true");
                            subject.login((AuthenticationToken)token);
                            subject.getSession().removeAttribute((Object)"EasyShiro_AutoLogin");
                            subject.getSession().setAttribute((Object)this.sessionTokenKey, (Object)token);
                            if (this.interceptor != null) {
                                this.interceptor.afterSuccess(request, response, (AuthenticationToken)token);
                            }
                            this.onLoginSuccess((AuthenticationToken)token, subject, request, response);
                            return true;
                        }
                        catch (AuthenticationException e) {
                            this.clearAutoLoginCookie(response);
                            subject.logout();
                            if (this.interceptor != null) {
                                this.interceptor.afterFailure(request, response, (AuthenticationToken)token, (Exception)((Object)e));
                            }
                            this.onLoginFailure((AuthenticationToken)token, e, request, response);
                        }
                        catch (Exception e) {
                            this.clearAutoLoginCookie(response);
                            e.printStackTrace();
                            subject.logout();
                            if (this.interceptor != null) {
                                this.interceptor.afterFailure(request, response, (AuthenticationToken)token, e);
                            }
                            this.onLoginFailure((AuthenticationToken)token, new AuthenticationException(e.getMessage()), request, response);
                        }
                    }
                    catch (Exception e) {
                        this.clearAutoLoginCookie(response);
                        e.printStackTrace();
                    }
                }
            }
        }
        boolean flag = super.isAccessAllowed(request, response, mappedValue) || !this.isLoginRequest(request, response) && this.isPermissive(mappedValue);
        return flag;
    }

    protected UsernamePasswordToken createToken(ServletRequest request, ServletResponse response) {
        try {
            UsernamePasswordToken token = (UsernamePasswordToken)Class.forName(this.tokenClassName).newInstance();
            String password = this.getPassword(request);
            token.setUsername(this.getUsername(request));
            token.setPassword(password != null ? password.toCharArray() : null);
            token.setRememberMe(this.isRememberMe(request));
            token.setHost(this.getHost(request));
            return token;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected UsernamePasswordToken createToken(ServletRequest request, String username, String password) {
        try {
            UsernamePasswordToken token = (UsernamePasswordToken)Class.forName(this.tokenClassName).newInstance();
            token.setUsername(username);
            token.setPassword(password != null ? password.toCharArray() : null);
            token.setHost(this.getHost(request));
            return token;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected String getCaptcha(ServletRequest request) {
        return WebUtils.getCleanParam((ServletRequest)request, (String)this.getCaptchaParam());
    }

    public String getCaptchaParam() {
        return this.captchaParam;
    }

    public void setCaptchaParam(String captchaParam) {
        this.captchaParam = captchaParam;
    }

    public String getSessionTokenKey() {
        return this.sessionTokenKey;
    }

    public void setSessionTokenKey(String sessionTokenKey) {
        this.sessionTokenKey = sessionTokenKey;
    }

    public String getMsgKey() {
        return this.msgKey;
    }

    public void setMsgKey(String msgKey) {
        this.msgKey = msgKey;
    }

    public String getLoginFailureRedirectToLogin() {
        return this.loginFailureRedirectToLogin;
    }

    public void setLoginFailureRedirectToLogin(String loginFailureRedirectToLogin) {
        this.loginFailureRedirectToLogin = loginFailureRedirectToLogin;
    }

    public String getSessionMsg() {
        return this.sessionMsg;
    }

    public void setSessionMsg(String sessionMsg) {
        this.sessionMsg = sessionMsg;
    }

    public String getRequestMsg() {
        return this.requestMsg;
    }

    public void setRequestMsg(String requestMsg) {
        this.requestMsg = requestMsg;
    }

    public void setSessionCaptchaKey(String sessionCaptchaKey) {
        this.sessionCaptchaKey = sessionCaptchaKey;
    }

    public void setInterceptor(EasyAuthenticationInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public String getTokenClassName() {
        return this.tokenClassName;
    }

    public void setTokenClassName(String tokenClassName) {
        this.tokenClassName = tokenClassName;
    }

    public void setEnableCaptcha(String enableCaptcha) {
        this.enableCaptcha = enableCaptcha;
    }

    public String getEnableCaptcha() {
        return this.enableCaptcha;
    }

    public String getSessionCaptchaKey() {
        return this.sessionCaptchaKey;
    }

    public EasyAuthenticationInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void setEnableAutoLogin(String enableAutoLogin) {
        this.enableAutoLogin = enableAutoLogin;
    }

    public void setAutoLoginParam(String autoLoginParam) {
        this.autoLoginParam = autoLoginParam;
    }

    public void setAutoLoginPath(String autoLoginPath) {
        this.autoLoginPath = autoLoginPath;
    }

    public void setAutoLoginDomain(String autoLoginDomain) {
        this.autoLoginDomain = autoLoginDomain;
    }

    public String getAutoLoginParam() {
        return this.autoLoginParam;
    }

    public void setAutoLoginMaxAge(int autoLoginMaxAge) {
        this.autoLoginMaxAge = autoLoginMaxAge;
    }

    private int lockLoginOnLoginCheck(String username, String ip) {
        if (this.lockCache.get((Object)("ip:" + ip.toLowerCase())) != null) {
            return 1;
        }
        if (this.lockCache.get((Object)("user:" + username.toLowerCase())) != null) {
            return 2;
        }
        return 0;
    }

    private void lockLoginOnLoginFailure(String username, String ip, boolean loginerror) {
        String name;
        if (loginerror) {
            if (this.ipLock != 0) {
                name = "ip:" + ip.toLowerCase();
                if (this.checkCache.get((Object)name) != null) {
                    ((AtomicInteger)this.checkCache.get((Object)name)).incrementAndGet();
                } else {
                    this.checkCache.put((Object)name, (Object)new AtomicInteger(1));
                }
                if (((AtomicInteger)this.checkCache.get((Object)name)).intValue() >= this.ipLock) {
                    this.lockCache.put((Object)name, (Object)new EasyLockUser(name, this.lockseconds));
                }
            }
            if (this.userLock != 0) {
                name = "user:" + username.toLowerCase();
                if (this.checkCache.get((Object)name) != null) {
                    ((AtomicInteger)this.checkCache.get((Object)name)).incrementAndGet();
                } else {
                    this.checkCache.put((Object)name, (Object)new AtomicInteger(1));
                }
                if (((AtomicInteger)this.checkCache.get((Object)name)).intValue() >= this.userLock) {
                    this.lockCache.put((Object)name, (Object)new EasyLockUser(name, this.lockseconds));
                }
            }
        }
        if (this.showCaptcha != -1) {
            name = "captcha:" + ip.toLowerCase();
            if (this.checkCache.get((Object)name) != null) {
                ((AtomicInteger)this.checkCache.get((Object)name)).incrementAndGet();
            } else {
                this.checkCache.put((Object)name, (Object)new AtomicInteger(1));
            }
        }
    }

    private void lockLoginOnLoginSuccess(String username, String ip) {
        String name;
        if (this.ipLock != 0 && this.checkCache.get((Object)(name = "ip:" + ip.toLowerCase())) != null) {
            this.checkCache.remove((Object)name);
        }
        if (this.userLock != 0 && this.checkCache.get((Object)(name = "user:" + username.toLowerCase())) != null) {
            this.checkCache.remove((Object)name);
        }
        if (this.showCaptcha != 0 && this.checkCache.get((Object)(name = "captcha:" + ip.toLowerCase())) != null) {
            this.checkCache.remove((Object)name);
        }
    }

    public void setEnableLockLogin(String enableLockLogin) {
        this.enableLockLogin = enableLockLogin;
    }

    public EhCacheManager getEhcacheManager() {
        return this.ehcacheManager;
    }

    public void setEhCacheManager(EhCacheManager ehcacheManager) {
        Cache cache;
        int diskExpiryThreadIntervalSeconds;
        int timeToIdleSeconds;
        int timeToLiveSeconds;
        boolean eternal;
        int maxElementsInMemory;
        this.ehcacheManager = ehcacheManager;
        if (!ehcacheManager.getCacheManager().cacheExists(this.lockCheckCacheName)) {
            maxElementsInMemory = 100000;
            eternal = false;
            timeToLiveSeconds = 0;
            timeToIdleSeconds = 600;
            diskExpiryThreadIntervalSeconds = 600;
            cache = new Cache(new CacheConfiguration(this.lockCheckCacheName, maxElementsInMemory).eternal(eternal).timeToLiveSeconds((long)timeToLiveSeconds).timeToIdleSeconds((long)timeToIdleSeconds).diskExpiryThreadIntervalSeconds((long)diskExpiryThreadIntervalSeconds).persistence(new PersistenceConfiguration().strategy(PersistenceConfiguration.Strategy.LOCALTEMPSWAP)));
            ehcacheManager.getCacheManager().addCache(cache);
            log.warn("Missing configuration 'lockCheckCacheName', Please check ehcache.xml or Spring configuration.");
            log.warn("EasyShiro already created lockCheckCacheName: name='" + this.lockCheckCacheName + "' maxElementsInMemory='100000' eternal='false' timeToLiveSeconds='0' timeToIdleSeconds='600' persistence='LOCALTEMPSWAP' diskExpiryThreadIntervalSeconds='600'");
        }
        this.checkCache = ehcacheManager.getCache(this.lockCheckCacheName);
        if (!ehcacheManager.getCacheManager().cacheExists(this.lockLoginCacheName)) {
            maxElementsInMemory = 100000;
            eternal = false;
            timeToLiveSeconds = 0;
            timeToIdleSeconds = 7200;
            diskExpiryThreadIntervalSeconds = 600;
            cache = new Cache(new CacheConfiguration(this.lockLoginCacheName, maxElementsInMemory).eternal(eternal).timeToLiveSeconds((long)timeToLiveSeconds).timeToIdleSeconds((long)timeToIdleSeconds).diskExpiryThreadIntervalSeconds((long)diskExpiryThreadIntervalSeconds).persistence(new PersistenceConfiguration().strategy(PersistenceConfiguration.Strategy.LOCALTEMPSWAP)));
            ehcacheManager.getCacheManager().addCache(cache);
            log.warn("Missing configuration 'lockLoginCacheName', Please check ehcache.xml or Spring configuration.");
            log.warn("EasyShiro already created lockLoginCacheName: [name='" + this.lockLoginCacheName + "' maxElementsInMemory='100000' eternal='false' timeToLiveSeconds='0' timeToIdleSeconds='7200' persistence='LOCALTEMPSWAP' diskExpiryThreadIntervalSeconds='600']");
        }
        this.lockCache = ehcacheManager.getCache(this.lockLoginCacheName);
        this.lockseconds = ehcacheManager.getCacheManager().getCache(this.lockLoginCacheName).getCacheConfiguration().getTimeToIdleSeconds();
    }

    public String getLockLoginCacheName() {
        return this.lockLoginCacheName;
    }

    public void setLockLoginCacheName(String lockLoginCacheName) {
        this.lockLoginCacheName = lockLoginCacheName;
    }

    public String getLockCheckCacheName() {
        return this.lockCheckCacheName;
    }

    public void setLockCheckCacheName(String lockCheckCacheName) {
        this.lockCheckCacheName = lockCheckCacheName;
    }

    public int getUserLock() {
        return this.userLock;
    }

    public void setUserLock(int userLock) {
        this.userLock = userLock;
    }

    public int getIpLock() {
        return this.ipLock;
    }

    public void setIpLock(int ipLock) {
        this.ipLock = ipLock;
    }

    public int getShowCaptcha() {
        return this.showCaptcha;
    }

    public void setShowCaptcha(int showCaptcha) {
        this.showCaptcha = showCaptcha;
    }

    public Map<String, String> getExceptionMsg() {
        return this.exceptionMsg;
    }

    public void setExceptionMsg(Map<String, String> exceptionMsg) {
        this.exceptionMsg = exceptionMsg;
    }

    static {
        String base64AESGeneratedKey = "BVwJgkqMzX3tJLYQ7l8k2g==";
        keyEncode = Base64.decode((String)base64AESGeneratedKey);
    }
}

