package cn.easyproject.easyshiro;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 用户锁定信息
 * @author Ray
 * @author inthinkcolor@gmail.com
 * @author easyproject.cn
 * @since 2.1.0
 */
public class EasyLockUser implements Serializable{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private String name; //账户名称
	private AtomicInteger count=new AtomicInteger(1); 
	private long expire; //到期时间,毫秒数
	
	public EasyLockUser(String name,long lockseconds) {
		super();
		this.name = name;
		this.expire=new Date().getTime()+lockseconds*1000;
	}
	public String getName() {
		return name;
	}
	//count增加
	public void addCount(){
		count.incrementAndGet();
	}
	//修改过期时间
	public void changeExpire(long lockseconds){
		expire=new Date().getTime()+lockseconds*1000;
	}
	public AtomicInteger getCount() {
		return count;
	}
	public long getExpire() {
		return expire;
	}
	
	
}
