package cn.easyproject.easyshiro;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.ehcache.EhCacheManager;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.codec.CodecSupport;
import org.apache.shiro.crypto.AesCipherService;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ByteSource;
import org.apache.shiro.util.StringUtils;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.PersistenceConfiguration;

/**
 * 带验证码的表单登录验证过滤器, 扩展了 Shiro 默认的 FormAuthenticationFilter <br>
 * 密码使用MD5加密, 用户名为salt:new MD5Hash(pwd,username).toHex()
 * 
 * @author Ray
 * @author inthinkcolor@gmail.com
 * @author easyproject.cn
 * @since 1.0.0
 */
public class EasyFormAuthenticationFilter extends FormAuthenticationFilter {
	
    private static final Logger log = LoggerFactory.getLogger(EasyFormAuthenticationFilter.class);
	
	
	static AesCipherService aes=new AesCipherService();
	static byte[] keyEncode;
	static{
		 String base64AESGeneratedKey="BVwJgkqMzX3tJLYQ7l8k2g==";
		 keyEncode= Base64.decode(base64AESGeneratedKey);
	}
	
	/*
	 * CAPTCHA
	 */
	// 是否开启验证码
	public static final String DEFAULT_ENABLE_CAPTCAH = "true";
	private String enableCaptcha = DEFAULT_ENABLE_CAPTCAH;

	// 验证码参数名
	public static final String DEFAULT_CAPTCHA_PARAM = "captcha";
	private String captchaParam = DEFAULT_CAPTCHA_PARAM;

	// Session中存储验证码值的key；default 'captcha'
	public static final String DEFAULT_SESSION_CAPTCHA_KEY = "captcha";
	private String sessionCaptchaKey = DEFAULT_SESSION_CAPTCHA_KEY;

	/*
	 * AutoLogin 自动登录, 登录成功后, 下次可以自动登录
	 */

	// 是否开启AutoLogin自动登录
	public static final String DEFAULT_ENABLE_AUTO_LOGIN = "true";
	private String enableAutoLogin = DEFAULT_ENABLE_AUTO_LOGIN;

	// AutoLogin自动登录参数数名
	public static final String DEFAULT_AUTO_LOGIN_PARAM = "autologin";
	private String autoLoginParam = DEFAULT_AUTO_LOGIN_PARAM;

	// AutoLogin Cookie maxAge, default is ONE_YEAR
	public static final int DEFAULT_AUTO_LOGIN_MAXAGE = 31536000;
	private int autoLoginMaxAge = DEFAULT_AUTO_LOGIN_MAXAGE;

	// AutoLogin Cookie path, default is "/"
	public static final String DEFAULT_AUTO_LOGIN_PATH = "/";
	private String autoLoginPath = DEFAULT_AUTO_LOGIN_PATH;

	// AutoLogin Cookie domain, empty or default is your current domain name
	public static final String DEFAULT_AUTO_LOGIN_DOMAIN = "";
	private String autoLoginDomain = DEFAULT_AUTO_LOGIN_DOMAIN;

	/**
	 * Login Configuration
	 */
	// 登录成功, 将 token 存入 session 的 key ；default 'TOKEN'
	public static final String DEFAULT_SESSION_TOKEN_KEY = "TOKEN";
	private String sessionTokenKey = DEFAULT_SESSION_TOKEN_KEY;

	// 是否使用登录失败重定向功能, 如果开启登录失败后会重定向回登录页面, 防止刷新重复登录
	// 消息参数可配置
	public static final String DEFAULT_LOGIN_FAILURE_REDIRECT_TO_LOGIN = "false";
	public String loginFailureRedirectToLogin = DEFAULT_LOGIN_FAILURE_REDIRECT_TO_LOGIN;

	/*
	 * MSG
	 */
	// Session 消息存储
	// 登录有错误时, 会向session存入错误消息 session.setAttribute(msgName,xxxErrorMsg)
	public static final String DEFAULT_SESSION_MSG = "false";
	private String sessionMsg = DEFAULT_SESSION_MSG;
	public static final String DEFAULT_REQUEST_MSG = "false";
	private String requestMsg = DEFAULT_REQUEST_MSG;

	// Session 存储的消息名
	public static final String DEFAULT_MSG_KEY = "MSG";
	private String msgKey = DEFAULT_MSG_KEY;

	// 消息内容
	// ExceptionClassName:Message
	private Map<String, String> exceptionMsg=new HashMap<String, String>();
	
	private static final String autoLoginNameCookie = "easyshiro_n";
	private static final String autoLoginPwdCookie = "easyshiro_p";

	// 自定义认证拦截器
	private EasyAuthenticationInterceptor interceptor;

	/*
	 * User defined UsernamePasswordToken
	 */
	// 自定义UsernamePasswordToken；Default is
	// 'org.apache.shiro.authc.UsernamePasswordToken'
	private String tokenClassName = "org.apache.shiro.authc.UsernamePasswordToken";

	@Override
	/**
	 * 执行登录
	 */
	protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {

		// 创建 Token
		UsernamePasswordToken token = createToken(request, response);

		if (token == null) {
			String msg = "createToken method implementation returned null. A valid non-null AuthenticationToken "
					+ "must be created in order to execute a login attempt.";
			throw new IllegalStateException(msg);
		}
		
		HttpServletRequest req=((HttpServletRequest) request);
		String ip=req.getRemoteAddr();
		
		// 开启锁定登录功能
		if(EasyShiroUtils.isTrue(enableLockLogin)){
			int status= lockLoginOnLoginCheck(token.getUsername(), ip);
			
			EasyLockLoginException e=null;
			
			if(status==EasyLockLoginStatus.IP_LOCK){
				e=new EasyLockIPException("IP locked.");
				
			}else if(status==EasyLockLoginStatus.USER_LOCK){
				e=new EasyLockUserException("User locked.");
			}
//			else if(status==EasyLockLoginStatus.CAPTCHA_LOCK){
//				e=new EasyShiroShowCaptchaException("show captcha.");
//			}
			// 如果登录锁定
			if(status!=EasyLockLoginStatus.NORMAL){
				// 认证失败拦截器
				if (interceptor != null) {
					interceptor.afterFailure(request, response, token, e);
				}
				return onLoginFailure(token, e, request, response);
			}
		}
		
		// 1. 如果开启了验证码
		if(EasyShiroUtils.isTrue(enableCaptcha)){
			
			// 验证码判断
			String userCaptcha = getCaptcha(request);
			String captcha = req.getSession().getAttribute(sessionCaptchaKey) + "";
//		if ((!EasyShiroUtils.isTrue(requestMsg)) || (userCaptcha != null && userCaptcha.equalsIgnoreCase(captcha))) {
			
			
			String key="captcha:"+ip.toLowerCase();
			// 1.2. 如果开启 LockLogin 登录锁定
			if(EasyShiroUtils.isTrue(enableLockLogin) ){
				
				// 验证码不控制或达到验证码显示次数，才验证验证码
				if(showCaptcha==-1||(checkCache.get(key)!=null && checkCache.get(key).intValue()>=showCaptcha)){
					// 1.1. 如果没有开启 LockLogin 登录锁定，直接验证验证码
					if ((userCaptcha != null && userCaptcha.equalsIgnoreCase(captcha))) {
						return login(request, response, token, ip);
					} else {
						// 验证码失败，不计入登录错误，只记录验证码错误
						lockLoginOnLoginFailure(token.getUsername(), ip, false);
						AuthenticationException e = new EasyIncorrectCaptchaException("Incorrect Captcha!");
						// 认证失败拦截器
						if (interceptor != null) {
							interceptor.afterFailure(request, response, token, e);
						}
						return onLoginFailure(token, e, request, response);
					}
				}else{
					// 没有达到验证码显示次数，不用验证验证码，直接登录验证
					return login(request, response, token, ip);
					
				}
				
					
			}else{
				// 1.1. 如果没有开启 LockLogin 登录锁定，直接验证验证码
				if ((userCaptcha != null && userCaptcha.equalsIgnoreCase(captcha))) {
					return login(request, response, token, ip);
				} else {
					// 验证码失败，不计入登录错误，只记录验证码错误
					lockLoginOnLoginFailure(token.getUsername(), ip, false);
					AuthenticationException e = new EasyIncorrectCaptchaException("Incorrect Captcha!");
					// 认证失败拦截器
					if (interceptor != null) {
						interceptor.afterFailure(request, response, token, e);
					}
					return onLoginFailure(token, e, request, response);
				}
			}
			
		}else{
			// 2. 如果没有开启验证码，直接登录
			return login(request, response, token, ip);
		}
		
		
		

	}

	
	private boolean login(ServletRequest request, ServletResponse response,UsernamePasswordToken token,String ip) throws Exception{
		Subject subject = getSubject(request, response);
		try {

			subject.login(token);

			// TODO 存储用户信息 token 到 Session, 作为认证标识
			subject.getSession().setAttribute(sessionTokenKey, token);
			
			

			// 认证成功拦截器
			if (interceptor != null) {
				interceptor.afterSuccess(request, response, token);
			}

			// TODO autologin 登录成功, 判断自动登录
			if (EasyShiroUtils.isTrue(enableAutoLogin)) {
				autoLoginSave(request, response, token);
			}
			
			// 开启锁定登录功能
			if(EasyShiroUtils.isTrue(enableLockLogin)){
				lockLoginOnLoginSuccess(token.getUsername(), ip);
			}
			
			
			return onLoginSuccess(token, subject, request, response);
		} catch (AuthenticationException e) {
			// TODO 删除输出测试
//			e.printStackTrace();
//			log.error("登录认证错误",e);
			lockLoginOnLoginFailure(token.getUsername(), ip, true);
			
			subject.logout();
			// 认证失败拦截器
			if (interceptor != null) {
				interceptor.afterFailure(request, response, token, e);
			}
			return onLoginFailure(token, e, request, response);
		} catch (Exception e) {
//			e.printStackTrace();
//			log.error("登录发生其他错误",e);
			lockLoginOnLoginFailure(token.getUsername(), ip, true);
			subject.logout();
			
			// 认证失败拦截器
			if (interceptor != null) {
				interceptor.afterFailure(request, response, token, e);
			}
			return onLoginFailure(token, new AuthenticationException(e.getMessage()), request, response);
		}
	}
	
	/**
	 * 自动登录信息保存处理
	 * @param request
	 * @param response
	 * @param token
	 */
	protected void autoLoginSave(ServletRequest request, ServletResponse response, UsernamePasswordToken token) {
		
		String autoLogin = WebUtils.getCleanParam(request, getAutoLoginParam());
		// 提交了自动登录参数, 并为true
		if (EasyShiroUtils.isTrue(autoLogin)) {
			HttpServletResponse rep = (HttpServletResponse) response;

			String name = token.getUsername();
			String pwd = new String(token.getPassword());
			
			
			// 加密字节： 
			ByteSource encrypted = aes.encrypt(name.getBytes(), keyEncode);
			name=Base64.encodeToString(encrypted.getBytes()); 
			
			encrypted = aes.encrypt(pwd.getBytes(), keyEncode);
			pwd=Base64.encodeToString(encrypted.getBytes()); 

			Cookie nameCookie = new Cookie(autoLoginNameCookie, name);
			nameCookie.setMaxAge(autoLoginMaxAge);
			nameCookie.setPath(autoLoginPath);

			Cookie passwordCookie = new Cookie(autoLoginPwdCookie, pwd);
			passwordCookie.setMaxAge(autoLoginMaxAge);
			passwordCookie.setPath(autoLoginPath);

			if (StringUtils.hasText(autoLoginDomain)) {
				nameCookie.setDomain(autoLoginDomain);
				passwordCookie.setDomain(autoLoginDomain);
			}

			rep.addCookie(nameCookie);
			rep.addCookie(passwordCookie);
		}
	}

	@Override
	/*
	 * 登录失败, 自行重定向跳转, 并在Session存储错误消息
	 */

	protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest req,
			ServletResponse rsp) {
		
//		lockInfo();
		
		Session session=getSubject(req, rsp).getSession();
//		session.setAttribute("EASYSHIRO_DONT_AUTOLOGIN", "true");
		// 是否开启消息存入session
		if (EasyShiroUtils.isTrue(sessionMsg)) {
			if(e!=null){
				
				String exceptionClassName=e.getClass().getSimpleName();
				
				
				if (e instanceof EasyIncorrectCaptchaException) {
					session.setAttribute(msgKey, exceptionMsg.get("EasyIncorrectCaptchaException"));
				} else if (e instanceof EasyLockUserException) {
					session.setAttribute(msgKey, exceptionMsg.get("EasyLockUserException"));
				} else if (e instanceof EasyLockIPException) {
					session.setAttribute(msgKey, exceptionMsg.get("EasyLockIPException"));
				} 
//				 else if (e instanceof LockedAccountException) {
//						session.setAttribute(msgKey, exceptionMsg.get("LockedAccountException"));
//					}
				else if (e instanceof AuthenticationException) {
					if(exceptionMsg.get(exceptionClassName)!=null){
						session.setAttribute(msgKey, exceptionMsg.get(exceptionClassName));
					}else{
						session.setAttribute(msgKey, exceptionMsg.get(AuthenticationException.class.getSimpleName()));
					}
				} 
			}
		}
		// 是否开启消息存入request
		if (EasyShiroUtils.isTrue(requestMsg)) {
			if(e!=null){
				
				String exceptionClassName=e.getClass().getSimpleName();
				
				if (e instanceof EasyIncorrectCaptchaException) {
					req.setAttribute(msgKey, exceptionMsg.get("EasyIncorrectCaptchaException"));
				} else if (e instanceof EasyLockUserException) {
					req.setAttribute(msgKey, exceptionMsg.get("EasyLockUserException"));
				} else if (e instanceof EasyLockIPException) {
					req.setAttribute(msgKey, exceptionMsg.get("EasyLockIPException"));
				} 
//				 else if (e instanceof LockedAccountException) {
//						session.setAttribute(msgKey, exceptionMsg.get("LockedAccountException"));
//					}
				else if (e instanceof AuthenticationException) {
					if(exceptionMsg.get(exceptionClassName)!=null){
						req.setAttribute(msgKey, exceptionMsg.get(exceptionClassName));
					}else{
						req.setAttribute(msgKey, exceptionMsg.get(AuthenticationException.class.getSimpleName()));
					}
				} 
				
			}
		}
		// 是否开启登录失败重定向功能
		if (EasyShiroUtils.isTrue(loginFailureRedirectToLogin)) {
			try {
				session.setAttribute("shiroLoginFailure", e.getClass().getName());
				// 自行重定向
				WebUtils.redirectToSavedRequest(req, rsp, getSuccessUrl());
			} catch (IOException e1) {
				e1.printStackTrace();
			}
			// 不用继续返回到登录页面
			return false;
		} else {
			// 未开启登录失败重定向, 默认方式处理
			return super.onLoginFailure(token, e, req, rsp);
		}

	}

	/**
	 * 清除自动登录Cookie
	 * 
	 * @param response
	 */
	public void clearAutoLoginCookie(ServletResponse response) {

		HttpServletResponse rep = (HttpServletResponse) response;

		String name = "";
		String pwd = "";

		Cookie nameCookie = new Cookie(autoLoginNameCookie, name);
		nameCookie.setMaxAge(0);
		nameCookie.setPath(autoLoginPath);

		Cookie passwordCookie = new Cookie(autoLoginPwdCookie, pwd);
		passwordCookie.setMaxAge(0);
		passwordCookie.setPath(autoLoginPath);

		if (StringUtils.hasText(autoLoginDomain)) {
			nameCookie.setDomain(autoLoginDomain);
			passwordCookie.setDomain(autoLoginDomain);
		}

		rep.addCookie(nameCookie);
		rep.addCookie(passwordCookie);
	}

	@Override
	protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
		// // 非登录请求, 正常转交到下一个
		// if(!WebUtils.getPathWithinApplication((HttpServletRequest)request).equals(getLoginUrl())){
			// return true;
		// }

		HttpServletRequest req = (HttpServletRequest) request;
		String ip=req.getRemoteAddr();

		// 如果是登录请求, 则不允许继续向下请求, 直接进行登录处理
//		System.out.println("#############" + req.getRequestURI() + " 1. 判断是继续请求, 还是先去登录处理, 或登录界面");
		Subject subject = getSubject(request, response);
//		System.out.println(subject.isAuthenticated());
//		System.out.println("############# " + mappedValue);
//		System.out.println("#############" + isLoginSubmission(request, response));
//		System.out.println("############# " + (super.isAccessAllowed(request, response, mappedValue)
//				|| (!isLoginRequest(request, response) && isPermissive(mappedValue))));

		
		// 如果开启登录锁定功能，检查是否显示验证码
		if(EasyShiroUtils.isTrue(enableLockLogin)){
			// 正数，进行验证码控制
			if(showCaptcha>=0){
				// 如果需要显示验证码
				if(checkCache.get("captcha:"+ip.toLowerCase())!=null&&checkCache.get("captcha:"+ip.toLowerCase()).intValue()>=showCaptcha){
					req.getSession().setAttribute("ShowCAPTCHA", "true");
				}else{
					req.getSession().removeAttribute("ShowCAPTCHA");
				}
			}
			// 不为0，检测IP是否锁定
			if(ipLock!=0){
				String name="ip:"+ip.toLowerCase();
				// IP被锁定
				if(lockCache.get(name)!=null){
					req.getSession().setAttribute("IPLock", "true");
				}else{
					req.getSession().removeAttribute("IPLock");
				}
			}
//			else{
//				// 负数，不进行验证码控制
//			}
		}
		
		
		if (isLoginSubmission(request, response)) {
			return false;
		}

		// 如果是登录注销，仅清除会话，不删除自动登录Cookie
//		if (subject.getSession().getAttribute("EASYSHIRO_DONT_AUTOLOGIN") == null) {

			// 开了自动登录，没有权限，进行自动登录判断
			if (EasyShiroUtils.isTrue(enableAutoLogin) && (!subject.isAuthenticated())) {

				Cookie[] cookies = req.getCookies();
				String username = null;
				String password = null;

				if (cookies != null) {
					for (Cookie cookie : cookies) {
						if (cookie.getName().equalsIgnoreCase(autoLoginNameCookie)) {
							username = cookie.getValue();
						} else if (cookie.getName().equalsIgnoreCase(autoLoginPwdCookie)) {
							password = cookie.getValue();
						}
					}

					if (username != null && password != null) {
						
						// 解密
						
						// 解密字节： 
						ByteSource decrypted=aes.decrypt(Base64.decode(username), keyEncode);
						username=CodecSupport.toString(decrypted.getBytes());
						
						decrypted=aes.decrypt(Base64.decode(password), keyEncode);
						password=CodecSupport.toString(decrypted.getBytes());
						// 尝试登录
						try {
							UsernamePasswordToken token = createToken(request, username, password);
							try {

								subject.getSession().setAttribute("EasyShiro_AutoLogin", "true");
								subject.login(token);
								subject.getSession().removeAttribute("EasyShiro_AutoLogin");

								// TODO 存储用户信息 token 到 Session, 作为认证标识
								subject.getSession().setAttribute(sessionTokenKey, token);

								// 认证成功拦截器
								if (interceptor != null) {
									interceptor.afterSuccess(request, response, token);
								}

								// TODO autologin 登录成功, 判断自动登录
								// if(EasyShiroUtils.isTrue(enableAutoLogin)){
								// autoLogin(request, response, token);
								// }
//								System.out.println("自动登录成功");
								onLoginSuccess(token, subject, request, response);
								return true;
							} catch (AuthenticationException e) {
								clearAutoLoginCookie(response);
								// TODO 删除输出测试
//								System.out.println(e);

								subject.logout();

								// 认证失败拦截器
								if (interceptor != null) {
									interceptor.afterFailure(request, response, token, e);
								}
								onLoginFailure(token, e, request, response);
							} catch (Exception e) {
								clearAutoLoginCookie(response);
								e.printStackTrace();
								subject.logout();
								// 认证失败拦截器
								if (interceptor != null) {
									interceptor.afterFailure(request, response, token, e);
									;
								}
								onLoginFailure(token, new AuthenticationException(e.getMessage()), request, response);
							}
						} catch (Exception e) {
							clearAutoLoginCookie(response);
							e.printStackTrace();
						}

					}
				}

			}
//		}else{
//			subject.getSession().removeAttribute("EASYSHIRO_DONT_AUTOLOGIN");
//		}

		// 如果是没有权限的请求, 则不允许继续向下请求, 直接跳到登录页面
		boolean flag = super.isAccessAllowed(request, response, mappedValue)
				|| (!isLoginRequest(request, response) && isPermissive(mappedValue));

		return flag;
	}

	@Override
	/**
	 * 重写createToken, Token 加入captcha
	 */
	protected UsernamePasswordToken createToken(ServletRequest request, ServletResponse response) {

		try {
			UsernamePasswordToken token = (UsernamePasswordToken) Class.forName(tokenClassName).newInstance();
			String password = getPassword(request);
			token.setUsername(getUsername(request));
			token.setPassword(password != null ? password.toCharArray() : null);
			token.setRememberMe(isRememberMe(request));
			token.setHost(getHost(request));
			return token;
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * 自动登录创建Token
	 */
	protected UsernamePasswordToken createToken(ServletRequest request, String username, String password) {
		UsernamePasswordToken token;
		try {
			token = (UsernamePasswordToken) Class.forName(tokenClassName).newInstance();
			token.setUsername(username);
			token.setPassword(password != null ? password.toCharArray() : null);
			// token.setRememberMe(isRememberMe(request));
			token.setHost(getHost(request));
			return token;
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		}

		return null;
	}

	/**
	 * 获得captcha
	 * 
	 * @param request
	 *            request
	 * @return cpatcha 值
	 */
	protected String getCaptcha(ServletRequest request) {
		// 获得参数值
		return WebUtils.getCleanParam(request, getCaptchaParam());
	}

	public String getCaptchaParam() {
		return captchaParam;
	}

	public void setCaptchaParam(String captchaParam) {
		this.captchaParam = captchaParam;
	}

	public String getSessionTokenKey() {
		return sessionTokenKey;
	}

	public void setSessionTokenKey(String sessionTokenKey) {
		this.sessionTokenKey = sessionTokenKey;
	}

	public String getMsgKey() {
		return msgKey;
	}

	public void setMsgKey(String msgKey) {
		this.msgKey = msgKey;
	}

	
	public String getLoginFailureRedirectToLogin() {
		return loginFailureRedirectToLogin;
	}

	public void setLoginFailureRedirectToLogin(String loginFailureRedirectToLogin) {
		this.loginFailureRedirectToLogin = loginFailureRedirectToLogin;
	}

	public String getSessionMsg() {
		return sessionMsg;
	}

	public void setSessionMsg(String sessionMsg) {
		this.sessionMsg = sessionMsg;
	}

	public String getRequestMsg() {
		return requestMsg;
	}

	public void setRequestMsg(String requestMsg) {
		this.requestMsg = requestMsg;
	}

	public void setSessionCaptchaKey(String sessionCaptchaKey) {
		this.sessionCaptchaKey = sessionCaptchaKey;
	}

	public void setInterceptor(EasyAuthenticationInterceptor interceptor) {
		this.interceptor = interceptor;
	}

	public String getTokenClassName() {
		return tokenClassName;
	}

	public void setTokenClassName(String tokenClassName) {
		this.tokenClassName = tokenClassName;
	}

	public void setEnableCaptcha(String enableCaptcha) {
		this.enableCaptcha = enableCaptcha;
	}

	public String getEnableCaptcha() {
		return enableCaptcha;
	}

	public String getSessionCaptchaKey() {
		return sessionCaptchaKey;
	}

	public EasyAuthenticationInterceptor getInterceptor() {
		return interceptor;
	}

	public void setEnableAutoLogin(String enableAutoLogin) {
		this.enableAutoLogin = enableAutoLogin;
	}

	public void setAutoLoginParam(String autoLoginParam) {
		this.autoLoginParam = autoLoginParam;
	}

	public void setAutoLoginPath(String autoLoginPath) {
		this.autoLoginPath = autoLoginPath;
	}

	public void setAutoLoginDomain(String autoLoginDomain) {
		this.autoLoginDomain = autoLoginDomain;
	}

	public String getAutoLoginParam() {
		return autoLoginParam;
	}

	public void setAutoLoginMaxAge(int autoLoginMaxAge) {
		this.autoLoginMaxAge = autoLoginMaxAge;
	}

	// 是否开启用户登录锁定；默认为false，不开启
	private String enableLockLogin="false";
	
	// Shiro CacheManager
	private EhCacheManager ehcacheManager;

	// LockLogin 管理锁定时间周期的 EHCache 缓存名称；默认为 shiro-lockLoginCache
	private String lockLoginCacheName = "shiro-lockLoginCache";
	// LockLogin 统计登录错误次数时间周期的 EHCache 缓存名称；默认为 shiro-lockCheckCache
	private String lockCheckCacheName = "shiro-lockCheckCache";

	// 同一用户名登录达到登录错误次数，登录锁定；0为不限制；默认为6
	private int userLock = 6;
	// 同一IP登录达到错误次数，登录锁定；0为不限制；默认为15
	private int ipLock = 15;

	// 达到指定登录错误次数，显示验证码；-1为不控制验证码显示；默认为1
	private int showCaptcha = 1;
	

	
	// 统计错误次数的缓存 和 锁定用户信息的缓存，缓存对象
	private Cache<String, EasyLockUser> lockCache;
	private Cache<String, AtomicInteger> checkCache;


	
	
	/**
	 * 检测当前登录状态：正常登录，ip锁定，用户名锁定，或显示验证码
	 * @param username
	 * @param ip
	 * @return
	 */
	private int lockLoginOnLoginCheck(String username,String ip){
		// 1. 登录前进行锁定及验证码显示检测
		if(lockCache.get("ip:"+ip.toLowerCase())!=null ){
			return EasyLockLoginStatus.IP_LOCK;
		}else if(lockCache.get("user:"+username.toLowerCase())!=null ){
			return EasyLockLoginStatus.USER_LOCK;
		}
//		else if(checkCache.get("captcha:"+ip).getCount()> ){
//			return EasyLockLoginStatus.CAPTCHA_LOCK;
//		}else 
		{
			return EasyLockLoginStatus.NORMAL;
		}
	}
	
	
	/**
	 * 登录失败,进行 LockLogin 检测
	 * @param username
	 * @param ip
	 * @param loginerror
	 */
	private void lockLoginOnLoginFailure(String username,String ip, boolean loginerror){
		// 2. 登录失败，记录错误统计信息；检测信息，是否进入锁定
		if(loginerror){
			if(ipLock!=0){
				String name="ip:"+ip.toLowerCase();
				if(checkCache.get(name)!=null){
					checkCache.get(name).incrementAndGet();
				}else{
					checkCache.put(name, new AtomicInteger(1));
				}
				// 移入锁定缓存
				if(checkCache.get(name).intValue()>=ipLock){
					lockCache.put(name, new EasyLockUser(name,lockseconds));
				}
			}
			
			if(userLock!=0){
				String name="user:"+username.toLowerCase();
				if(checkCache.get(name)!=null){
					checkCache.get(name).incrementAndGet();
				}else{
					checkCache.put(name,  new AtomicInteger(1));
				}
				// 移入锁定缓存
				if(checkCache.get(name).intValue()>=userLock){
					lockCache.put(name, new EasyLockUser(name,lockseconds));
				}
			}
		}
		
		
		// 基于 IP 的验证码显示检测
		if(showCaptcha!=-1){
			String name="captcha:"+ip.toLowerCase();
			if(checkCache.get(name)!=null){
				checkCache.get(name).incrementAndGet();
			}else{
				checkCache.put(name,  new AtomicInteger(1));
			}
		}
		
	}
	
	
	/**
	 * 登录成功
	 * @param username
	 * @param ip
	 */
	private void lockLoginOnLoginSuccess(String username,String ip){
		// 3. 登录成功，移除用户名和ip锁定检测数据，下次重新统计
		if(ipLock!=0){
			String name="ip:"+ip.toLowerCase();
			if(checkCache.get(name)!=null){
				checkCache.remove(name);
			}
		}
		
		if(userLock!=0){
			String name="user:"+username.toLowerCase();
			if(checkCache.get(name)!=null){
				checkCache.remove(name);
			}
		}
		// 基于 IP 的验证码显示检测
		if(showCaptcha!=0){
			String name="captcha:"+ip.toLowerCase();
			if(checkCache.get(name)!=null){
				checkCache.remove(name);
			}
		}
	}




	public void setEnableLockLogin(String enableLockLogin) {
		this.enableLockLogin = enableLockLogin;
	}

	public EhCacheManager getEhcacheManager() {
		return ehcacheManager;
	}



	public void setEhCacheManager(EhCacheManager ehcacheManager) {
//		this.ehcacheManager = ehcacheManager;
		
		this.ehcacheManager=ehcacheManager;
		
		
		
		 if(!ehcacheManager.getCacheManager().cacheExists(lockCheckCacheName)){
//			checkCache = ehcacheManager.getCache(lockCheckCacheName);
//		}else{
			 
//			String name=lockCheckCacheName;
			int	   maxElementsInMemory=100000;
//			boolean	       overflowToDisk=true;
			boolean   eternal=false;
			int       timeToLiveSeconds=0;
			int    timeToIdleSeconds=600;
//			boolean      diskPersistent=true;
			int     diskExpiryThreadIntervalSeconds=600;
				  
			net.sf.ehcache.Cache cache = new net.sf.ehcache.Cache(
					new CacheConfiguration(lockCheckCacheName, maxElementsInMemory)
					.eternal(eternal)
					.timeToLiveSeconds(timeToLiveSeconds)
					.timeToIdleSeconds(timeToIdleSeconds)
					.diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds)
					// diskPersistent + overflow
//					localTempSwap：当堆内存或者非堆内存里面的元素已经满了的时候，将其中的元素临时的存放在磁盘上，一旦重启就会消失。
//					localRestartable：该策略只对企业版Ehcache有用。它可以在重启的时候将堆内存或者非堆内存里面的元素持久化到硬盘上，重启之后再从硬盘上恢复元素到内存中。
//					none：不持久化缓存的元素
//					distributed：该策略不适用于单机，是用于分布式的。
					.persistence(
							new PersistenceConfiguration()
							.strategy(PersistenceConfiguration
							.Strategy.LOCALTEMPSWAP)))
					;
			
			ehcacheManager.getCacheManager().addCache(cache);
			
//			checkCache=new EhCache<String,AtomicInteger>(cache);
			log.warn("Missing configuration 'lockCheckCacheName', Please check ehcache.xml or Spring configuration.");
			log.warn("EasyShiro already created lockCheckCacheName: name='"+lockCheckCacheName+"' maxElementsInMemory='100000' eternal='false' timeToLiveSeconds='0' timeToIdleSeconds='600' persistence='LOCALTEMPSWAP' diskExpiryThreadIntervalSeconds='600'");
//			throw new EasyShiroLockLoginException("Missing configuration 'lockCheckCacheName', Please check ehcache.xml or Spring configuration.");
		}
		 
		checkCache=ehcacheManager.getCache(lockCheckCacheName);
		if(!ehcacheManager.getCacheManager().cacheExists(lockLoginCacheName)){
//			lockCache = ehcacheManager.getCache(lockLoginCacheName);
//		}else{
//			String name=lockLoginCacheName;
			int	   maxElementsInMemory=100000;
//			boolean	       overflowToDisk=true;
			boolean   eternal=false;
			int       timeToLiveSeconds=0;
			int    timeToIdleSeconds=7200;
//			boolean      diskPersistent=true;
			int     diskExpiryThreadIntervalSeconds=600;
				  
			net.sf.ehcache.Cache cache = new net.sf.ehcache.Cache(
					new CacheConfiguration(lockLoginCacheName, maxElementsInMemory)
					.eternal(eternal)
					.timeToLiveSeconds(timeToLiveSeconds)
					.timeToIdleSeconds(timeToIdleSeconds)
					.diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds)
					// diskPersistent + overflow
//					localTempSwap：当堆内存或者非堆内存里面的元素已经满了的时候，将其中的元素临时的存放在磁盘上，一旦重启就会消失。
//					localRestartable：该策略只对企业版Ehcache有用。它可以在重启的时候将堆内存或者非堆内存里面的元素持久化到硬盘上，重启之后再从硬盘上恢复元素到内存中。
//					none：不持久化缓存的元素
//					distributed：该策略不适用于单机，是用于分布式的。
					.persistence(
							new PersistenceConfiguration()
							.strategy(PersistenceConfiguration
							.Strategy.LOCALTEMPSWAP)))
					;
			ehcacheManager.getCacheManager().addCache(cache);
			
			
//			lockCache=new EhCache<String,EasyLockUser>(cache);
			log.warn("Missing configuration 'lockLoginCacheName', Please check ehcache.xml or Spring configuration.");
			log.warn("EasyShiro already created lockLoginCacheName: [name='"+lockLoginCacheName+"' maxElementsInMemory='100000' eternal='false' timeToLiveSeconds='0' timeToIdleSeconds='7200' persistence='LOCALTEMPSWAP' diskExpiryThreadIntervalSeconds='600']");
			//			throw new EasyShiroLockLoginException("Missing configuration 'lockLoginCacheName', Please check ehcache.xml or Spring configuration.");
		}
		lockCache=ehcacheManager.getCache(lockLoginCacheName);
		lockseconds=ehcacheManager.getCacheManager().getCache(lockLoginCacheName).getCacheConfiguration().getTimeToIdleSeconds();
		
	}

	private long lockseconds;


	public String getLockLoginCacheName() {
		return lockLoginCacheName;
	}



	public void setLockLoginCacheName(String lockLoginCacheName) {
		this.lockLoginCacheName = lockLoginCacheName;
	}



	public String getLockCheckCacheName() {
		return lockCheckCacheName;
	}



	public void setLockCheckCacheName(String lockCheckCacheName) {
		this.lockCheckCacheName = lockCheckCacheName;
	}



	public int getUserLock() {
		return userLock;
	}



	public void setUserLock(int userLock) {
		this.userLock = userLock;
	}



	public int getIpLock() {
		return ipLock;
	}



	public void setIpLock(int ipLock) {
		this.ipLock = ipLock;
	}



	public int getShowCaptcha() {
		return showCaptcha;
	}



	public void setShowCaptcha(int showCaptcha) {
		this.showCaptcha = showCaptcha;
	}


	public Map<String, String> getExceptionMsg() {
		return exceptionMsg;
	}


	public void setExceptionMsg(Map<String, String> exceptionMsg) {
		this.exceptionMsg = exceptionMsg;
	}





//	
//	// TODO xxx
//	public void lockInfo(){
//		lockIPInfo();
//		lockUserInfo();
//	}
	
	

//	public void lockIPInfo(){
//		System.out.println("######################LockLogin###########################");
//		Set<String> keys= lockCache.keys();
//		
//		for (String key:keys) {
//			if(key.startsWith("ip:")){
//				EasyLockUser elu=lockCache.get(key);
//				System.out.println(key+"  "+new Date(elu.getExpire()));
//			}
//		}
//		System.out.println("######################LockLogin End###########################");
//		
//	}
//	public void lockUserInfo(){
//		System.out.println("######################LockLogin###########################");
//		Set<String> keys= lockCache.keys();
//	
//		for (String key:keys) {
//			if(key.startsWith("user:")){
//				EasyLockUser elu=lockCache.get(key);
//				System.out.println(key+"  "+new Date(elu.getExpire()));
//			}
//		}
//		System.out.println("######################LockLogin End###########################");
//	}
	
//	/**
//	 * 清除所有锁定用户和IP信息
//	 */
//	public void lockClear(){
//		lockCache.clear();
//	}
//	
//	/**
//	 * 清除锁定的用户信息
//	 * @param username 用户名
//	 */
//	public void unlockUser(String username){
//		String name="user:"+username;
//		lockCache.remove(name);
//	}
//	
//	/**
//	 * 清除锁定的 IP 信息
//	 * @param ip ip地址
//	 */
//	public void unlockIP(String ip){
//		String name="ip:"+ip;
//		lockCache.remove(name);
//	}
//	
//	/**
//	 * 查询锁定用户的锁定到期时间
//	 * @param username 用户名
//	 * @return 到期时间
//	 */
//	public Date getUserLockInfo(String username){
//		String name="user:"+username;
//		EasyLockUser user=lockCache.get(name);
//		if(user!=null){
//			return new Date(user.getExpire());
//		}
//		return null;
//	}
//	/**
//	 * 查询锁定IP的锁定到期时间
//	 * @param ip 用户名
//	 * @return 到期时间
//	 */
//	public Date getIPLockInfo(String ip){
//		String name="ip:"+ip;
//		EasyLockUser user=lockCache.get(name);
//		if(user!=null){
//			return new Date(user.getExpire());
//		}
//		return null;
//	}
	
	
	
	
}
