package cn.easyproject.easyshiro;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.shiro.authc.AuthenticationToken;

/**
 * 认证拦截器，可以在认证成功或失败后进行自定义代码处理
 * @author Ray
 * @author inthinkcolor@gmail.com
 * @author easyproject.cn
 * @since 1.0.0
 */
public interface EasyAuthenticationInterceptor {

	/**
	 * 认证成功后执行
	 * @param request 请求
	 * @param response 响应
	 * @param token 认证令牌
	 */
	public void afterSuccess(ServletRequest request, ServletResponse response,AuthenticationToken token)  throws Exception;
	/**
	 * 认证失败后执行
	 * @param request 请求
	 * @param response 响应
	 * @param token 认证令牌
	 */
	public void afterFailure(ServletRequest request, ServletResponse response,AuthenticationToken token,Exception e) throws Exception;
}
