/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.shirorediscache;

import cn.easyproject.shirorediscache.RedisCache;
import cn.easyproject.shirorediscache.RedisManager;
import cn.easyproject.shirorediscache.RedisTemplateCache;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCacheManager
implements CacheManager {
    private static final Logger logger = LoggerFactory.getLogger(RedisCacheManager.class);
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private RedisManager redisManager;
    private RedisTemplate<String, Object> redisTemplate;
    private String keyPrefix = "shiro_redis_cache:";

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        logger.debug("\u83b7\u53d6\u540d\u79f0\u4e3a: " + name + " \u7684RedisCache\u5b9e\u4f8b");
        Object c = (RedisTemplateCache)this.caches.get(name);
        if (c == null) {
            if (this.redisTemplate != null) {
                c = new RedisTemplateCache(this.redisTemplate, this.keyPrefix);
                this.caches.put(name, (Cache)c);
            } else {
                this.redisManager.init();
                c = new RedisCache(this.redisManager, this.keyPrefix);
                this.caches.put(name, (Cache)c);
            }
        }
        return c;
    }

    public RedisManager getRedisManager() {
        return this.redisManager;
    }

    public void setRedisManager(RedisManager redisManager) {
        this.redisManager = redisManager;
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

