/*
 * Decompiled with CFR 0.152.
 */
package cn.easyproject.easymybatis.pagination;

import cn.easyproject.easymybatis.pagination.EasyCriteria;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageBean<T>
implements Serializable {
    private static final long serialVersionUID = 5229229913348492552L;
    private int dialect = -1;
    public static final int ORACLE_DIALECT = 1;
    public static final int ORACLE_12C_DIALECT = 10;
    public static final int SQLSERVER_DIALECT = 2;
    public static final int SQLSERVER_2012_DIALECT = 20;
    public static final int MYSQL_DIALECT = 3;
    private static final int DEFAULT_PAGE_NO = 1;
    private static final int DEFAULT_ROWS_PER_PAGE = 10;
    private static final String DEFAULT_SELECT = "*";
    private static final String DEFAULT_SORT_ORDER = "ASC";
    private int pageNo = 1;
    private int pageTotal;
    private int rowsCount;
    private int rowsPerPage = 10;
    private List<T> data;
    private int rowStart;
    private String select = "*";
    private String from = "";
    private String primaryTable = "";
    private StringBuffer conditions = new StringBuffer();
    private String sortOrder = "ASC";
    private String sort = "";
    private String lastSort = "";
    private String sql;
    private String countSQL;
    private Map<String, Object> sqlParameterValues = new HashMap<String, Object>();
    EasyCriteria easyCriteria;

    public void setRowsCount(int rowsCount) {
        this.rowsCount = rowsCount;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public String getAutoSQL() {
        if (this.isNotNullOrEmpty(this.sql)) {
            return this.parameterHandler(this.sql);
        }
        int start = (this.pageNo - 1) * this.rowsPerPage;
        int end = start + this.rowsPerPage;
        StringBuilder sql = new StringBuilder("");
        if (this.dialect == 3) {
            sql.append("SELECT ").append(this.select).append(" FROM ").append(this.from).append(" WHERE 1=1 ");
            if (this.isNotNullOrEmpty(this.conditions.toString())) {
                sql.append(this.conditions);
            }
            if (this.easyCriteria != null) {
                sql.append(this.easyCriteria.getCondition());
            }
            if (this.isNotNullOrEmpty(this.sort)) {
                sql.append(" ORDER BY ").append(this.sort);
                if (this.isNotNullOrEmpty(this.sortOrder)) {
                    sql.append(" " + this.sortOrder);
                }
                if (this.isNotNullOrEmpty(this.lastSort) && this.lastSort.trim().length() != 0) {
                    sql.append("," + this.lastSort);
                }
            } else if (this.isNotNullOrEmpty(this.lastSort) && this.lastSort.trim().length() != 0) {
                sql.append(" ORDER BY " + this.lastSort);
            }
            sql.append(" LIMIT " + start + "," + this.rowsPerPage);
            System.out.println(sql);
        } else if (this.dialect == 2) {
            sql.append("SELECT TOP ").append(this.rowsPerPage).append(this.select).append(" FROM ").append(this.from).append(" WHERE ").append(this.sortOrder).append("  NOT IN(SELECT TOP ").append(String.valueOf(start) + " " + this.sortOrder + " FROM " + this.from + " WHERE 1=1");
            if (this.isNotNullOrEmpty(this.conditions.toString())) {
                sql.append(this.conditions);
            }
            if (this.easyCriteria != null) {
                sql.append(this.easyCriteria.getCondition());
            }
            sql.append(" ORDER BY " + this.sort + " " + this.sortOrder);
            if (this.isNotNullOrEmpty(this.lastSort) && this.lastSort.trim().length() != 0) {
                sql.append("," + this.lastSort);
            }
            sql.append(")");
        } else if (this.dialect == 20) {
            sql.append("SELECT ").append(this.rowsPerPage).append(this.select).append(" FROM ").append(this.from).append(" WHERE 1=1 ");
            if (this.isNotNullOrEmpty(this.conditions.toString())) {
                sql.append(this.conditions);
            }
            if (this.easyCriteria != null) {
                sql.append(this.easyCriteria.getCondition());
            }
            if (this.isNotNullOrEmpty(this.sort)) {
                sql.append(" ORDER BY ").append(this.sort);
                if (this.isNotNullOrEmpty(this.sortOrder)) {
                    sql.append(" " + this.sortOrder);
                }
                if (this.isNotNullOrEmpty(this.lastSort) && this.lastSort.trim().length() != 0) {
                    sql.append("," + this.lastSort);
                }
            } else if (this.isNotNullOrEmpty(this.lastSort) && this.lastSort.trim().length() != 0) {
                sql.append(" ORDER BY " + this.lastSort);
            }
            sql.append(" OFFSET ").append(start).append(" ROWS FETCH NEXT ").append(this.rowsPerPage).append(" ROWS ONLY");
        } else if (this.dialect == 1) {
            sql.append("SELECT B.* FROM ( SELECT A.*,rownum r FROM (").append(" SELECT ").append(this.select).append(" FROM ").append(this.from).append(" WHERE 1=1 ");
            if (this.isNotNullOrEmpty(this.conditions.toString())) {
                sql.append(this.conditions);
            }
            if (this.easyCriteria != null) {
                sql.append(this.easyCriteria.getCondition());
            }
            if (this.isNotNullOrEmpty(this.sort)) {
                sql.append(" ORDER BY ").append(this.sort);
                if (this.isNotNullOrEmpty(this.sortOrder)) {
                    sql.append(" " + this.sortOrder);
                }
                if (this.isNotNullOrEmpty(this.lastSort) && this.lastSort.trim().length() != 0) {
                    sql.append("," + this.lastSort);
                }
                if (this.isNotNullOrEmpty(this.primaryTable)) {
                    sql.append("," + this.primaryTable + ".ROWID");
                } else {
                    sql.append(",ROWID");
                }
            } else if (this.isNotNullOrEmpty(this.lastSort) && this.lastSort.trim().length() != 0) {
                sql.append(" ORDER BY " + this.lastSort);
                if (this.isNotNullOrEmpty(this.primaryTable)) {
                    sql.append("," + this.primaryTable + ".ROWID");
                } else {
                    sql.append(",ROWID");
                }
            } else if (this.isNotNullOrEmpty(this.primaryTable)) {
                sql.append(" ORDER BY " + this.primaryTable + ".ROWID");
            } else {
                sql.append(" ORDER BY ROWID");
            }
            sql.append(") A  WHERE  ROWNUM<=" + end + "  ) B WHERE  B.r>" + start);
        } else if (this.dialect == 10) {
            sql.append("SELECT ").append(this.select).append(" FROM ").append(this.from).append(" WHERE 1=1 ");
            if (this.isNotNullOrEmpty(this.conditions.toString())) {
                sql.append(this.conditions);
            }
            if (this.easyCriteria != null) {
                sql.append(this.easyCriteria.getCondition());
            }
            if (this.isNotNullOrEmpty(this.sort)) {
                sql.append(" ORDER BY ").append(this.sort);
                if (this.isNotNullOrEmpty(this.sortOrder)) {
                    sql.append(" " + this.sortOrder);
                }
                if (this.isNotNullOrEmpty(this.lastSort) && this.lastSort.trim().length() != 0) {
                    sql.append("," + this.lastSort);
                }
                if (this.isNotNullOrEmpty(this.primaryTable)) {
                    sql.append("," + this.primaryTable + ".ROWID");
                } else {
                    sql.append(",ROWID");
                }
            } else if (this.isNotNullOrEmpty(this.lastSort) && this.lastSort.trim().length() != 0) {
                sql.append(" ORDER BY " + this.lastSort);
                if (this.isNotNullOrEmpty(this.primaryTable)) {
                    sql.append("," + this.primaryTable + ".ROWID");
                } else {
                    sql.append(",ROWID");
                }
            } else if (this.isNotNullOrEmpty(this.primaryTable)) {
                sql.append(" ORDER BY " + this.primaryTable + ".ROWID");
            } else {
                sql.append(" ORDER BY ROWID");
            }
            sql.append("OFFSET " + start + " ROWS FETCH FIRST " + this.rowsPerPage + " ROWS ONLY");
        }
        if (this.easyCriteria != null) {
            this.sqlParameterValues = this.easyCriteria.getValues();
        }
        return this.parameterHandler(sql.toString());
    }

    public String getAutoCountSQL() {
        if (this.isNotNullOrEmpty(this.countSQL)) {
            return this.parameterHandler(this.countSQL);
        }
        String countSQL2 = "select count(*) from " + this.from + " where 1=1 ";
        if (this.isNotNullOrEmpty(this.conditions.toString())) {
            countSQL2 = String.valueOf(countSQL2) + this.conditions;
        }
        if (this.easyCriteria != null) {
            countSQL2 = String.valueOf(countSQL2) + this.easyCriteria.getCondition();
        }
        if (this.easyCriteria != null) {
            this.sqlParameterValues = this.easyCriteria.getValues();
        }
        return this.parameterHandler(countSQL2);
    }

    public String getCountSQL() {
        return this.countSQL;
    }

    public void setCountSQL(String countSQL) {
        this.countSQL = countSQL;
    }

    private String parameterHandler(String sql) {
        return sql.replaceAll("\\#\\{[\\ ]*(\\S*)[\\ ]*\\}", "\\#\\{sqlParameterValues\\.$1\\}");
    }

    private boolean isNotNullOrEmpty(String s) {
        return s != null && !s.trim().equals("");
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo < 1 ? 1 : pageNo;
    }

    public int getPageTotal() {
        this.pageTotal = (this.rowsCount - 1) / this.getRowsPerPage() + 1;
        return this.pageTotal;
    }

    public int getRowsCount() {
        return this.rowsCount;
    }

    public int getRowsPerPage() {
        return this.rowsPerPage <= 0 ? 10 : this.rowsPerPage;
    }

    public void setRowsPerPage(int rowsPerPage) {
        this.rowsPerPage = rowsPerPage;
    }

    public List<T> getData() {
        return this.data;
    }

    public int getRowStart() {
        int ret = (this.pageNo - 1) * this.getRowsPerPage();
        return ret < 1 ? 0 : ret;
    }

    private void setRowStart(int rowStart) {
        this.rowStart = rowStart;
    }

    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getCondition() {
        return this.conditions.toString();
    }

    public void setCondition(String condition) {
        this.conditions = new StringBuffer(condition);
    }

    public void addCondition(String condition) {
        this.conditions.append(condition);
    }

    public String getSelect() {
        return this.select;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(String sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getLastSort() {
        return this.lastSort;
    }

    public void setLastSort(String lastSort) {
        this.lastSort = lastSort;
    }

    public EasyCriteria getEasyCriteria() {
        return this.easyCriteria;
    }

    public void setEasyCriteria(EasyCriteria easyCriteria) {
        this.easyCriteria = easyCriteria;
    }

    public Map<String, Object> getSqlParameterValues() {
        return this.sqlParameterValues;
    }

    public void setSqlParameterValues(Map<String, Object> sqlParameterValues) {
        this.sqlParameterValues = sqlParameterValues;
    }

    public String getPrimaryTable() {
        return this.primaryTable;
    }

    public void setPrimaryTable(String primaryTable) {
        this.primaryTable = primaryTable;
    }

    public void setPageTotal(int pageTotal) {
        this.pageTotal = pageTotal;
    }

    public int getDialect() {
        return this.dialect;
    }

    public void setDialect(int dialect) {
        this.dialect = dialect;
    }
}

